/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.serialization;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import com.google.summit.ast.Node;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.declaration.Declaration;
import com.google.summit.ast.declaration.TypeDeclaration;
import com.google.summit.ast.expression.Expression;
import com.google.summit.ast.initializer.Initializer;
import com.google.summit.ast.modifier.ElementValue;
import com.google.summit.ast.modifier.Modifier;
import com.google.summit.ast.statement.Statement;
import com.google.summit.ast.statement.SwitchStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J-\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/summit/serialization/Serializer;", "", "format", "", "removeLocations", "(ZZ)V", "gson", "Lcom/google/gson/Gson;", "deserialize", "T", "Lcom/google/summit/ast/Node;", "nodeType", "Ljava/lang/Class;", "json", "", "(Ljava/lang/Class;Ljava/lang/String;)Lcom/google/summit/ast/Node;", "serialize", "node", "Companion", "-maven_lib"})
public final class Serializer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Gson gson;
    @Deprecated
    @NotNull
    public static final String subtypeLabel = "@type";
    @NotNull
    private static final List<KClass<? extends Node>> polymorphicNodeTypes;

    public Serializer(boolean format, boolean removeLocations) {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping();
        if (format) {
            builder.setPrettyPrinting();
        }
        if (removeLocations) {
            builder.addSerializationExclusionStrategy(new ExclusionStrategy(){

                public boolean shouldSkipField(@NotNull FieldAttributes field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    return false;
                }

                public boolean shouldSkipClass(@NotNull Class<?> c) {
                    Intrinsics.checkNotNullParameter(c, (String)"c");
                    return Intrinsics.areEqual(c, SourceLocation.class);
                }
            });
        }
        Iterable $this$forEach$iv = polymorphicNodeTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it = (KClass)element$iv;
            boolean bl = false;
            builder.registerTypeAdapterFactory((TypeAdapterFactory)Companion.polymorphicFactory(it));
        }
        Gson gson = builder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"builder.create()");
        this.gson = gson;
    }

    public /* synthetic */ Serializer(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @NotNull
    public final String serialize(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = this.gson.toJson((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(node)");
        return string;
    }

    @Nullable
    public final <T extends Node> T deserialize(@NotNull Class<T> nodeType, @NotNull String json) {
        Intrinsics.checkNotNullParameter(nodeType, (String)"nodeType");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Node node = (Node)this.gson.fromJson(json, nodeType);
        if (node != null) {
            Node.Companion.setNodeParents(node);
        }
        return (T)node;
    }

    public Serializer() {
        this(false, false, 3, null);
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Modifier.class), Reflection.getOrCreateKotlinClass(Statement.class), Reflection.getOrCreateKotlinClass(Expression.class), Reflection.getOrCreateKotlinClass(Declaration.class), Reflection.getOrCreateKotlinClass(TypeDeclaration.class), Reflection.getOrCreateKotlinClass(Initializer.class), Reflection.getOrCreateKotlinClass(SwitchStatement.When.class), Reflection.getOrCreateKotlinClass(ElementValue.class)};
        polymorphicNodeTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u00050\u0004\"\b\b\u0000\u0010\f*\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f\"\b\b\u0000\u0010\f*\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/summit/serialization/Serializer$Companion;", "", "()V", "polymorphicNodeTypes", "", "Lkotlin/reflect/KClass;", "Lcom/google/summit/ast/Node;", "getPolymorphicNodeTypes", "()Ljava/util/List;", "subtypeLabel", "", "findSubtypes", "T", "baseType", "polymorphicFactory", "Lcom/google/gson/typeadapters/RuntimeTypeAdapterFactory;", "-maven_lib"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T> List<KClass<? extends T>> findSubtypes(@NotNull KClass<T> baseType) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(baseType, (String)"baseType");
            Iterable $this$filter$iv = com.google.summit.serialization.Serializer$Companion.findSubtypes$find(baseType);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KClass it = (KClass)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, baseType))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final <T extends Node> RuntimeTypeAdapterFactory<T> polymorphicFactory(@NotNull KClass<T> baseType) {
            Intrinsics.checkNotNullParameter(baseType, (String)"baseType");
            List<KClass<T>> subtypes = this.findSubtypes(baseType);
            RuntimeTypeAdapterFactory factory = RuntimeTypeAdapterFactory.of((Class)JvmClassMappingKt.getJavaClass(baseType), (String)Serializer.subtypeLabel);
            Iterable $this$forEach$iv = subtypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KClass it = (KClass)element$iv;
                boolean bl = false;
                factory.registerSubtype(JvmClassMappingKt.getJavaClass((KClass)it));
            }
            Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"factory");
            return factory;
        }

        @NotNull
        public final List<KClass<? extends Node>> getPolymorphicNodeTypes() {
            return polymorphicNodeTypes;
        }

        /*
         * WARNING - void declaration
         */
        private static final <T> List<KClass<? extends T>> findSubtypes$find(KClass<? extends T> cl) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = cl.getSealedSubclasses();
            Collection collection = CollectionsKt.listOf(cl);
            boolean $i$f$flatMap = false;
            void var3_4 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KClass it = (KClass)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = com.google.summit.serialization.Serializer$Companion.findSubtypes$find(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

