/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ>\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u0015J\b\u0010\u001c\u001a\u00020\u0018H\u0016R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/google/summit/ast/SourceLocation;", "", "startLine", "", "startColumn", "endLine", "endColumn", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getEndColumn", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getEndLine", "getStartColumn", "getStartLine", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/google/summit/ast/SourceLocation;", "equals", "", "other", "extractFrom", "", "source", "hashCode", "isUnknown", "toString", "Companion", "-maven_lib"})
public final class SourceLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer startLine;
    @Nullable
    private final Integer startColumn;
    @Nullable
    private final Integer endLine;
    @Nullable
    private final Integer endColumn;
    @NotNull
    private static final SourceLocation UNKNOWN = new SourceLocation(null, null, null, null);

    public SourceLocation(@Nullable Integer startLine, @Nullable Integer startColumn, @Nullable Integer endLine, @Nullable Integer endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    @Nullable
    public final Integer getStartLine() {
        return this.startLine;
    }

    @Nullable
    public final Integer getStartColumn() {
        return this.startColumn;
    }

    @Nullable
    public final Integer getEndLine() {
        return this.endLine;
    }

    @Nullable
    public final Integer getEndColumn() {
        return this.endColumn;
    }

    public final boolean isUnknown() {
        return this.startLine == null;
    }

    @NotNull
    public String toString() {
        return this.isUnknown() ? "<unknown>" : "" + '[' + this.startLine + ':' + this.startColumn + ',' + this.endLine + ':' + this.endColumn + ']';
    }

    @Nullable
    public final String extractFrom(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.isUnknown()) {
            return null;
        }
        List list = StringsKt.lines((CharSequence)source);
        Integer n = this.startLine;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n - 1;
        Integer n3 = this.endLine;
        Intrinsics.checkNotNull((Object)n3);
        List lines = list.subList(n2, n3);
        String joinedLines = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Integer n4 = this.startColumn;
        Intrinsics.checkNotNull((Object)n4);
        int distanceFromStart = n4;
        int n5 = ((String)CollectionsKt.last(lines)).length();
        Integer n6 = this.endColumn;
        Intrinsics.checkNotNull((Object)n6);
        int distanceFromEnd = n5 - n6;
        return StringsKt.dropLast((String)StringsKt.drop((String)joinedLines, (int)distanceFromStart), (int)distanceFromEnd);
    }

    @Nullable
    public final Integer component1() {
        return this.startLine;
    }

    @Nullable
    public final Integer component2() {
        return this.startColumn;
    }

    @Nullable
    public final Integer component3() {
        return this.endLine;
    }

    @Nullable
    public final Integer component4() {
        return this.endColumn;
    }

    @NotNull
    public final SourceLocation copy(@Nullable Integer startLine, @Nullable Integer startColumn, @Nullable Integer endLine, @Nullable Integer endColumn) {
        return new SourceLocation(startLine, startColumn, endLine, endColumn);
    }

    public static /* synthetic */ SourceLocation copy$default(SourceLocation sourceLocation, Integer n, Integer n2, Integer n3, Integer n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = sourceLocation.startLine;
        }
        if ((n5 & 2) != 0) {
            n2 = sourceLocation.startColumn;
        }
        if ((n5 & 4) != 0) {
            n3 = sourceLocation.endLine;
        }
        if ((n5 & 8) != 0) {
            n4 = sourceLocation.endColumn;
        }
        return sourceLocation.copy(n, n2, n3, n4);
    }

    public int hashCode() {
        int result = this.startLine == null ? 0 : ((Object)this.startLine).hashCode();
        result = result * 31 + (this.startColumn == null ? 0 : ((Object)this.startColumn).hashCode());
        result = result * 31 + (this.endLine == null ? 0 : ((Object)this.endLine).hashCode());
        result = result * 31 + (this.endColumn == null ? 0 : ((Object)this.endColumn).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceLocation)) {
            return false;
        }
        SourceLocation sourceLocation = (SourceLocation)other;
        if (!Intrinsics.areEqual((Object)this.startLine, (Object)sourceLocation.startLine)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startColumn, (Object)sourceLocation.startColumn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endLine, (Object)sourceLocation.endLine)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endColumn, (Object)sourceLocation.endColumn);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/summit/ast/SourceLocation$Companion;", "", "()V", "UNKNOWN", "Lcom/google/summit/ast/SourceLocation;", "getUNKNOWN", "()Lcom/google/summit/ast/SourceLocation;", "-maven_lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SourceLocation getUNKNOWN() {
            return UNKNOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

