/*
 * Copyright 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.template.soy.bididirectives;

import com.google.inject.AbstractModule;
import com.google.inject.multibindings.Multibinder;
import com.google.template.soy.shared.restricted.SoyPrintDirective;


/**
 * Guice module for bidi Soy print directives.
 *
 * @author Kai Huang
 */
public class BidiDirectivesModule extends AbstractModule {


  @Override public void configure() {

    Multibinder<SoyPrintDirective> soyDirectivesSetBinder =
        Multibinder.newSetBinder(binder(), SoyPrintDirective.class);
    soyDirectivesSetBinder.addBinding().to(BidiSpanWrapDirective.class);
    soyDirectivesSetBinder.addBinding().to(BidiUnicodeWrapDirective.class);
  }

}
