/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.template.soy.javasrc.dyncompile;


/**
 * A ClassLoader that only contains classes compiled from a single template, so those classes
 * can be garbage collected when a new version becomes available.
 * Cyclic links between Classes and ClassLoaders mean that if we used the caller's
 * ClassLoader, then every template that caller compiled would persist as long as the
 * application even if the resulting SoyTemplateRuntime was garbage collected.
 *
 * @author Mike Samuel
 */
final class SoyTemplateClassLoader extends ClassLoader {

  SoyTemplateClassLoader() {
    super(SoyTemplateClassLoader.class.getClassLoader());
  }


  /**
   * Called by the dynamic compiler to define a class from bytecode generated by javac.
   */
  void defineClassCompiledFromSoy(byte[] classFileContent) {
    defineClass(null, classFileContent, 0, classFileContent.length);
  }

}
