/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSink;
import com.google.common.io.CharSource;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.protobuf.Descriptors;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.SoyModule;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.base.internal.VolatileSoyFileSupplier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcMain;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import com.google.template.soy.jbcsrc.BytecodeCompiler;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.logging.LoggingConfig;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.parseinfo.passes.GenerateParseInfoVisitor;
import com.google.template.soy.passes.ClearSoyDocStringsVisitor;
import com.google.template.soy.passes.FindIjParamsVisitor;
import com.google.template.soy.passes.FindTransitiveDepTemplatesVisitor;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.PySrcMain;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soyparse.PluginResolver;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Logger logger = Logger.getLogger(SoyFileSet.class.getName());
    private final GuiceSimpleScope apiCallScopeProvider;
    private final SoyTypeRegistry typeRegistry;
    private final ImmutableMap<String, SoyFileSupplier> soyFileSuppliers;
    @Nullable
    private final SoyAstCache cache;
    private final SoyGeneralOptions generalOptions;
    private final ValidatedConformanceConfig conformanceConfig;
    private final ValidatedLoggingConfig loggingConfig;
    private ImmutableSet<Long> memoizedExtractedMsgIdsForPruning;
    private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
    private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;
    private ErrorReporter errorReporter;
    @Nullable
    private final Appendable warningSink;

    public static Builder builder() {
        return (Builder)Guice.createInjector((Module[])new Module[]{new SoyModule()}).getInstance(Builder.class);
    }

    SoyFileSet(GuiceSimpleScope apiCallScopeProvider, SoyTypeRegistry typeRegistry, ImmutableMap<String, ? extends SoyFunction> soyFunctionMap, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives, ImmutableMap<String, SoyFileSupplier> soyFileSuppliers, SoyGeneralOptions generalOptions, @Nullable SoyAstCache cache, ValidatedConformanceConfig conformanceConfig, ValidatedLoggingConfig loggingConfig, @Nullable Appendable warningSink) {
        this.apiCallScopeProvider = apiCallScopeProvider;
        Preconditions.checkArgument((!soyFileSuppliers.isEmpty() ? 1 : 0) != 0, (Object)"Must have non-zero number of input Soy files.");
        this.typeRegistry = typeRegistry;
        this.soyFileSuppliers = soyFileSuppliers;
        this.cache = cache;
        this.generalOptions = generalOptions.clone();
        this.soyFunctionMap = soyFunctionMap;
        this.printDirectives = printDirectives;
        this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
        this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)loggingConfig);
        this.warningSink = warningSink;
    }

    @VisibleForTesting
    ImmutableMap<String, SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    ImmutableMap<String, String> generateParseInfo(String javaPackage, String javaClassNameSource) {
        this.resetErrorReporter();
        SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder(SyntaxVersion.V2_0).allowUnknownGlobals().optimize(false), this.typeRegistry, new PluginResolver(PluginResolver.Mode.ALLOW_UNDEFINED, this.printDirectives, this.soyFunctionMap, this.errorReporter));
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        ImmutableMap<String, String> parseInfo = new GenerateParseInfoVisitor(javaPackage, javaClassNameSource, registry).exec(soyTree);
        this.throwIfErrorsPresent();
        this.reportWarnings();
        return parseInfo;
    }

    public SoyMsgBundle extractMsgs() {
        this.resetErrorReporter();
        SoyMsgBundle bundle = this.doExtractMsgs();
        this.reportWarnings();
        return bundle;
    }

    public void extractAndWriteMsgs(SoyMsgBundleHandler msgBundleHandler, SoyMsgBundleHandler.OutputFileOptions options, ByteSink output) throws IOException {
        this.resetErrorReporter();
        SoyMsgBundle bundle = this.doExtractMsgs();
        msgBundleHandler.writeExtractedMsgs(bundle, options, output, this.errorReporter);
        this.throwIfErrorsPresent();
        this.reportWarnings();
    }

    private SoyMsgBundle doExtractMsgs() {
        SoyFileSetNode soyTree = this.parse(this.passManagerBuilder(SyntaxVersion.V1_0).allowUnknownGlobals().setTypeRegistry(SoyTypeRegistry.DEFAULT_UNKNOWN).disableAllTypeChecking(), SoyTypeRegistry.DEFAULT_UNKNOWN, new PluginResolver(PluginResolver.Mode.ALLOW_UNDEFINED, this.printDirectives, this.soyFunctionMap, this.errorReporter)).fileSet();
        this.throwIfErrorsPresent();
        SoyMsgBundle bundle = new ExtractMsgsVisitor().exec(soyTree);
        this.throwIfErrorsPresent();
        return bundle;
    }

    public SoyMsgBundle pruneTranslatedMsgs(SoyMsgBundle origTransMsgBundle) {
        this.resetErrorReporter();
        if (this.memoizedExtractedMsgIdsForPruning == null) {
            SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder(SyntaxVersion.V1_0).allowUnknownGlobals().disableAllTypeChecking(), SoyTypeRegistry.DEFAULT_UNKNOWN, new PluginResolver(PluginResolver.Mode.ALLOW_UNDEFINED, this.printDirectives, this.soyFunctionMap, this.errorReporter));
            this.throwIfErrorsPresent();
            SoyFileSetNode soyTree = result.fileSet();
            TemplateRegistry registry = result.registry();
            ArrayList allPublicTemplates = Lists.newArrayList();
            for (SoyFileNode soyFile : soyTree.getChildren()) {
                for (TemplateNode template : soyFile.getChildren()) {
                    if (template.getVisibility() != Visibility.PUBLIC) continue;
                    allPublicTemplates.add(template);
                }
            }
            ImmutableMap<TemplateNode, FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo> depsInfoMap = new FindTransitiveDepTemplatesVisitor(registry).execOnMultipleTemplates(allPublicTemplates);
            FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo mergedDepsInfo = FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo.merge(depsInfoMap.values());
            SoyMsgBundle extractedMsgBundle = new ExtractMsgsVisitor().execOnMultipleNodes((Iterable<? extends SoyNode>)mergedDepsInfo.depTemplateSet);
            ImmutableSet.Builder extractedMsgIdsBuilder = ImmutableSet.builder();
            for (SoyMsg extractedMsg : extractedMsgBundle) {
                extractedMsgIdsBuilder.add((Object)extractedMsg.getId());
            }
            this.throwIfErrorsPresent();
            this.memoizedExtractedMsgIdsForPruning = extractedMsgIdsBuilder.build();
        }
        ImmutableList.Builder prunedTransMsgsBuilder = ImmutableList.builder();
        for (SoyMsg transMsg : origTransMsgBundle) {
            if (!this.memoizedExtractedMsgIdsForPruning.contains((Object)transMsg.getId())) continue;
            prunedTransMsgsBuilder.add((Object)transMsg);
        }
        this.throwIfErrorsPresent();
        return new SoyMsgBundleImpl(origTransMsgBundle.getLocaleString(), (List<SoyMsg>)prunedTransMsgsBuilder.build());
    }

    public SoyTofu compileToTofu() {
        this.resetErrorReporter();
        ServerCompilationPrimitives primitives = this.compileForServerRendering();
        this.throwIfErrorsPresent();
        SoyTofu tofu = this.doCompileToTofu(primitives);
        this.reportWarnings();
        return tofu;
    }

    private SoyTofu doCompileToTofu(ServerCompilationPrimitives primitives) {
        return new BaseTofu(this.apiCallScopeProvider, primitives.registry, this.getTransitiveIjs(primitives.soyTree, primitives.registry));
    }

    public SoySauce compileTemplates() {
        this.resetErrorReporter();
        this.disallowExternalCalls();
        ServerCompilationPrimitives primitives = this.compileForServerRendering();
        this.throwIfErrorsPresent();
        SoySauce sauce = this.doCompileSoySauce(primitives);
        this.reportWarnings();
        return sauce;
    }

    void compileToJar(ByteSink jarTarget, Optional<ByteSink> srcJarTarget) throws IOException {
        this.resetErrorReporter();
        this.disallowExternalCalls();
        ServerCompilationPrimitives primitives = this.compileForServerRendering();
        BytecodeCompiler.compileToJar(primitives.registry, this.errorReporter, jarTarget);
        if (srcJarTarget.isPresent()) {
            BytecodeCompiler.writeSrcJar(primitives.registry, this.soyFileSuppliers, (ByteSink)srcJarTarget.get());
        }
        this.throwIfErrorsPresent();
        this.reportWarnings();
    }

    private SoySauce doCompileSoySauce(ServerCompilationPrimitives primitives) {
        Optional<CompiledTemplates> templates = BytecodeCompiler.compile(primitives.registry, this.cache != null, this.errorReporter);
        this.throwIfErrorsPresent();
        return new SoySauceImpl((CompiledTemplates)templates.get(), this.apiCallScopeProvider, this.soyFunctionMap, this.printDirectives);
    }

    private ServerCompilationPrimitives compileForServerRendering() {
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0);
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        if (this.cache == null) {
            new ClearSoyDocStringsVisitor().exec(soyTree);
        }
        this.throwIfErrorsPresent();
        return new ServerCompilationPrimitives(registry, soyTree);
    }

    private ImmutableMap<String, ImmutableSortedSet<String>> getTransitiveIjs(SoyFileSetNode soyTree, TemplateRegistry registry) {
        ImmutableMap<TemplateNode, FindIjParamsVisitor.IjParamsInfo> templateToIjParamsInfoMap = new FindIjParamsVisitor(registry).execOnAllTemplates(soyTree);
        ImmutableMap.Builder templateToTransitiveIjParams = ImmutableMap.builder();
        for (Map.Entry entry : templateToIjParamsInfoMap.entrySet()) {
            templateToTransitiveIjParams.put((Object)((TemplateNode)entry.getKey()).getTemplateName(), ((FindIjParamsVisitor.IjParamsInfo)entry.getValue()).ijParamSet);
        }
        return templateToTransitiveIjParams.build();
    }

    private void disallowExternalCalls() {
        TriState allowExternalCalls = this.generalOptions.allowExternalCalls();
        if (allowExternalCalls == TriState.UNSET) {
            this.generalOptions.setAllowExternalCalls(false);
        } else if (allowExternalCalls == TriState.ENABLED) {
            throw new IllegalStateException("SoyGeneralOptions.setAllowExternalCalls(true) is not supported with this method");
        }
    }

    private void requireStrictAutoescaping() {
        TriState strictAutoescapingRequired = this.generalOptions.isStrictAutoescapingRequired();
        if (strictAutoescapingRequired == TriState.UNSET) {
            this.generalOptions.setStrictAutoescapingRequired(true);
        } else if (strictAutoescapingRequired == TriState.DISABLED) {
            throw new IllegalStateException("SoyGeneralOptions.isStrictAutoescapingRequired(false) is not supported with this method");
        }
    }

    public List<String> compileToJsSrc(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) {
        SoyFileSetParser.ParseResult result = this.preprocessJsSrcResults(jsSrcOptions);
        TemplateRegistry registry = result.registry();
        SoyFileSetNode fileSet = result.fileSet();
        List<String> generatedSrcs = new JsSrcMain(this.apiCallScopeProvider, this.typeRegistry).genJsSrc(fileSet, registry, jsSrcOptions, msgBundle, this.errorReporter);
        this.throwIfErrorsPresent();
        this.reportWarnings();
        return generatedSrcs;
    }

    void compileToJsSrcFiles(String outputPathFormat, String inputFilePathPrefix, SoyJsSrcOptions jsSrcOptions, List<String> locales, @Nullable SoyMsgPlugin msgPlugin, @Nullable String messageFilePathFormat) throws IOException {
        SoyFileSetParser.ParseResult result = this.preprocessJsSrcResults(jsSrcOptions);
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        if (locales.isEmpty()) {
            new JsSrcMain(this.apiCallScopeProvider, this.typeRegistry).genJsFiles(soyTree, registry, jsSrcOptions, null, null, outputPathFormat, inputFilePathPrefix, this.errorReporter);
        } else {
            Preconditions.checkArgument((msgPlugin != null ? 1 : 0) != 0, (Object)"a message plugin must be provided when generating localized sources");
            Preconditions.checkArgument((messageFilePathFormat != null ? 1 : 0) != 0, (Object)"a messageFilePathFormat must be provided when generating localized sources");
            for (String locale : locales) {
                SoyFileSetNode soyTreeClone = soyTree.copy(new CopyState());
                String msgFilePath = MainEntryPointUtils.buildFilePath(messageFilePathFormat, locale, null, inputFilePathPrefix);
                SoyMsgBundle msgBundle = new SoyMsgBundleHandler(msgPlugin).createFromFile(new File(msgFilePath));
                if (msgBundle.getLocaleString() == null && !locale.startsWith("en")) {
                    throw new IOException("Error opening or reading message file " + msgFilePath);
                }
                new JsSrcMain(this.apiCallScopeProvider, this.typeRegistry).genJsFiles(soyTreeClone, registry, jsSrcOptions, locale, msgBundle, outputPathFormat, inputFilePathPrefix, this.errorReporter);
            }
        }
        this.throwIfErrorsPresent();
        this.reportWarnings();
    }

    private SoyFileSetParser.ParseResult preprocessJsSrcResults(SoyJsSrcOptions jsSrcOptions) {
        this.resetErrorReporter();
        if (jsSrcOptions.shouldAllowDeprecatedSyntax()) {
            this.generalOptions.setDeclaredSyntaxVersionName("1.0");
        }
        PassManager.Builder builder = this.passManagerBuilder(SyntaxVersion.V2_0).allowUnknownGlobals().desugarHtmlNodes(false);
        SoyFileSetParser.ParseResult parseResult = this.parse(builder);
        this.throwIfErrorsPresent();
        return parseResult;
    }

    public List<String> compileToIncrementalDomSrc(SoyIncrementalDomSrcOptions jsSrcOptions) {
        this.resetErrorReporter();
        SoyFileSetParser.ParseResult result = this.preprocessIncrementalDOMResults();
        List<String> generatedSrcs = new IncrementalDomSrcMain(this.apiCallScopeProvider, this.typeRegistry).genJsSrc(result.fileSet(), result.registry(), jsSrcOptions, this.errorReporter);
        this.throwIfErrorsPresent();
        this.reportWarnings();
        return generatedSrcs;
    }

    void compileToIncrementalDomSrcFiles(String outputPathFormat, SoyIncrementalDomSrcOptions jsSrcOptions) throws IOException {
        this.resetErrorReporter();
        this.disallowExternalCalls();
        SoyFileSetParser.ParseResult result = this.preprocessIncrementalDOMResults();
        new IncrementalDomSrcMain(this.apiCallScopeProvider, this.typeRegistry).genJsFiles(result.fileSet(), result.registry(), jsSrcOptions, outputPathFormat, this.errorReporter);
        this.throwIfErrorsPresent();
        this.reportWarnings();
    }

    private SoyFileSetParser.ParseResult preprocessIncrementalDOMResults() {
        SyntaxVersion declaredSyntaxVersion = this.generalOptions.getDeclaredSyntaxVersion(SyntaxVersion.V2_0);
        Preconditions.checkState((declaredSyntaxVersion.num >= SyntaxVersion.V2_0.num ? 1 : 0) != 0, (Object)"Incremental DOM code generation only supports syntax version of V2 or higher.");
        this.requireStrictAutoescaping();
        SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder(SyntaxVersion.V2_0).desugarHtmlNodes(false));
        this.throwIfErrorsPresent();
        return result;
    }

    void compileToPySrcFiles(String outputPathFormat, String inputFilePathPrefix, SoyPySrcOptions pySrcOptions) throws IOException {
        this.resetErrorReporter();
        this.requireStrictAutoescaping();
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0);
        this.throwIfErrorsPresent();
        new PySrcMain(this.apiCallScopeProvider).genPyFiles(result.fileSet(), pySrcOptions, outputPathFormat, inputFilePathPrefix, this.errorReporter);
        this.throwIfErrorsPresent();
        this.reportWarnings();
    }

    private SoyFileSetParser.ParseResult parse(SyntaxVersion defaultVersion) {
        return this.parse(this.passManagerBuilder(defaultVersion));
    }

    private SoyFileSetParser.ParseResult parse(PassManager.Builder builder) {
        return this.parse(builder, this.typeRegistry, new PluginResolver(this.generalOptions.getDeclaredSyntaxVersion(SyntaxVersion.V2_0) == SyntaxVersion.V1_0 ? PluginResolver.Mode.ALLOW_UNDEFINED_FUNCTIONS_FOR_V1_SUPPORT : PluginResolver.Mode.REQUIRE_DEFINITIONS, this.printDirectives, this.soyFunctionMap, this.errorReporter));
    }

    private SoyFileSetParser.ParseResult parse(PassManager.Builder builder, SoyTypeRegistry typeRegistry, PluginResolver resolver) {
        return SoyFileSetParser.newBuilder().setCache(this.cache).setSoyFileSuppliers(this.soyFileSuppliers).setTypeRegistry(typeRegistry).setPluginResolver(resolver).setPassManager(builder.setTypeRegistry(typeRegistry).build()).setErrorReporter(this.errorReporter).setGeneralOptions(this.generalOptions).build().parse();
    }

    private PassManager.Builder passManagerBuilder(SyntaxVersion defaultVersion) {
        return new PassManager.Builder().setGeneralOptions(this.generalOptions).setDeclaredSyntaxVersion(this.generalOptions.getDeclaredSyntaxVersion(defaultVersion)).setSoyPrintDirectiveMap(this.printDirectives).setErrorReporter(this.errorReporter).setConformanceConfig(this.conformanceConfig).setLoggingConfig(this.loggingConfig);
    }

    private void resetErrorReporter() {
        this.errorReporter = ErrorReporter.create(this.soyFileSuppliers);
    }

    private void throwIfErrorsPresent() {
        if (this.errorReporter.hasErrors()) {
            Iterable errors = Iterables.concat(this.errorReporter.getErrors(), this.errorReporter.getWarnings());
            this.errorReporter = null;
            throw new SoyCompilationException(errors);
        }
    }

    private void reportWarnings() {
        ImmutableList<SoyError> warnings = this.errorReporter.getWarnings();
        if (warnings.isEmpty()) {
            return;
        }
        if (this.generalOptions.getExperimentalFeatures().contains((Object)"testonly_throw_on_warnings")) {
            this.errorReporter = null;
            throw new SoyCompilationException((Iterable<SoyError>)warnings);
        }
        String formatted = SoyErrors.formatErrors(warnings);
        if (this.warningSink != null) {
            try {
                this.warningSink.append(formatted);
            }
            catch (IOException ioe) {
                System.err.println("error while printing warnings");
                ioe.printStackTrace();
            }
        } else {
            logger.warning(formatted);
        }
    }

    private static final class ServerCompilationPrimitives {
        final SoyFileSetNode soyTree;
        final TemplateRegistry registry;

        ServerCompilationPrimitives(TemplateRegistry registry, SoyFileSetNode soyTree) {
            this.registry = registry;
            this.soyTree = soyTree;
        }
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, SoyFileSupplier> filesBuilder;
        private SoyAstCache cache;
        private SoyGeneralOptions lazyGeneralOptions;
        private final CoreDependencies coreDependencies;
        private final SoyTypeRegistry.Builder typeRegistryBuilder = new SoyTypeRegistry.Builder();
        @Nullable
        private Appendable warningSink;
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ValidatedLoggingConfig loggingConfig = ValidatedLoggingConfig.EMPTY;

        Builder(CoreDependencies coreDependencies) {
            this.coreDependencies = coreDependencies;
            this.filesBuilder = ImmutableMap.builder();
            this.cache = null;
            this.lazyGeneralOptions = null;
        }

        public void setGeneralOptions(SoyGeneralOptions generalOptions) {
            Preconditions.checkState((this.lazyGeneralOptions == null ? 1 : 0) != 0, (Object)"Call SoyFileSet#setGeneralOptions before any other setters.");
            Preconditions.checkNotNull((Object)generalOptions, (Object)"Non-null argument expected.");
            this.lazyGeneralOptions = generalOptions.clone();
        }

        private SoyGeneralOptions getGeneralOptions() {
            if (this.lazyGeneralOptions == null) {
                this.lazyGeneralOptions = new SoyGeneralOptions();
            }
            return this.lazyGeneralOptions;
        }

        public SoyFileSet build() {
            return new SoyFileSet(this.coreDependencies.apiCallScope, this.typeRegistryBuilder.build(), (ImmutableMap<String, ? extends SoyFunction>)this.coreDependencies.soyFunctionMap, (ImmutableMap<String, ? extends SoyPrintDirective>)this.coreDependencies.printDirectives, (ImmutableMap<String, SoyFileSupplier>)this.filesBuilder.build(), this.getGeneralOptions(), this.cache, this.conformanceConfig, this.loggingConfig, this.warningSink);
        }

        public Builder addWithKind(CharSource contentSource, SoyFileKind soyFileKind, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(contentSource, soyFileKind, filePath));
        }

        public Builder addWithKind(File inputFile, SoyFileKind soyFileKind) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFile, soyFileKind));
        }

        public Builder addWithKind(URL inputFileUrl, SoyFileKind soyFileKind, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFileUrl, soyFileKind, filePath));
        }

        public Builder addWithKind(URL inputFileUrl, SoyFileKind soyFileKind) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFileUrl, soyFileKind));
        }

        public Builder addWithKind(CharSequence content, SoyFileKind soyFileKind, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(content, soyFileKind, filePath));
        }

        public Builder add(CharSource contentSource, String filePath) {
            return this.addWithKind(contentSource, SoyFileKind.SRC, filePath);
        }

        public Builder add(URL inputFileUrl, String filePath) {
            return this.addWithKind(inputFileUrl, SoyFileKind.SRC, filePath);
        }

        public Builder add(URL inputFileUrl) {
            return this.addWithKind(inputFileUrl, SoyFileKind.SRC);
        }

        public Builder add(CharSequence content, String filePath) {
            return this.addWithKind(content, SoyFileKind.SRC, filePath);
        }

        public Builder add(File inputFile) {
            return this.addWithKind(inputFile, SoyFileKind.SRC);
        }

        public Builder addVolatileWithKind(File inputFile, SoyFileKind soyFileKind) {
            return this.addFile(new VolatileSoyFileSupplier(inputFile, soyFileKind));
        }

        public Builder addVolatile(File inputFile) {
            return this.addVolatileWithKind(inputFile, SoyFileKind.SRC);
        }

        public Builder setSoyAstCache(SoyAstCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder setDeclaredSyntaxVersionName(@Nonnull String versionName) {
            this.getGeneralOptions().setDeclaredSyntaxVersionName(versionName);
            return this;
        }

        public Builder setAllowExternalCalls(boolean allowExternalCalls) {
            this.getGeneralOptions().setAllowExternalCalls(allowExternalCalls);
            return this;
        }

        public Builder setExperimentalFeatures(List<String> experimentalFeatures) {
            this.getGeneralOptions().setExperimentalFeatures(experimentalFeatures);
            return this;
        }

        public Builder disableOptimizer() {
            this.getGeneralOptions().disableOptimizer();
            return this;
        }

        public Builder setStrictAutoescapingRequired(boolean strictAutoescapingRequired) {
            this.getGeneralOptions().setStrictAutoescapingRequired(strictAutoescapingRequired);
            return this;
        }

        public Builder setCompileTimeGlobals(Map<String, ?> compileTimeGlobalsMap) {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsMap);
            return this;
        }

        public Builder setCompileTimeGlobals(File compileTimeGlobalsFile) throws IOException {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsFile);
            return this;
        }

        public Builder setCompileTimeGlobals(URL compileTimeGlobalsResource) throws IOException {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsResource);
            return this;
        }

        public Builder addProtoDescriptorsFromFile(File descriptorFile) throws IOException {
            this.typeRegistryBuilder.addFileDescriptorSetFromFile(descriptorFile);
            return this;
        }

        public Builder addProtoDescriptors(Descriptors.GenericDescriptor ... descriptors) {
            return this.addProtoDescriptors(Arrays.asList(descriptors));
        }

        public Builder addProtoDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
            this.typeRegistryBuilder.addDescriptors(descriptors);
            return this;
        }

        Builder setConformanceConfig(ValidatedConformanceConfig config) {
            Preconditions.checkNotNull((Object)config);
            this.conformanceConfig = config;
            return this;
        }

        private Builder addFile(SoyFileSupplier supplier) {
            this.filesBuilder.put((Object)supplier.getFilePath(), (Object)supplier);
            return this;
        }

        Builder setWarningSink(Appendable warningSink) {
            this.warningSink = (Appendable)Preconditions.checkNotNull((Object)warningSink);
            return this;
        }

        public Builder setLoggingConfig(LoggingConfig config) {
            return this.setValidatedLoggingConfig(ValidatedLoggingConfig.create(config));
        }

        Builder setValidatedLoggingConfig(ValidatedLoggingConfig parseLoggingConfigs) {
            this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)parseLoggingConfigs);
            return this;
        }
    }

    static final class CoreDependencies {
        private final GuiceSimpleScope apiCallScope;
        private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
        private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;

        @Inject
        CoreDependencies(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, ImmutableMap<String, ? extends SoyFunction> soyFunctionMap, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
            this.apiCallScope = apiCallScope;
            this.soyFunctionMap = soyFunctionMap;
            this.printDirectives = printDirectives;
        }
    }
}

