/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.AutoValue_SoyFileSetParser;
import com.google.template.soy.AutoValue_SoyFileSetParser_ParseResult;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soyparse.PluginResolver;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;

public abstract class SoyFileSetParser {
    public static Builder newBuilder() {
        return new AutoValue_SoyFileSetParser.Builder();
    }

    @Nullable
    abstract SoyAstCache cache();

    abstract ImmutableMap<String, ? extends SoyFileSupplier> soyFileSuppliers();

    abstract PassManager passManager();

    abstract ErrorReporter errorReporter();

    abstract SoyTypeRegistry typeRegistry();

    abstract PluginResolver pluginResolver();

    @Nullable
    abstract SoyGeneralOptions generalOptions();

    public ParseResult parse() {
        try {
            return this.parseWithVersions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parseWithVersions() throws IOException {
        IdGenerator nodeIdGen = this.cache() != null ? this.cache().getNodeIdGenerator() : new IncrementingIdGenerator();
        SoyFileSetNode soyTree = new SoyFileSetNode(nodeIdGen.genId(), nodeIdGen);
        boolean filesWereSkipped = false;
        IdGenerator idGenerator = nodeIdGen;
        synchronized (idGenerator) {
            for (SoyFileSupplier fileSupplier : this.soyFileSuppliers().values()) {
                SoyFileNode node;
                SoyAstCache.VersionedFile cachedFile;
                SoyFileSupplier.Version version = fileSupplier.getVersion();
                SoyAstCache.VersionedFile versionedFile = cachedFile = this.cache() != null ? this.cache().get(fileSupplier.getFilePath(), version) : null;
                if (cachedFile == null) {
                    node = this.parseSoyFileHelper(fileSupplier, nodeIdGen, this.typeRegistry());
                    if (node == null) {
                        filesWereSkipped = true;
                        continue;
                    }
                    this.passManager().runSingleFilePasses(node, nodeIdGen);
                    if (this.cache() != null) {
                        this.cache().put(fileSupplier.getFilePath(), SoyAstCache.VersionedFile.of(node, version));
                    }
                } else {
                    node = cachedFile.file();
                }
                soyTree.addChild(node);
            }
            TemplateRegistry registry = !filesWereSkipped ? this.passManager().runWholeFilesetPasses(soyTree) : new TemplateRegistry(soyTree, this.errorReporter());
            return ParseResult.create(soyTree, registry);
        }
    }

    private SoyFileNode parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen, SoyTypeRegistry typeRegistry) throws IOException {
        try (Reader soyFileReader = soyFileSupplier.open();){
            String filePath = soyFileSupplier.getFilePath();
            int lastBangIndex = filePath.lastIndexOf(33);
            if (lastBangIndex != -1) {
                filePath = filePath.substring(lastBangIndex + 1);
            }
            SoyFileNode soyFileNode = new SoyFileParser(typeRegistry, this.pluginResolver(), nodeIdGen, soyFileReader, soyFileSupplier.getSoyFileKind(), filePath, this.errorReporter(), this.generalOptions() == null ? ImmutableSet.of() : this.generalOptions().getExperimentalFeatures()).parseSoyFile();
            return soyFileNode;
        }
    }

    public static abstract class Builder {
        public abstract Builder setCache(SoyAstCache var1);

        public abstract Builder setSoyFileSuppliers(ImmutableMap<String, ? extends SoyFileSupplier> var1);

        public abstract Builder setPassManager(PassManager var1);

        public abstract Builder setErrorReporter(ErrorReporter var1);

        public abstract Builder setTypeRegistry(SoyTypeRegistry var1);

        public abstract Builder setPluginResolver(PluginResolver var1);

        public abstract Builder setGeneralOptions(SoyGeneralOptions var1);

        public abstract SoyFileSetParser build();
    }

    public static abstract class ParseResult {
        static ParseResult create(SoyFileSetNode soyTree, TemplateRegistry registry) {
            return new AutoValue_SoyFileSetParser_ParseResult(soyTree, registry);
        }

        public abstract SoyFileSetNode fileSet();

        public abstract TemplateRegistry registry();
    }
}

