/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Ascii;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.QuoteStyle;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

public class BaseUtils {
    private static final Set<String> knownExistingDirs = Collections.synchronizedSet(Sets.newHashSet());
    public static final String IDENT_RE = "[a-zA-Z_][a-zA-Z_0-9]*";
    private static final Pattern IDENT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    private static final Pattern IDENT_WITH_LEADING_DOT_PATTERN = Pattern.compile("[.][a-zA-Z_][a-zA-Z_0-9]*");
    public static final String DOTTED_IDENT_RE = "[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*";
    private static final Pattern DOTTED_IDENT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*");
    private static final Pattern LEADING_OR_TRAILING_UNDERSCORE_PATTERN = Pattern.compile("^_+|_+\\Z");
    private static final Pattern WORD_BOUNDARY_IN_IDENT_PATTERN = Pattern.compile("(?<= [a-zA-Z])(?= [A-Z][a-z])| (?<= [a-zA-Z])(?= [0-9])| (?<= [0-9])(?= [a-zA-Z])", 4);
    private static final Pattern CONSECUTIVE_UNDERSCORES_PATTERN = Pattern.compile("_ _ _*", 4);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private BaseUtils() {
    }

    public static void ensureDirsExistInPath(String path) {
        String dirPath;
        if (path == null || path.length() == 0) {
            throw new AssertionError((Object)"ensureDirsExistInPath called with null or empty path.");
        }
        String string = dirPath = path.charAt(path.length() - 1) == File.separatorChar ? path.substring(0, path.length() - 1) : new File(path).getParent();
        if (dirPath == null || knownExistingDirs.contains(dirPath)) {
            return;
        }
        new File(dirPath).mkdirs();
        knownExistingDirs.add(dirPath);
    }

    public static boolean isIdentifier(String s) {
        return IDENT_PATTERN.matcher(s).matches();
    }

    public static boolean isIdentifierWithLeadingDot(String s) {
        return IDENT_WITH_LEADING_DOT_PATTERN.matcher(s).matches();
    }

    public static boolean isDottedIdentifier(String s) {
        return DOTTED_IDENT_PATTERN.matcher(s).matches();
    }

    public static String extractPartAfterLastDot(String dottedIdent) {
        int lastDotIndex = dottedIdent.lastIndexOf(46);
        return lastDotIndex == -1 ? dottedIdent : dottedIdent.substring(lastDotIndex + 1);
    }

    public static String convertToUpperUnderscore(String ident) {
        ident = LEADING_OR_TRAILING_UNDERSCORE_PATTERN.matcher(ident).replaceAll("");
        ident = WORD_BOUNDARY_IN_IDENT_PATTERN.matcher(ident).replaceAll("_");
        ident = CONSECUTIVE_UNDERSCORES_PATTERN.matcher(ident).replaceAll("_");
        return Ascii.toUpperCase((String)ident);
    }

    public static String escapeToSoyString(String value, boolean shouldEscapeToAscii, QuoteStyle quoteStyle) {
        int codePoint;
        int len = value.length();
        StringBuilder out = new StringBuilder(len * 9 / 8);
        out.append(quoteStyle.getQuoteChar());
        block10: for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            switch (codePoint) {
                case 10: {
                    out.append("\\n");
                    continue block10;
                }
                case 13: {
                    out.append("\\r");
                    continue block10;
                }
                case 9: {
                    out.append("\\t");
                    continue block10;
                }
                case 8: {
                    out.append("\\b");
                    continue block10;
                }
                case 12: {
                    out.append("\\f");
                    continue block10;
                }
                case 92: {
                    out.append("\\\\");
                    continue block10;
                }
                case 39: {
                    out.append(quoteStyle == QuoteStyle.DOUBLE ? "'" : "\\'");
                    continue block10;
                }
                case 34: {
                    out.append(quoteStyle == QuoteStyle.DOUBLE ? "\\\"" : Character.valueOf('\"'));
                    continue block10;
                }
                default: {
                    if (shouldEscapeToAscii && (codePoint < 32 || codePoint >= 127)) {
                        BaseUtils.appendHexEscape(out, codePoint);
                        continue block10;
                    }
                    out.appendCodePoint(codePoint);
                }
            }
        }
        out.append(quoteStyle.getQuoteChar());
        return out.toString();
    }

    public static void appendHexEscape(StringBuilder out, int codePoint) {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            BaseUtils.appendHexEscape(out, surrogates[0]);
            BaseUtils.appendHexEscape(out, surrogates[1]);
        } else {
            out.append("\\u").append(HEX_DIGITS[codePoint >>> 12 & 0xF]).append(HEX_DIGITS[codePoint >>> 8 & 0xF]).append(HEX_DIGITS[codePoint >>> 4 & 0xF]).append(HEX_DIGITS[codePoint & 0xF]);
        }
    }
}

