/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.internal.Sanitizers;
import com.google.template.soy.shared.internal.TagWhitelist;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import com.google.template.soy.types.SanitizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPurePrintDirective
final class CleanHtmlDirective
implements SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyPySrcPrintDirective,
SoyJbcSrcPrintDirective.Streamable {
    private static final Joiner ARG_JOINER = Joiner.on((String)", ");
    private static final Set<Integer> VALID_ARGS_SIZES = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(TagWhitelist.OptionalSafeTag.values().length)), (DiscreteDomain)DiscreteDomain.integers());
    private static final Function<SoyValue, String> SOY_VALUE_TO_STRING = new Function<SoyValue, String>(){

        public String apply(SoyValue soyValue) {
            return soyValue.stringValue();
        }
    };
    private static final Function<TargetExpr, String> TARGET_EXPR_TO_STRING = new Function<TargetExpr, String>(){

        public String apply(TargetExpr expr) {
            return expr.getText();
        }
    };

    @Inject
    public CleanHtmlDirective() {
    }

    @Override
    public String getName() {
        return "|cleanHtml";
    }

    @Override
    public final Set<Integer> getValidArgsSizes() {
        return VALID_ARGS_SIZES;
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        ImmutableSet optionalSafeTags = FluentIterable.from(args).transform(SOY_VALUE_TO_STRING).transform(TagWhitelist.OptionalSafeTag.FROM_TAG_NAME).toSet();
        return Sanitizers.cleanHtml(value, (Collection<? extends TagWhitelist.OptionalSafeTag>)optionalSafeTags);
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        return SoyExpression.forSoyValue(SanitizedType.HtmlType.getInstance(), JbcSrcMethods.CLEAN_HTML.invoke(value.box(), this.fromTagNameList(args)));
    }

    @Override
    public SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.createCloseable(JbcSrcMethods.CLEAN_HTML_STREAMING.invoke(delegateAppendable, this.fromTagNameList(args)));
    }

    private Expression fromTagNameList(List<SoyExpression> args) {
        ArrayList<Expression> optionalSafeTags = new ArrayList<Expression>();
        for (SoyExpression arg : args) {
            optionalSafeTags.add(JbcSrcMethods.FROM_TAG_NAME.invoke(arg.unboxAs(String.class)));
        }
        return BytecodeUtils.asList(optionalSafeTags);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String optionalSafeTagsArg = this.generateOptionalSafeTagsArg(args);
        return new JsExpr("soy.$$cleanHtml(" + value.getText() + optionalSafeTagsArg + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr applyForPySrc(PyExpr value, List<PyExpr> args) {
        String optionalSafeTagsArg = this.generateOptionalSafeTagsArg(args);
        return new PyExpr("sanitize.clean_html(" + value.getText() + optionalSafeTagsArg + ")", Integer.MAX_VALUE);
    }

    private String generateOptionalSafeTagsArg(List<? extends TargetExpr> args) {
        String optionalSafeTagsArg = "";
        if (!args.isEmpty()) {
            Iterable optionalSafeTagExprs = Iterables.transform(args, TARGET_EXPR_TO_STRING);
            for (String singleQuoted : optionalSafeTagExprs) {
                if (singleQuoted.length() < 2 || singleQuoted.charAt(0) != '\'' || singleQuoted.charAt(singleQuoted.length() - 1) != '\'') {
                    throw new IllegalArgumentException(String.format("The cleanHtml directive expects arguments to be tag name string literals, such as 'span'. Encountered: %s", singleQuoted));
                }
                String tagName = singleQuoted.substring(1, singleQuoted.length() - 1);
                TagWhitelist.OptionalSafeTag.fromTagName(tagName);
            }
            optionalSafeTagsArg = ", [" + ARG_JOINER.join(optionalSafeTagExprs) + "]";
        }
        return optionalSafeTagsArg;
    }

    private static final class JbcSrcMethods {
        static final MethodRef CLEAN_HTML = MethodRef.create(Sanitizers.class, "cleanHtml", SoyValue.class, Collection.class).asNonNullable();
        static final MethodRef CLEAN_HTML_STREAMING = MethodRef.create(Sanitizers.class, "cleanHtmlStreaming", LoggingAdvisingAppendable.class, Collection.class).asNonNullable();
        static final MethodRef FROM_TAG_NAME = MethodRef.create(TagWhitelist.OptionalSafeTag.class, "fromTagName", String.class).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

