/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
@SoyPureFunction
@SoyFunctionSignature(name="floor", value={@Signature(parameterTypes={"number"}, returnType="int")})
public final class FloorFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    FloorFunction() {
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return IntegerData.forValue(BasicFunctionsRuntime.floor(args.get(0)));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg = args.get(0);
        return new JsExpr("Math.floor(" + arg.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg = args.get(0);
        return new PyExpr("int(math.floor(" + arg.getText() + "))", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression argument = args.get(0);
        switch (argument.resultType().getSort()) {
            case 7: {
                return argument;
            }
            case 8: {
                return SoyExpression.forInt(BytecodeUtils.numericConversion(JbcSrcMethods.MATH_FLOOR.invoke(argument), Type.LONG_TYPE));
            }
        }
        return SoyExpression.forInt(JbcSrcMethods.FLOOR_FN.invoke(argument.box()));
    }

    private static final class JbcSrcMethods {
        static final MethodRef FLOOR_FN = MethodRef.create(BasicFunctionsRuntime.class, "floor", SoyValue.class).asNonNullable();
        static final MethodRef MATH_FLOOR = MethodRef.create(Math.class, "floor", Double.TYPE).asCheap();

        private JbcSrcMethods() {
        }
    }
}

