/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnknownType;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public final class LegacyObjectMapToMapFunction
implements SoyJavaFunction,
SoyJbcSrcFunction,
SoyPySrcFunction,
SoyLibraryAssistedJsSrcFunction {
    @Inject
    LegacyObjectMapToMapFunction() {
    }

    @Override
    public String getName() {
        return "legacyObjectMapToMap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy.newmaps");
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        MapType newType;
        SoyExpression soyExpression = (SoyExpression)Iterables.getOnlyElement(args);
        SoyType originalType = soyExpression.soyRuntimeType().soyType();
        if (originalType instanceof LegacyObjectMapType) {
            newType = MapType.of(((LegacyObjectMapType)originalType).getKeyType(), ((LegacyObjectMapType)originalType).getValueType());
        } else if (originalType instanceof UnknownType) {
            newType = MapType.of(UnknownType.getInstance(), UnknownType.getInstance());
        } else {
            throw new IllegalArgumentException("legacyObjectMapToMap() expects input to be LEGACY_OBJECT_MAP, get " + (Object)((Object)originalType.getKind()));
        }
        return SoyExpression.forMap(newType, JbcSrcMethods.LEGACY_OBJECT_MAP_TO_MAP.invoke(soyExpression.box().checkedCast(SoyDict.class)));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        return new JsExpr("soy.newmaps.$$legacyObjectMapToMap(" + args.get(0).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return (PyExpr)Iterables.getOnlyElement(args);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        DictImpl map = (DictImpl)Iterables.getOnlyElement(args);
        return BasicFunctionsRuntime.legacyObjectMapToMap(map);
    }

    private static final class JbcSrcMethods {
        static final MethodRef LEGACY_OBJECT_MAP_TO_MAP = MethodRef.create(BasicFunctionsRuntime.class, "legacyObjectMapToMap", SoyDict.class);

        private JbcSrcMethods() {
        }
    }
}

