/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyType;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class MapKeysFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    MapKeysFunction() {
    }

    @Override
    public String getName() {
        return "mapKeys";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg = args.get(0);
        if (!(arg instanceof SoyMap)) {
            throw new IllegalArgumentException("Argument to mapKeys() function is not a SoyMap.");
        }
        return ListImpl.forProviderList(BasicFunctionsRuntime.mapKeys((SoyMap)arg));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg = args.get(0);
        return new JsExpr("soy.map.$$getMapKeys(" + arg.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy.map");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg = args.get(0);
        return new PyListExpr("(" + arg.getText() + ").keys()", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression soyExpression = args.get(0);
        SoyType argType = soyExpression.soyType();
        SoyType keyType = ((MapType)argType).getKeyType();
        return SoyExpression.forList(keyType == null ? ListType.EMPTY_LIST : ListType.of(keyType), JbcSrcMethods.MAP_KEYS_FN.invoke(soyExpression.box().checkedCast(SoyMap.class)));
    }

    private static final class JbcSrcMethods {
        static final MethodRef MAP_KEYS_FN = MethodRef.create(BasicFunctionsRuntime.class, "mapKeys", SoyMap.class);

        private JbcSrcMethods() {
        }
    }
}

