/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.types.SoyTypes;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@SoyFunctionSignature(name="max", value={@Signature(returnType="?", parameterTypes={"?", "?"})})
@Singleton
@SoyPureFunction
public final class MaxFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    MaxFunction() {
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg0 = args.get(0);
        SoyValue arg1 = args.get(1);
        return BasicFunctionsRuntime.max(arg0, arg1);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg0 = args.get(0);
        JsExpr arg1 = args.get(1);
        return new JsExpr("Math.max(" + arg0.getText() + ", " + arg1.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg0 = args.get(0);
        PyExpr arg1 = args.get(1);
        PyFunctionExprBuilder fnBuilder = new PyFunctionExprBuilder("max");
        return fnBuilder.addArg(arg0).addArg(arg1).asPyExpr();
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression left = args.get(0);
        SoyExpression right = args.get(1);
        if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
            return SoyExpression.forInt(JbcSrcMethods.MATH_MAX_LONG.invoke(left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
        }
        if (left.assignableToNullableFloat() && right.assignableToNullableFloat()) {
            return SoyExpression.forFloat(JbcSrcMethods.MATH_MAX_DOUBLE.invoke(left.unboxAs(Double.TYPE), right.unboxAs(Double.TYPE)));
        }
        return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, JbcSrcMethods.MAX_FN.invoke(left.box(), right.box()));
    }

    private static final class JbcSrcMethods {
        private static final MethodRef MAX_FN = MethodRef.create(BasicFunctionsRuntime.class, "max", SoyValue.class, SoyValue.class).asNonNullable();
        private static final MethodRef MATH_MAX_DOUBLE = MethodRef.create(Math.class, "max", Double.TYPE, Double.TYPE).asCheap();
        private static final MethodRef MATH_MAX_LONG = MethodRef.create(Math.class, "max", Long.TYPE, Long.TYPE).asCheap();

        private JbcSrcMethods() {
        }
    }
}

