/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SoyTypes;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
@SoyFunctionSignature(name="parseInt", value={@Signature(parameterTypes={"string"}, returnType="int")})
public final class ParseIntFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    ParseIntFunction() {
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        String toParse = args.get(0).stringValue();
        try {
            return IntegerData.forValue(Long.parseLong(toParse));
        }
        catch (NumberFormatException e) {
            return NullData.INSTANCE;
        }
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg = args.get(0).getText();
        return new JsExpr(String.format("soy.$$parseInt(%s)", arg), Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        String arg = args.get(0).getText();
        return new PyExpr(String.format("runtime.parse_int(%s)", arg), Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forSoyValue(SoyTypes.makeNullable(IntType.getInstance()), JbcSrcMethods.PARSE_INT.invoke(args.get(0).unboxAs(String.class)));
    }

    private static final class JbcSrcMethods {
        static final MethodRef PARSE_INT = MethodRef.create(BasicFunctionsRuntime.class, "parseInt", String.class);

        private JbcSrcMethods() {
        }
    }
}

