/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@SoyFunctionSignature(name="strLen", value={@Signature(returnType="int", parameterTypes={"?"})})
@Singleton
@SoyPureFunction
final class StrLenFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    StrLenFunction() {
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg0 = args.get(0);
        Preconditions.checkArgument((boolean)(arg0 instanceof SoyString), (String)"First argument to strLen() function is not StringData or SanitizedContent: %s", (Object)arg0);
        return IntegerData.forValue(arg0.coerceToString().length());
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg0 = JsExprUtils.toString(args.get(0)).getText();
        return new JsExpr("(" + arg0 + ").length", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return new PyExpr("len(" + args.get(0).toPyString().getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forInt(BytecodeUtils.numericConversion(args.get(0).unboxAs(String.class).invoke(JbcSrcMethods.STRING_LENGTH, new Expression[0]), Type.LONG_TYPE));
    }

    private static final class JbcSrcMethods {
        static final MethodRef STRING_LENGTH = MethodRef.create(String.class, "length", new Class[0]);

        private JbcSrcMethods() {
        }
    }
}

