/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.bidifunctions.BidiFunctionsRuntime;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@SoyFunctionSignature(name="bidiDirAttr", value={@Signature(returnType="attributes", parameterTypes={"?"}), @Signature(returnType="attributes", parameterTypes={"?", "?"})})
@Singleton
final class BidiDirAttrFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiDirAttrFunction(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue value = args.get(0);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(BidiFunctionsRuntime.bidiDirAttr((BidiGlobalDir)this.bidiGlobalDirProvider.get(), value, args.size() == 2 && args.get(1).booleanValue()), SanitizedContent.ContentKind.ATTRIBUTES);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forSanitizedString(JbcSrcMethods.DIR_ATTR.invoke(context.getBidiGlobalDir(), args.get(0).box(), args.size() > 1 ? args.get(1).unboxAs(Boolean.TYPE) : BytecodeUtils.constant(false)), SanitizedContentKind.ATTRIBUTES);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr value = args.get(0);
        JsExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String callText = "soy.$$bidiDirAttr(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ", " + value.getText() + (isHtml != null ? ", " + isHtml.getText() : "") + ")";
        return new JsExpr(callText, Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.builder().addAll((Iterable)((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getNamespace().asSet()).add((Object)"soy").build();
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr value = args.get(0);
        PyExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String callText = "bidi.dir_attr(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ", " + value.getText() + (isHtml != null ? ", " + isHtml.getText() : "") + ")";
        return new PyExpr(callText, Integer.MAX_VALUE);
    }

    private static final class JbcSrcMethods {
        static final MethodRef DIR_ATTR = MethodRef.create(BidiFunctionsRuntime.class, "bidiDirAttr", BidiGlobalDir.class, SoyValue.class, Boolean.TYPE).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

