/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.bidifunctions.BidiFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@SoyFunctionSignature(name="bidiMark", value={@Signature(returnType="string")})
@Singleton
final class BidiMarkFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiMarkFunction(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return StringData.forValue(BidiFunctionsRuntime.bidiMark((BidiGlobalDir)this.bidiGlobalDirProvider.get()));
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forString(JbcSrcMethods.BIDI_MARK.invoke(context.getBidiGlobalDir()));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        if (bidiGlobalDir.isStaticValue()) {
            return new JsExpr(bidiGlobalDir.getStaticValue() < 0 ? "'\\u200F'" : "'\\u200E'", Integer.MAX_VALUE);
        }
        return new JsExpr("(" + bidiGlobalDir.getCodeSnippet() + ") < 0 ? '\\u200F' : '\\u200E'", Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.copyOf((Collection)((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getNamespace().asSet());
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        return new PyExpr("'\\u200F' if (" + bidiGlobalDir.getCodeSnippet() + ") < 0 else '\\u200E'", Operator.CONDITIONAL.getPrecedence());
    }

    private static final class JbcSrcMethods {
        static final MethodRef BIDI_MARK = MethodRef.create(BidiFunctionsRuntime.class, "bidiMark", BidiGlobalDir.class).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

