/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.FunctionNode;

final class BannedFunction
extends Rule<FunctionNode> {
    private final ImmutableSet<String> bannedFunctions;

    BannedFunction(ImmutableSet<String> bannedFunctions, SoyErrorKind error) {
        super(error);
        this.bannedFunctions = bannedFunctions;
    }

    @Override
    protected void doCheckConformance(FunctionNode node, ErrorReporter errorReporter) {
        String functionName = node.getFunctionName();
        if (this.bannedFunctions.contains((Object)functionName)) {
            errorReporter.report(node.getSourceLocation(), this.error, new Object[0]);
        }
    }
}

