/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.conformance.BanXidForCssObfuscation;
import com.google.template.soy.conformance.BannedCssSelector;
import com.google.template.soy.conformance.BannedDirective;
import com.google.template.soy.conformance.BannedFunction;
import com.google.template.soy.conformance.BannedHtmlTag;
import com.google.template.soy.conformance.BannedRawText;
import com.google.template.soy.conformance.ConformanceConfig;
import com.google.template.soy.conformance.RequireStrictAutoescaping;
import com.google.template.soy.conformance.RequireStronglyTypedIjParams;
import com.google.template.soy.conformance.Requirement;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.conformance.RuleWithWhitelists;
import com.google.template.soy.error.SoyErrorKind;
import java.lang.reflect.Constructor;
import java.util.Collection;

public final class ValidatedConformanceConfig {
    public static final ValidatedConformanceConfig EMPTY = new ValidatedConformanceConfig((ImmutableList<RuleWithWhitelists>)ImmutableList.of());
    private static final Escaper MESSAGE_FORMAT = Escapers.builder().addEscape('{', "'{").addEscape('}', "}'").build();
    private final ImmutableList<RuleWithWhitelists> rules;

    public static ValidatedConformanceConfig create(ConformanceConfig config) {
        ImmutableList.Builder rulesBuilder = new ImmutableList.Builder();
        for (Requirement requirement : config.getRequirementList()) {
            Preconditions.checkArgument((!requirement.getErrorMessage().isEmpty() ? 1 : 0) != 0, (Object)"requirement missing error message");
            Preconditions.checkArgument((requirement.getRequirementTypeCase() != Requirement.RequirementTypeCase.REQUIREMENTTYPE_NOT_SET ? 1 : 0) != 0, (Object)"requirement missing type");
            Rule<? extends Node> rule = ValidatedConformanceConfig.forRequirement(requirement);
            ImmutableList whitelists = ImmutableList.copyOf((Collection)requirement.getWhitelistList());
            ImmutableList onlyApplyToPaths = ImmutableList.copyOf((Collection)requirement.getOnlyApplyToList());
            rulesBuilder.add((Object)RuleWithWhitelists.create(rule, (ImmutableList<String>)whitelists, (ImmutableList<String>)onlyApplyToPaths));
        }
        return new ValidatedConformanceConfig((ImmutableList<RuleWithWhitelists>)rulesBuilder.build());
    }

    private ValidatedConformanceConfig(ImmutableList<RuleWithWhitelists> rules) {
        this.rules = rules;
    }

    ImmutableList<RuleWithWhitelists> getRules() {
        return this.rules;
    }

    private static Rule<? extends Node> forRequirement(Requirement requirement) {
        SoyErrorKind error = SoyErrorKind.of(MESSAGE_FORMAT.escape(requirement.getErrorMessage()), SoyErrorKind.StyleAllowance.values());
        switch (requirement.getRequirementTypeCase()) {
            case CUSTOM: {
                return ValidatedConformanceConfig.createCustomRule(requirement.getCustom().getJavaClass(), error);
            }
            case BANNED_CSS_SELECTOR: {
                Requirement.BannedCssSelector bannedCss = requirement.getBannedCssSelector();
                return new BannedCssSelector((ImmutableSet<String>)ImmutableSet.copyOf((Collection)bannedCss.getSelectorList()), error);
            }
            case BANNED_DIRECTIVE: {
                Requirement.BannedDirective bannedDirective = requirement.getBannedDirective();
                return new BannedDirective((ImmutableSet<String>)ImmutableSet.copyOf((Collection)bannedDirective.getDirectiveList()), error);
            }
            case BANNED_FUNCTION: {
                Requirement.BannedFunction bannedFunction = requirement.getBannedFunction();
                return new BannedFunction((ImmutableSet<String>)ImmutableSet.copyOf((Collection)bannedFunction.getFunctionList()), error);
            }
            case BANNED_RAW_TEXT: {
                Requirement.BannedRawText bannedRawText = requirement.getBannedRawText();
                return new BannedRawText((ImmutableSet<String>)ImmutableSet.copyOf((Collection)bannedRawText.getTextList()), error);
            }
            case BANNED_HTML_TAG: {
                Requirement.BannedHtmlTag bannedHtmlTag = requirement.getBannedHtmlTag();
                return new BannedHtmlTag((Collection<String>)bannedHtmlTag.getTagList(), error);
            }
            case REQUIRE_STRICT_AUTOESCAPING: {
                return new RequireStrictAutoescaping(error);
            }
            case REQUIRE_STRONGLY_TYPED_IJ_PARAMS: {
                return new RequireStronglyTypedIjParams(error);
            }
            case BAN_XID_FOR_CSS_OBFUSCATION: {
                return new BanXidForCssObfuscation(error);
            }
        }
        throw new AssertionError((Object)("unexpected requirement type: " + (Object)((Object)requirement.getRequirementTypeCase())));
    }

    private static Rule<?> createCustomRule(String javaClass, SoyErrorKind error) {
        Class<Rule> customRuleClass;
        try {
            Class<Rule> asSubclass;
            customRuleClass = asSubclass = Class.forName(javaClass).asSubclass(Rule.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("custom rule class " + javaClass + " not found", e);
        }
        try {
            Constructor<Rule> ctor = customRuleClass.getDeclaredConstructor(SoyErrorKind.class);
            return ctor.newInstance(error);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("unable to construct custom rule class: " + javaClass + ": " + e.getMessage(), e);
        }
    }
}

