/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SoyMapImpl
extends SoyAbstractValue
implements SoyMap {
    private final ImmutableMap<? extends SoyValue, ? extends SoyValueProvider> providerMap;

    public static SoyMapImpl forProviderMap(Map<? extends SoyValue, ? extends SoyValueProvider> providerMap) {
        return new SoyMapImpl(providerMap);
    }

    private SoyMapImpl(Map<? extends SoyValue, ? extends SoyValueProvider> providerMap) {
        this.providerMap = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(providerMap)));
    }

    @Override
    public int size() {
        return this.providerMap.size();
    }

    @Override
    @Nonnull
    public final Iterable<? extends SoyValue> keys() {
        return this.providerMap.keySet();
    }

    @Override
    public boolean containsKey(SoyValue key) {
        return this.providerMap.containsKey((Object)key);
    }

    @Override
    public SoyValue get(SoyValue key) {
        SoyValueProvider provider = this.getProvider(key);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public SoyValueProvider getProvider(SoyValue key) {
        return (SoyValueProvider)this.providerMap.get((Object)key);
    }

    @Override
    @Nonnull
    public Map<? extends SoyValue, ? extends SoyValueProvider> asJavaMap() {
        return this.providerMap;
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        for (SoyValue soyValue : this.keys()) {
            SoyValue value = this.get(soyValue);
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValue.render(appendable);
            appendable.append(": ");
            value.render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.coerceToString();
    }
}

