/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnknownType;

public final class GlobalNode
extends AbstractExprNode {
    private final String name;
    private boolean suppressUnknownGlobalErrors;
    private ExprNode.PrimitiveNode value = null;
    private SoyType soyType = UnknownType.getInstance();
    private ResolutionCallback resolveCallback;

    public static GlobalNode error(SourceLocation location) {
        return new GlobalNode("error", location);
    }

    public GlobalNode(String name, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.name = name;
    }

    private GlobalNode(GlobalNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.soyType = orig.soyType;
        this.value = orig.value;
        this.resolveCallback = orig.resolveCallback;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.GLOBAL_NODE;
    }

    @Override
    public SoyType getType() {
        return this.soyType;
    }

    public void resolve(SoyType soyType, ExprNode.PrimitiveNode value) {
        Preconditions.checkState((this.value == null ? 1 : 0) != 0, (Object)"value has already been set");
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)soyType);
        this.value = (ExprNode.PrimitiveNode)Preconditions.checkNotNull((Object)value);
        if (this.resolveCallback != null) {
            this.resolveCallback.onResolve(value);
            this.resolveCallback = null;
        }
    }

    public void onResolve(ResolutionCallback callback) {
        Preconditions.checkState((this.resolveCallback == null ? 1 : 0) != 0, (Object)"callback has already been set.");
        Preconditions.checkState((this.value == null ? 1 : 0) != 0, (Object)"value is resolved.");
        this.resolveCallback = (ResolutionCallback)Preconditions.checkNotNull((Object)callback);
    }

    public boolean isResolved() {
        return this.value != null;
    }

    public ExprNode.PrimitiveNode getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void suppressUnknownGlobalErrors() {
        this.suppressUnknownGlobalErrors = true;
    }

    public boolean shouldSuppressUnknownGlobalErrors() {
        return this.suppressUnknownGlobalErrors;
    }

    @Override
    public String toSourceString() {
        return this.name;
    }

    @Override
    public GlobalNode copy(CopyState copyState) {
        return new GlobalNode(this, copyState);
    }

    public static interface ResolutionCallback {
        public void onResolve(ExprNode.PrimitiveNode var1);
    }
}

