/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import java.util.List;

public final class LegacyObjectMapLiteralNode
extends AbstractParentExprNode {
    public LegacyObjectMapLiteralNode(List<ExprNode> alternatingKeysAndValues, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.addChildren((List<? extends ExprNode>)alternatingKeysAndValues);
    }

    private LegacyObjectMapLiteralNode(LegacyObjectMapLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.LEGACY_OBJECT_MAP_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        if (this.numChildren() == 0) {
            return "[:]";
        }
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append('[');
        int n = this.numChildren();
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                sourceSb.append(", ");
            }
            sourceSb.append(this.getChild(i).toSourceString()).append(": ").append(this.getChild(i + 1).toSourceString());
        }
        sourceSb.append(']');
        return sourceSb.toString();
    }

    @Override
    public LegacyObjectMapLiteralNode copy(CopyState copyState) {
        return new LegacyObjectMapLiteralNode(this, copyState);
    }
}

