/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import java.util.Map;

public final class MapLiteralNode
extends AbstractParentExprNode {
    public MapLiteralNode(ImmutableMap<ExprNode, ExprNode> map, SourceLocation sourceLocation) {
        super(sourceLocation);
        for (Map.Entry entry : map.entrySet()) {
            this.addChild((ExprNode)entry.getKey());
            this.addChild((ExprNode)entry.getValue());
        }
    }

    private MapLiteralNode(MapLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.MAP_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder("map(");
        int n = this.numChildren();
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.getChild(i).toSourceString()).append(": ").append(this.getChild(i + 1).toSourceString());
        }
        return sb.append(')').toString();
    }

    @Override
    public MapLiteralNode copy(CopyState copyState) {
        return new MapLiteralNode(this, copyState);
    }
}

