/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.i18ndirectives;

import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import javax.annotation.Nullable;

public final class I18NDirectivesRuntime {
    private I18NDirectivesRuntime() {
    }

    public static String formatNum(ULocale uLocale, double number, String formatType, String numbersKeyword, @Nullable Integer minFractionDigits, @Nullable Integer maxFractionDigits) {
        NumberFormat numberFormat;
        uLocale = uLocale.setKeywordValue("numbers", numbersKeyword);
        switch (formatType) {
            case "decimal": {
                numberFormat = NumberFormat.getInstance((ULocale)uLocale);
                break;
            }
            case "percent": {
                numberFormat = NumberFormat.getPercentInstance((ULocale)uLocale);
                break;
            }
            case "currency": {
                numberFormat = NumberFormat.getCurrencyInstance((ULocale)uLocale);
                break;
            }
            case "scientific": {
                numberFormat = NumberFormat.getScientificInstance((ULocale)uLocale);
                break;
            }
            case "compact_short": {
                CompactDecimalFormat compactNumberFormat = CompactDecimalFormat.getInstance((ULocale)uLocale, (CompactDecimalFormat.CompactStyle)CompactDecimalFormat.CompactStyle.SHORT);
                compactNumberFormat.setMaximumSignificantDigits(3);
                numberFormat = compactNumberFormat;
                break;
            }
            case "compact_long": {
                CompactDecimalFormat compactNumberFormat = CompactDecimalFormat.getInstance((ULocale)uLocale, (CompactDecimalFormat.CompactStyle)CompactDecimalFormat.CompactStyle.LONG);
                compactNumberFormat.setMaximumSignificantDigits(3);
                numberFormat = compactNumberFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("First argument to formatNum must be constant, and one of: 'decimal', 'currency', 'percent', 'scientific', 'compact_short', or 'compact_long'.");
            }
        }
        if (minFractionDigits != null) {
            numberFormat.setMinimumFractionDigits(minFractionDigits.intValue());
        }
        if (maxFractionDigits != null) {
            numberFormat.setMaximumFractionDigits(maxFractionDigits.intValue());
        }
        return numberFormat.format(number);
    }
}

