/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import javax.annotation.Nullable;

public final class ProtoUtils {
    private static final ImmutableSet<String> SAFE_PROTO_TYPES = ImmutableSet.of((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)SafeScriptProto.getDescriptor().getFullName(), (Object)SafeStyleProto.getDescriptor().getFullName(), (Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)SafeUrlProto.getDescriptor().getFullName(), (Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object[])new String[0]);
    private static final ImmutableSet<Descriptors.FieldDescriptor.Type> JS_TYPEABLE_FIELDS = Sets.immutableEnumSet((Enum)Descriptors.FieldDescriptor.Type.INT64, (Enum[])new Descriptors.FieldDescriptor.Type[]{Descriptors.FieldDescriptor.Type.SFIXED64, Descriptors.FieldDescriptor.Type.UINT64, Descriptors.FieldDescriptor.Type.FIXED64, Descriptors.FieldDescriptor.Type.SINT64});

    private ProtoUtils() {
    }

    public static boolean isSanitizedContentField(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && SAFE_PROTO_TYPES.contains((Object)fieldDescriptor.getMessageType().getFullName());
    }

    public static boolean isSanitizedContentMap(Descriptors.FieldDescriptor fieldDescriptor) {
        if (!fieldDescriptor.isMapField()) {
            return false;
        }
        Descriptors.Descriptor valueDesc = ProtoUtils.getMapValueMessageType(fieldDescriptor);
        if (valueDesc == null) {
            return false;
        }
        return SAFE_PROTO_TYPES.contains((Object)valueDesc.getFullName());
    }

    @Nullable
    public static Descriptors.Descriptor getMapValueMessageType(Descriptors.FieldDescriptor mapField) {
        Descriptors.FieldDescriptor valueDesc = mapField.getMessageType().findFieldByName("value");
        if (valueDesc.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            return valueDesc.getMessageType();
        }
        return null;
    }

    public static String getTofuExtensionImport(Descriptors.FieldDescriptor desc) {
        String extensionFieldName = JavaQualifiedNames.getFieldName(desc, false);
        String extensionFieldHolderClassName = desc.getExtensionScope() != null ? JavaQualifiedNames.getQualifiedName(desc.getExtensionScope()) : JavaQualifiedNames.getPackage(desc.getFile()) + "." + JavaQualifiedNames.getOuterClassname(desc.getFile());
        return extensionFieldHolderClassName + "." + extensionFieldName + ".getDescriptor()";
    }

    public static String getJsExtensionImport(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            while (scope.getContainingType() != null) {
                scope = scope.getContainingType();
            }
            return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)scope);
        }
        return ProtoUtils.getJsPackage(desc.getFile()) + "." + ProtoUtils.computeJsExtensionName(desc);
    }

    public static String getJsExtensionName(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)scope) + "." + ProtoUtils.computeJsExtensionName(desc);
        }
        return ProtoUtils.getJsPackage(desc.getFile()) + "." + ProtoUtils.computeJsExtensionName(desc);
    }

    private static String computeJsExtensionName(Descriptors.FieldDescriptor field) {
        String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
        return field.isRepeated() ? name + "List" : name;
    }

    private static String getJsPackage(Descriptors.FileDescriptor file) {
        String protoPackage = file.getPackage();
        if (!protoPackage.isEmpty()) {
            return "proto." + protoPackage;
        }
        return "proto";
    }

    public static boolean shouldJsIgnoreField(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    static boolean hasJsMapKey(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    static String getJsMapKeyFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        return null;
    }

    public static boolean hasJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (!JS_TYPEABLE_FIELDS.contains((Object)fieldDescriptor.getType())) {
            return false;
        }
        return fieldDescriptor.getOptions().hasJstype();
    }

    public static boolean isUnsigned(Descriptors.FieldDescriptor descriptor) {
        switch (descriptor.getType()) {
            case FIXED32: 
            case FIXED64: 
            case UINT32: 
            case UINT64: {
                return true;
            }
        }
        return false;
    }

    public static DescriptorProtos.FieldOptions.JSType getJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        boolean hasJstype = fieldDescriptor.getOptions().hasJstype();
        if (hasJstype) {
            return fieldDescriptor.getOptions().getJstype();
        }
        return null;
    }

    public static String calculateJsEnumName(Descriptors.EnumDescriptor descriptor) {
        return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)descriptor);
    }

    public static String calculateQualifiedJsName(Descriptors.GenericDescriptor descriptor) {
        String protoPackage = descriptor.getFile().getPackage();
        String name = descriptor.getFullName();
        if (!name.startsWith(protoPackage)) {
            throw new AssertionError((Object)("Expected \"" + name + "\" to start with \"" + protoPackage + "\""));
        }
        String jsPackage = ProtoUtils.getJsPackage(descriptor.getFile());
        if (protoPackage.isEmpty()) {
            return jsPackage + "." + name;
        }
        return jsPackage + name.substring(protoPackage.length());
    }

    static boolean shouldCheckFieldPresenceToEmulateJspbNullability(Descriptors.FieldDescriptor desc) {
        boolean hasBrokenSemantics = false;
        if (desc.hasDefaultValue() || desc.isRepeated()) {
            return false;
        }
        if (desc.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3 || !hasBrokenSemantics) {
            return desc.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }
        return true;
    }
}

