/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.HashMap;
import javax.annotation.Nullable;

final class CompiledTemplateRegistry {
    private final ImmutableBiMap<String, CompiledTemplateMetadata> templateNameToMetadata;
    private final ImmutableBiMap<String, CompiledTemplateMetadata> classNameToMetadata;
    private final ImmutableMap<String, Optional<SanitizedContentKind>> deltemplateNameToContentKind;
    private final ImmutableSet<String> delegateTemplateNames;

    CompiledTemplateRegistry(TemplateRegistry registry) {
        HashMap<String, Optional> deltemplateNameToContentKind = new HashMap<String, Optional>();
        ImmutableBiMap.Builder templateToMetadata = ImmutableBiMap.builder();
        ImmutableBiMap.Builder classToMetadata = ImmutableBiMap.builder();
        ImmutableSet.Builder delegateTemplateNames = ImmutableSet.builder();
        for (TemplateNode template : registry.getAllTemplates()) {
            CompiledTemplateMetadata metadata = CompiledTemplateMetadata.create(template.getTemplateName(), template);
            templateToMetadata.put((Object)template.getTemplateName(), (Object)metadata);
            classToMetadata.put((Object)metadata.typeInfo().className(), (Object)metadata);
            if (!(template instanceof TemplateDelegateNode)) continue;
            delegateTemplateNames.add((Object)template.getTemplateName());
            deltemplateNameToContentKind.put(((TemplateDelegateNode)template).getDelTemplateName(), Optional.fromNullable((Object)((Object)template.getContentKind())));
        }
        this.templateNameToMetadata = templateToMetadata.build();
        this.classNameToMetadata = classToMetadata.build();
        this.deltemplateNameToContentKind = ImmutableMap.copyOf(deltemplateNameToContentKind);
        this.delegateTemplateNames = delegateTemplateNames.build();
    }

    ImmutableSet<String> getTemplateNames() {
        return this.templateNameToMetadata.keySet();
    }

    ImmutableSet<String> getDelegateTemplateNames() {
        return this.delegateTemplateNames;
    }

    CompiledTemplateMetadata getTemplateInfoByTemplateName(String templateName) {
        return (CompiledTemplateMetadata)this.templateNameToMetadata.get((Object)templateName);
    }

    CompiledTemplateMetadata getTemplateInfoByClassName(String templateName) {
        return (CompiledTemplateMetadata)this.classNameToMetadata.get((Object)templateName);
    }

    @Nullable
    SanitizedContentKind getDelTemplateContentKind(String delTemplateName) {
        return (SanitizedContentKind)((Object)((Optional)this.deltemplateNameToContentKind.get((Object)delTemplateName)).orNull());
    }

    boolean hasDelTemplateDefinition(String delTemplateName) {
        return this.deltemplateNameToContentKind.containsKey((Object)delTemplateName);
    }
}

