/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_DetachState_ReattachState;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.TableSwitchGenerator;

final class DetachState
implements ExpressionDetacher.Factory {
    private final TemplateVariableManager variables;
    private final List<ReattachState> reattaches = new ArrayList<ReattachState>();
    private final Expression thisExpr;
    private final FieldRef stateField;

    DetachState(TemplateVariableManager variables, Expression thisExpr, FieldRef stateField) {
        Preconditions.checkArgument((boolean)stateField.type().equals((Object)Type.INT_TYPE));
        this.variables = variables;
        this.thisExpr = thisExpr;
        this.stateField = stateField;
        this.reattaches.add(null);
    }

    @Override
    public ExpressionDetacher createExpressionDetacher(Label reattachPoint) {
        TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState();
        Statement restore = saveRestoreState.restore();
        int state = this.addState(reattachPoint, restore);
        Statement saveState = this.stateField.putInstanceField(this.thisExpr, BytecodeUtils.constant(state));
        return new ExpressionDetacher.BasicDetacher(Statement.concat(saveRestoreState.save(), saveState));
    }

    Statement detachLimited(AppendableExpression appendable) {
        if (!appendable.supportsSoftLimiting()) {
            return appendable.toStatement();
        }
        final Label reattachPoint = new Label();
        final TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState();
        Statement restore = saveRestoreState.restore();
        int state = this.addState(reattachPoint, restore);
        final Expression isSoftLimited = appendable.softLimitReached();
        final Statement returnLimited = Statement.returnExpression(MethodRef.RENDER_RESULT_LIMITED.invoke(new Expression[0]));
        final Statement saveState = this.stateField.putInstanceField(this.thisExpr, BytecodeUtils.constant(state));
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                isSoftLimited.gen(adapter);
                adapter.ifZCmp(153, reattachPoint);
                saveRestoreState.save().gen(adapter);
                saveState.gen(adapter);
                returnLimited.gen(adapter);
                adapter.mark(reattachPoint);
            }
        };
    }

    Statement detachForRender(final Expression callRender) {
        Preconditions.checkArgument((boolean)callRender.resultType().equals((Object)BytecodeUtils.RENDER_RESULT_TYPE));
        final Label reattachRender = new Label();
        final TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState();
        int state = this.addState(reattachRender, Statement.NULL_STATEMENT);
        final Statement saveState = this.stateField.putInstanceField(this.thisExpr, BytecodeUtils.constant(state));
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                callRender.gen(adapter);
                adapter.dup();
                MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                Label end = new Label();
                adapter.ifZCmp(154, end);
                saveRestoreState.save().gen(adapter);
                saveState.gen(adapter);
                adapter.returnValue();
                adapter.mark(reattachRender);
                callRender.gen(adapter);
                adapter.dup();
                MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                Label restore = new Label();
                adapter.ifZCmp(154, restore);
                adapter.returnValue();
                adapter.mark(restore);
                saveRestoreState.restore().gen(adapter);
                adapter.mark(end);
                adapter.pop();
            }
        };
    }

    Statement generateReattachTable() {
        final Expression readField = this.stateField.accessor(this.thisExpr);
        final Statement defaultCase = Statement.throwExpression(MethodRef.RUNTIME_UNEXPECTED_STATE_ERROR.invoke(readField));
        return new Statement(){

            @Override
            protected void doGen(final CodeBuilder adapter) {
                int[] keys = new int[DetachState.this.reattaches.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = i;
                }
                readField.gen(adapter);
                adapter.tableSwitch(keys, new TableSwitchGenerator(){

                    public void generateCase(int key, Label end) {
                        if (key == 0) {
                            adapter.goTo(end);
                            return;
                        }
                        ReattachState reattachState = (ReattachState)DetachState.this.reattaches.get(key);
                        reattachState.restoreStatement().gen(adapter);
                        adapter.goTo(reattachState.reattachPoint());
                    }

                    public void generateDefault() {
                        defaultCase.gen(adapter);
                    }
                }, true);
            }
        };
    }

    private int addState(Label reattachPoint, Statement restore) {
        ReattachState create = ReattachState.create(reattachPoint, restore);
        this.reattaches.add(create);
        int state = this.reattaches.size() - 1;
        return state;
    }

    int getNumberOfDetaches() {
        return this.reattaches.size() - 1;
    }

    static abstract class ReattachState {
        ReattachState() {
        }

        static ReattachState create(Label reattachPoint, Statement restore) {
            return new AutoValue_DetachState_ReattachState(reattachPoint, restore);
        }

        abstract Label reattachPoint();

        abstract Statement restoreStatement();
    }
}

