/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_LazyClosureCompiler_ParentCapture;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.DetachableContentProvider;
import com.google.template.soy.jbcsrc.runtime.DetachableSoyValueProvider;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class LazyClosureCompiler {
    private static final int LAZY_CLOSURE_ACCESS = 16;
    private static final Method DO_RESOLVE;
    private static final Method DO_RENDER;
    private static final Method DETACHABLE_CONTENT_PROVIDER_INIT;
    private static final FieldRef RESOLVED_VALUE;
    private static final TypeInfo DETACHABLE_CONTENT_PROVIDER_TYPE;
    private static final TypeInfo DETACHABLE_VALUE_PROVIDER_TYPE;
    private final CompiledTemplateRegistry registry;
    private final InnerClasses innerClasses;
    private final TemplateParameterLookup parentVariableLookup;
    private final ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler;
    private final TemplateVariableManager parentVariables;

    LazyClosureCompiler(CompiledTemplateRegistry registry, InnerClasses innerClasses, TemplateParameterLookup parentVariableLookup, TemplateVariableManager parentVariables, ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler) {
        this.registry = registry;
        this.innerClasses = innerClasses;
        this.parentVariableLookup = parentVariableLookup;
        this.parentVariables = parentVariables;
        this.expressionToSoyValueProviderCompiler = expressionToSoyValueProviderCompiler;
    }

    Expression compileLazyExpression(String namePrefix, SoyNode declaringNode, String varName, ExprNode exprNode) {
        Optional<Expression> asSoyValueProvider = this.expressionToSoyValueProviderCompiler.compileAvoidingDetaches(exprNode);
        if (asSoyValueProvider.isPresent()) {
            return (Expression)asSoyValueProvider.get();
        }
        TypeInfo type = this.innerClasses.registerInnerClassWithGeneratedName(this.getProposedName(namePrefix, varName), 16);
        SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_VALUE_PROVIDER_TYPE).sourceFileName(declaringNode.getSourceLocation().getFileName()).build();
        Expression expr = new CompilationUnit(writer, type, DETACHABLE_VALUE_PROVIDER_TYPE, declaringNode).compileExpression(exprNode);
        this.innerClasses.registerAsInnerClass(writer, type);
        writer.visitEnd();
        this.innerClasses.add(writer.toClassData());
        return expr;
    }

    Expression compileLazyContent(String namePrefix, SoyNode.RenderUnitNode renderUnit, String varName) {
        Optional<Expression> asRawText = this.asRawTextOnly(renderUnit);
        if (asRawText.isPresent()) {
            return (Expression)asRawText.get();
        }
        TypeInfo type = this.innerClasses.registerInnerClassWithGeneratedName(this.getProposedName(namePrefix, varName), 16);
        SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_CONTENT_PROVIDER_TYPE).sourceFileName(renderUnit.getSourceLocation().getFileName()).build();
        Expression expr = new CompilationUnit(writer, type, DETACHABLE_CONTENT_PROVIDER_TYPE, renderUnit).compileRenderable(renderUnit);
        this.innerClasses.registerAsInnerClass(writer, type);
        writer.visitEnd();
        this.innerClasses.add(writer.toClassData());
        return expr;
    }

    private Optional<Expression> asRawTextOnly(SoyNode.RenderUnitNode renderUnit) {
        StringBuilder builder = null;
        for (SoyNode.StandaloneNode child : renderUnit.getChildren()) {
            if (child instanceof RawTextNode) {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(((RawTextNode)child).getRawText());
                continue;
            }
            return Optional.absent();
        }
        SanitizedContentKind kind = renderUnit.getContentKind();
        Expression constant = BytecodeUtils.constant(builder == null ? "" : builder.toString(), this.parentVariables);
        if (kind == null) {
            return Optional.of((Object)MethodRef.STRING_DATA_FOR_VALUE.invoke(constant));
        }
        return Optional.of((Object)MethodRef.ORDAIN_AS_SAFE.invoke(constant, BytecodeUtils.constantSanitizedContentKindAsContentKind(kind)));
    }

    private String getProposedName(String prefix, String varName) {
        return prefix + "_" + varName;
    }

    static {
        RESOLVED_VALUE = FieldRef.instanceFieldReference(DetachableSoyValueProvider.class, "resolvedValue");
        DETACHABLE_CONTENT_PROVIDER_TYPE = TypeInfo.create(DetachableContentProvider.class);
        DETACHABLE_VALUE_PROVIDER_TYPE = TypeInfo.create(DetachableSoyValueProvider.class);
        try {
            DO_RESOLVE = Method.getMethod((java.lang.reflect.Method)DetachableSoyValueProvider.class.getDeclaredMethod("doResolve", new Class[0]));
            DO_RENDER = Method.getMethod((java.lang.reflect.Method)DetachableContentProvider.class.getDeclaredMethod("doRender", LoggingAdvisingAppendable.class));
            DETACHABLE_CONTENT_PROVIDER_INIT = Method.getMethod(DetachableContentProvider.class.getDeclaredConstructor(SanitizedContent.ContentKind.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class LazyClosureParameterLookup
    implements TemplateParameterLookup {
        private final CompilationUnit params;
        private final TemplateParameterLookup parentParameterLookup;
        private final TemplateVariableManager variableSet;
        private final Expression thisVar;
        private final Map<TemplateParam, ParentCapture> paramFields = new LinkedHashMap<TemplateParam, ParentCapture>();
        private final Map<LocalVar, ParentCapture> localFields = new LinkedHashMap<LocalVar, ParentCapture>();
        private final Map<SyntheticVarName, ParentCapture> syntheticFields = new LinkedHashMap<SyntheticVarName, ParentCapture>();
        private ParentCapture renderContextCapture;
        private ParentCapture paramsCapture;
        private ParentCapture ijCapture;

        LazyClosureParameterLookup(CompilationUnit params, TemplateParameterLookup parentParameterLookup, TemplateVariableManager variableSet, Expression thisVar) {
            this.params = params;
            this.parentParameterLookup = parentParameterLookup;
            this.variableSet = variableSet;
            this.thisVar = thisVar;
        }

        @Override
        public Expression getParam(TemplateParam param) {
            ParentCapture capturedField = this.paramFields.get(param);
            if (capturedField == null) {
                String name = param.name();
                this.params.fieldNames.claimName(name);
                capturedField = ParentCapture.create(this.params.type, name, this.parentParameterLookup.getParam(param));
                this.paramFields.put(param, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        @Override
        public Expression getLocal(LocalVar local) {
            if (SoyTreeUtils.isDescendantOf(local.declaringNode(), this.params.node)) {
                return this.variableSet.getVariable(local.name()).local();
            }
            ParentCapture capturedField = this.localFields.get(local);
            if (capturedField == null) {
                String name = this.params.fieldNames.generateName(local.name());
                capturedField = ParentCapture.create(this.params.type, name, this.parentParameterLookup.getLocal(local));
                this.localFields.put(local, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            if (SoyTreeUtils.isDescendantOf(varName.declaringNode(), this.params.node)) {
                return this.variableSet.getVariable(varName).local();
            }
            ParentCapture capturedField = this.syntheticFields.get(varName);
            if (capturedField == null) {
                String name = this.params.fieldNames.generateName(varName.name());
                capturedField = ParentCapture.create(this.params.type, name, this.parentParameterLookup.getLocal(varName));
                this.syntheticFields.put(varName, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        Iterable<ParentCapture> getCapturedFields() {
            return Iterables.concat((Iterable)Iterables.filter(Arrays.asList(this.paramsCapture, this.ijCapture, this.renderContextCapture), (Predicate)Predicates.notNull()), this.paramFields.values(), this.localFields.values(), this.syntheticFields.values());
        }

        @Override
        public RenderContextExpression getRenderContext() {
            if (this.renderContextCapture == null) {
                this.params.fieldNames.claimName("$renderContext");
                this.renderContextCapture = ParentCapture.create(this.params.type, "$renderContext", this.parentParameterLookup.getRenderContext());
            }
            return new RenderContextExpression(this.renderContextCapture.field().accessor(this.thisVar));
        }

        @Override
        public Expression getParamsRecord() {
            if (this.paramsCapture == null) {
                this.params.fieldNames.claimName("$params");
                this.paramsCapture = ParentCapture.create(this.params.type, "$params", this.parentParameterLookup.getParamsRecord());
            }
            return this.paramsCapture.field().accessor(this.thisVar);
        }

        @Override
        public Expression getIjRecord() {
            if (this.ijCapture == null) {
                this.params.fieldNames.claimName("$ij");
                this.ijCapture = ParentCapture.create(this.params.type, "$ij", this.parentParameterLookup.getIjRecord());
            }
            return this.ijCapture.field().accessor(this.thisVar);
        }
    }

    static abstract class ParentCapture {
        ParentCapture() {
        }

        static ParentCapture create(TypeInfo owner, String name, Expression parentExpression) {
            FieldRef captureField = FieldRef.createFinalField(owner, name, parentExpression.resultType());
            if (parentExpression.isNonNullable()) {
                captureField = captureField.asNonNull();
            }
            return new AutoValue_LazyClosureCompiler_ParentCapture(captureField, parentExpression);
        }

        abstract FieldRef field();

        abstract Expression parentExpression();
    }

    private final class CompilationUnit {
        final UniqueNameGenerator fieldNames = JbcSrcNameGenerators.forFieldNames();
        final TypeInfo type;
        final TypeInfo baseClass;
        final SoyNode node;
        final SoyClassWriter writer;

        CompilationUnit(SoyClassWriter writer, TypeInfo type, TypeInfo baseClass, SoyNode node) {
            this.writer = writer;
            this.type = type;
            this.baseClass = baseClass;
            this.node = node;
        }

        Expression compileExpression(ExprNode exprNode) {
            final Label start = new Label();
            final Label end = new Label();
            LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            TemplateVariableManager variableSet = new TemplateVariableManager(this.fieldNames, this.type, thisVar, DO_RESOLVE);
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, LazyClosureCompiler.this.parentVariableLookup, variableSet, thisVar);
            SoyExpression compile = ExpressionCompiler.createBasicCompiler(lookup, variableSet).compile(exprNode);
            SoyExpression expression = compile.box();
            final Statement storeExpr = RESOLVED_VALUE.putInstanceField(thisVar, expression);
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement doResolveImpl = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    storeExpr.gen(adapter);
                    returnDone.gen(adapter);
                    adapter.mark(end);
                }
            };
            variableSet.defineStaticFields(this.writer);
            Statement fieldInitializers = variableSet.defineFields(this.writer);
            Expression constructExpr = this.generateConstructor(new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.loadThis();
                    adapter.invokeConstructor(CompilationUnit.this.baseClass.type(), BytecodeUtils.NULLARY_INIT);
                }
            }, fieldInitializers, lookup.getCapturedFields());
            doResolveImpl.writeMethod(4, DO_RESOLVE, this.writer);
            return constructExpr;
        }

        Expression compileRenderable(SoyNode.RenderUnitNode renderUnit) {
            FieldRef stateField = FieldRef.createField(this.type, "$state", Type.INT_TYPE);
            stateField.defineField(this.writer);
            this.fieldNames.claimName("$state");
            final Label start = new Label();
            final Label end = new Label();
            final LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            final LocalVariable appendableVar = LocalVariable.createLocal("appendable", 1, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, start, end).asNonNullable();
            final TemplateVariableManager variableSet = new TemplateVariableManager(this.fieldNames, this.type, thisVar, DO_RENDER);
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, LazyClosureCompiler.this.parentVariableLookup, variableSet, thisVar);
            SoyNodeCompiler soyNodeCompiler = SoyNodeCompiler.create(LazyClosureCompiler.this.registry, LazyClosureCompiler.this.innerClasses, stateField, thisVar, AppendableExpression.forLocal(appendableVar), variableSet, lookup);
            SoyNodeCompiler.CompiledMethodBody compileChildren = soyNodeCompiler.compile(renderUnit);
            this.writer.setNumDetachStates(compileChildren.numberOfDetachStates());
            final Statement nodeBody = compileChildren.body();
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement fullMethodBody = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    nodeBody.gen(adapter);
                    adapter.mark(end);
                    returnDone.gen(adapter);
                    thisVar.tableEntry(adapter);
                    appendableVar.tableEntry(adapter);
                    variableSet.generateTableEntries(adapter);
                }
            };
            SanitizedContentKind kind = renderUnit.getContentKind();
            final Expression contentKind = BytecodeUtils.constantSanitizedContentKindAsContentKind(kind);
            variableSet.defineStaticFields(this.writer);
            Statement fieldInitializers = variableSet.defineFields(this.writer);
            Statement superClassContstructor = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.loadThis();
                    contentKind.gen(adapter);
                    adapter.invokeConstructor(CompilationUnit.this.baseClass.type(), DETACHABLE_CONTENT_PROVIDER_INIT);
                }
            };
            Expression constructExpr = this.generateConstructor(superClassContstructor, fieldInitializers, lookup.getCapturedFields());
            fullMethodBody.writeMethod(4, DO_RENDER, this.writer);
            return constructExpr;
        }

        Expression generateConstructor(final Statement superClassConstructorInvocation, final Statement fieldInitializers, Iterable<ParentCapture> captures) {
            final Label start = new Label();
            final Label end = new Label();
            final LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            final ArrayList<LocalVariable> params = new ArrayList<LocalVariable>();
            ArrayList<Type> paramTypes = new ArrayList<Type>();
            final ArrayList<Statement> assignments = new ArrayList<Statement>();
            ArrayList<Expression> argExpressions = new ArrayList<Expression>();
            int index = 1;
            for (ParentCapture capture : captures) {
                FieldRef field = capture.field();
                field.defineField(this.writer);
                LocalVariable var = LocalVariable.createLocal(field.name(), index, field.type(), start, end);
                assignments.add(field.putInstanceField(thisVar, var));
                argExpressions.add(capture.parentExpression());
                params.add(var);
                paramTypes.add(field.type());
                index += field.type().getSize();
            }
            Statement constructorBody = new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    cb.mark(start);
                    superClassConstructorInvocation.gen(cb);
                    fieldInitializers.gen(cb);
                    for (Statement assignment : assignments) {
                        assignment.gen(cb);
                    }
                    cb.returnValue();
                    cb.mark(end);
                    thisVar.tableEntry(cb);
                    for (LocalVariable local : params) {
                        local.tableEntry(cb);
                    }
                }
            };
            ConstructorRef constructor = ConstructorRef.create(this.type, paramTypes);
            constructorBody.writeMethod(1, constructor.method(), this.writer);
            return constructor.construct(argExpressions);
        }
    }
}

