/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.internal.ShortCircuitable;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class JbcSrcRuntime {
    public static final SoyValueProvider NULL_PROVIDER = new SoyValueProvider(){

        @Override
        public RenderResult status() {
            return RenderResult.done();
        }

        @Override
        public SoyValue resolve() {
            return null;
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
            appendable.append("null");
            return RenderResult.done();
        }

        public String toString() {
            return "NULL_PROVIDER";
        }
    };
    private static final LoggingAdvisingAppendable LOGGER = new AbstractLoggingAdvisingAppendable(){

        @Override
        public final boolean softLimitReached() {
            return false;
        }

        @Override
        protected final void doAppend(char c) throws IOException {
            System.out.append(c);
        }

        @Override
        protected final void doAppend(CharSequence csq, int start, int end) throws IOException {
            System.out.append(csq, start, end);
        }

        @Override
        protected final void doAppend(CharSequence csq) throws IOException {
            System.out.append(csq);
        }

        @Override
        protected final void doEnterLoggableElement(LogStatement statement) {
        }

        @Override
        protected final void doExitLoggableElement() {
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            String val = funCall.placeholderValue();
            for (Function directive : escapers) {
                val = (String)directive.apply((Object)val);
            }
            System.out.append(val);
        }
    };

    public static AssertionError unexpectedStateError(int state) {
        return new AssertionError((Object)("Unexpected state requested: " + state));
    }

    public static boolean stringEqualsAsNumber(String expr, double number) {
        if (expr == null) {
            return false;
        }
        try {
            return Double.parseDouble(expr) == number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static SoyValue resolveSoyValueProvider(SoyValueProvider provider) {
        SoyValue value = provider.resolve();
        return JbcSrcRuntime.handleTofuNull(value);
    }

    private static SoyValue handleTofuNull(SoyValue value) {
        if (value instanceof NullData | value instanceof UndefinedData) {
            return null;
        }
        return value;
    }

    public static SoyValueProvider getFieldProvider(SoyRecord record, String field) {
        if (record == null) {
            throw new NullPointerException("Attempted to access field '" + field + "' of null");
        }
        SoyValueProvider provider = record.getFieldProvider(field);
        return provider == null | provider instanceof NullData ? NULL_PROVIDER : provider;
    }

    public static SoyValue callSoyFunction(SoyJavaFunction function, List<SoyValue> args) {
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return JbcSrcRuntime.handleTofuNull(function.computeForJava(args));
    }

    public static SoyValue applyPrintDirective(SoyJavaPrintDirective directive, SoyValue value, List<SoyValue> args) {
        value = value == null ? NullData.INSTANCE : value;
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return directive.applyForJava(value, args);
    }

    public static CompiledTemplate applyEscapers(CompiledTemplate delegate, ImmutableList<SoyJavaPrintDirective> directives) {
        SanitizedContent.ContentKind kind = delegate.kind();
        if (JbcSrcRuntime.canSkipEscaping(directives, kind)) {
            return delegate;
        }
        return new EscapedCompiledTemplate(delegate, (List<SoyJavaPrintDirective>)directives, kind);
    }

    private static boolean canSkipEscaping(ImmutableList<SoyJavaPrintDirective> directives, @Nullable SanitizedContent.ContentKind kind) {
        if (kind == null) {
            return false;
        }
        for (SoyJavaPrintDirective directive : directives) {
            if (directive instanceof ShortCircuitable && ((ShortCircuitable)((Object)directive)).isNoopForKind(kind)) continue;
            return false;
        }
        return true;
    }

    public static SoyValueProvider getSoyListItem(List<SoyValueProvider> list, long index) {
        if (list == null) {
            throw new NullPointerException("Attempted to access list item '" + index + "' of null");
        }
        int size = list.size();
        if (index < (long)size & index >= 0L) {
            SoyValueProvider soyValueProvider = list.get((int)index);
            return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
        }
        return NULL_PROVIDER;
    }

    public static RenderResult getListStatus(List<? extends SoyValueProvider> soyValueProviders) {
        int size = soyValueProviders.size();
        for (int i = 0; i < size; ++i) {
            RenderResult result = soyValueProviders.get(i).status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static RenderResult getMapStatus(Map<String, ? extends SoyValueProvider> soyValueProviders) {
        for (SoyValueProvider soyValueProvider : soyValueProviders.values()) {
            RenderResult result = soyValueProvider.status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static SoyValueProvider getSoyMapItem(SoyMap soyMap, SoyValue key) {
        SoyValueProvider soyValueProvider;
        if (soyMap == null) {
            throw new NullPointerException("Attempted to access map item '" + key + "' of null");
        }
        if (key == null) {
            key = NullData.INSTANCE;
        }
        return (soyValueProvider = soyMap.getProvider(key)) == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static SoyValueProvider getSoyLegacyObjectMapItem(SoyLegacyObjectMap legacyObjectMap, SoyValue key) {
        if (legacyObjectMap == null) {
            throw new NullPointerException("Attempted to access map item '" + key + "' of null");
        }
        SoyValueProvider soyValueProvider = legacyObjectMap.getItemProvider(key);
        return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static void renderSoyMsgPartsWithPlaceholders(ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, Map<String, Object> placeholders, Appendable out) throws IOException {
        SoyMsgPart firstPart = (SoyMsgPart)msgParts.get(0);
        if (firstPart instanceof SoyMsgPluralPart) {
            JbcSrcRuntime.renderPlural(locale, (SoyMsgPluralPart)firstPart, placeholders, out);
        } else if (firstPart instanceof SoyMsgSelectPart) {
            JbcSrcRuntime.renderSelect(locale, (SoyMsgSelectPart)firstPart, placeholders, out);
        } else {
            for (int i = 0; i < msgParts.size(); ++i) {
                SoyMsgPart msgPart = (SoyMsgPart)msgParts.get(i);
                if (msgPart instanceof SoyMsgRawTextPart) {
                    JbcSrcRuntime.writeRawText((SoyMsgRawTextPart)msgPart, out);
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    JbcSrcRuntime.writePlaceholder((SoyMsgPlaceholderPart)msgPart, placeholders, out);
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + msgPart));
            }
        }
    }

    private static void renderSelect(@Nullable ULocale locale, SoyMsgSelectPart firstPart, Map<String, Object> placeholders, Appendable out) throws IOException {
        String selectCase = JbcSrcRuntime.getSelectCase(placeholders, firstPart.getSelectVarName());
        for (SoyMsgPart casePart : firstPart.lookupCase(selectCase)) {
            if (casePart instanceof SoyMsgSelectPart) {
                JbcSrcRuntime.renderSelect(locale, (SoyMsgSelectPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgPluralPart) {
                JbcSrcRuntime.renderPlural(locale, (SoyMsgPluralPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgPlaceholderPart) {
                JbcSrcRuntime.writePlaceholder((SoyMsgPlaceholderPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgRawTextPart) {
                JbcSrcRuntime.writeRawText((SoyMsgRawTextPart)casePart, out);
                continue;
            }
            throw new AssertionError((Object)("unexpected part: " + casePart));
        }
    }

    private static void renderPlural(@Nullable ULocale locale, SoyMsgPluralPart plural, Map<String, Object> placeholders, Appendable out) throws IOException {
        long pluralValue = JbcSrcRuntime.getPlural(placeholders, plural.getPluralVarName());
        for (SoyMsgPart casePart : plural.lookupCase(pluralValue, locale)) {
            if (casePart instanceof SoyMsgPlaceholderPart) {
                JbcSrcRuntime.writePlaceholder((SoyMsgPlaceholderPart)casePart, placeholders, out);
                continue;
            }
            if (casePart instanceof SoyMsgRawTextPart) {
                JbcSrcRuntime.writeRawText((SoyMsgRawTextPart)casePart, out);
                continue;
            }
            if (casePart instanceof SoyMsgPluralRemainderPart) {
                out.append(String.valueOf(pluralValue - (long)plural.getOffset()));
                continue;
            }
            throw new AssertionError((Object)("unexpected part: " + casePart));
        }
    }

    private static String getSelectCase(Map<String, Object> placeholders, String selectVarName) {
        String selectCase = (String)placeholders.get(selectVarName);
        if (selectCase == null) {
            throw new IllegalArgumentException("No value provided for select: '" + selectVarName + "'");
        }
        return selectCase;
    }

    private static long getPlural(Map<String, Object> placeholders, String pluralVarName) {
        IntegerData pluralValue = (IntegerData)placeholders.get(pluralVarName);
        if (pluralValue == null) {
            throw new IllegalArgumentException("No value provided for plural: '" + pluralVarName + "'");
        }
        return pluralValue.longValue();
    }

    private static void writePlaceholder(SoyMsgPlaceholderPart placeholder, Map<String, Object> placeholders, Appendable out) throws IOException {
        String placeholderName = placeholder.getPlaceholderName();
        String str = (String)placeholders.get(placeholderName);
        if (str == null) {
            throw new IllegalArgumentException("No value provided for placeholder: '" + placeholderName + "'");
        }
        out.append(str);
    }

    private static void writeRawText(SoyMsgRawTextPart msgPart, Appendable out) throws IOException {
        out.append(msgPart.getRawText());
    }

    public static boolean compareNullableString(@Nullable String string, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return Objects.equals(string, other.toString());
        }
        if (other instanceof NumberData) {
            if (string == null) {
                return false;
            }
            try {
                return Double.parseDouble(string) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    public static LoggingAdvisingAppendable logger() {
        return LOGGER;
    }

    public static int rangeLoopLength(int start, int end, int step) {
        int length = end - start;
        if ((length ^ step) < 0) {
            return 0;
        }
        return length / step + (length % step == 0 ? 0 : 1);
    }

    public static boolean coerceToBoolean(double v) {
        return v != 0.0 & !Double.isNaN(v);
    }

    public static String coerceToString(@Nullable SoyValue v) {
        return v == null ? "null" : v.coerceToString();
    }

    public static ClosePropagatingAppendable propagateClose(LoggingAdvisingAppendable delegate, ImmutableList<Closeable> closeables) {
        return new ClosePropagatingAppendable(delegate, closeables);
    }

    private static final class ClosePropagatingAppendable
    extends ForwardingLoggingAdvisingAppendable
    implements Closeable {
        final ImmutableList<Closeable> closeables;

        ClosePropagatingAppendable(LoggingAdvisingAppendable delegate, ImmutableList<Closeable> closeables) {
            super(delegate);
            this.closeables = closeables;
        }

        @Override
        public void close() throws IOException {
            for (Closeable c : this.closeables) {
                c.close();
            }
        }
    }

    private static final class EscapedCompiledTemplate
    implements CompiledTemplate {
        private final CompiledTemplate delegate;
        private final ImmutableList<SoyJavaPrintDirective> directives;
        @Nullable
        private final SanitizedContent.ContentKind kind;
        private final LoggingAdvisingAppendable buffer = LoggingAdvisingAppendable.buffering();

        EscapedCompiledTemplate(CompiledTemplate delegate, List<SoyJavaPrintDirective> directives, @Nullable SanitizedContent.ContentKind kind) {
            this.delegate = delegate;
            this.directives = ImmutableList.copyOf(directives);
            this.kind = kind;
        }

        @Override
        public RenderResult render(LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
            RenderResult result = this.delegate.render(this.buffer, context);
            if (result.isDone()) {
                SoyValue resultData = this.kind == null ? StringData.forValue(this.buffer.toString()) : UnsafeSanitizedContentOrdainer.ordainAsSafe(this.buffer.toString(), this.kind);
                for (SoyJavaPrintDirective directive : this.directives) {
                    resultData = directive.applyForJava(resultData, (List<SoyValue>)ImmutableList.of());
                }
                appendable.append(resultData.coerceToString());
            }
            return result;
        }

        @Override
        @Nullable
        public SanitizedContent.ContentKind kind() {
            return this.kind;
        }
    }
}

