/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class RenderContext {
    private static final CompiledTemplate EMPTY_TEMPLATE = new CompiledTemplate(){

        @Override
        public RenderResult render(LoggingAdvisingAppendable appendable, RenderContext context) {
            return RenderResult.done();
        }

        @Override
        @Nullable
        public SanitizedContent.ContentKind kind() {
            return null;
        }
    };
    private final Predicate<String> activeDelPackageSelector;
    private final CompiledTemplates templates;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final ImmutableMap<String, SoyJavaFunction> soyJavaFunctionsMap;
    private final ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap;
    private final SoyMsgBundle msgBundle;
    private final boolean debugSoyTemplateInfo;
    private final boolean hasLogger;

    private RenderContext(Builder builder) {
        this.activeDelPackageSelector = (Predicate)Preconditions.checkNotNull((Object)builder.activeDelPackageSelector);
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)builder.templates);
        this.cssRenamingMap = builder.cssRenamingMap;
        this.xidRenamingMap = builder.xidRenamingMap;
        this.soyJavaFunctionsMap = builder.soyJavaFunctionsMap;
        this.soyJavaDirectivesMap = builder.soyJavaDirectivesMap;
        this.msgBundle = builder.msgBundle;
        this.debugSoyTemplateInfo = builder.debugSoyTemplateInfo;
        this.hasLogger = builder.hasLogger;
    }

    @Nullable
    public ULocale getLocale() {
        return this.msgBundle.getLocale();
    }

    public BidiGlobalDir getBidiGlobalDir() {
        return BidiGlobalDir.forStaticIsRtl(this.msgBundle.isRtl());
    }

    public String renameCssSelector(String selector) {
        String string = this.cssRenamingMap.get(selector);
        return string == null ? selector : string;
    }

    public String renameXid(String id) {
        String string = this.xidRenamingMap.get(id);
        return string == null ? id + "_" : string;
    }

    public SoyJavaFunction getFunction(String name) {
        SoyJavaFunction fn = (SoyJavaFunction)this.soyJavaFunctionsMap.get((Object)name);
        if (fn == null) {
            throw new IllegalStateException("Failed to find Soy function with name '" + name + "'");
        }
        return fn;
    }

    public SoyJavaPrintDirective getPrintDirective(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        return printDirective;
    }

    public Function<String, String> getEscapingDirectiveAsFunction(String name) {
        final SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        if (!printDirective.getValidArgsSizes().contains(0)) {
            throw new IllegalStateException("Soy print directive with name '" + name + "' is not an escaping directive");
        }
        return new Function<String, String>(){

            public String apply(String input) {
                return printDirective.applyForJava(StringData.forValue(input), (List<SoyValue>)ImmutableList.of()).stringValue();
            }
        };
    }

    public boolean getDebugSoyTemplateInfo() {
        return this.debugSoyTemplateInfo;
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public CompiledTemplate getDelTemplate(String calleeName, String variant, boolean allowEmpty, SoyRecord params, SoyRecord ij) {
        CompiledTemplate.Factory callee = this.templates.selectDelTemplate(calleeName, variant, this.activeDelPackageSelector);
        if (callee == null) {
            if (allowEmpty) {
                return EMPTY_TEMPLATE;
            }
            throw new IllegalArgumentException("Found no active impl for delegate call to \"" + calleeName + (variant.isEmpty() ? "" : ":" + variant) + "\" (and delcall does not set allowemptydefault=\"true\").");
        }
        return callee.create(params, ij);
    }

    public boolean usePrimaryMsg(long msgId, long fallbackId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty();
    }

    public ImmutableList<SoyMsgPart> getSoyMsgParts(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            return defaultMsgParts;
        }
        return msgParts;
    }

    @VisibleForTesting
    public Builder toBuilder() {
        return new Builder().withActiveDelPackageSelector(this.activeDelPackageSelector).withSoyFunctions(this.soyJavaFunctionsMap).withSoyPrintDirectives((Map<String, ? extends SoyJavaPrintDirective>)this.soyJavaDirectivesMap).withCssRenamingMap(this.cssRenamingMap).withXidRenamingMap(this.xidRenamingMap).withMessageBundle(this.msgBundle).withCompiledTemplates(this.templates);
    }

    public static final class Builder {
        private CompiledTemplates templates;
        private Predicate<String> activeDelPackageSelector = Predicates.alwaysFalse();
        private SoyCssRenamingMap cssRenamingMap = SoyCssRenamingMap.EMPTY;
        private SoyIdRenamingMap xidRenamingMap = SoyCssRenamingMap.EMPTY;
        private ImmutableMap<String, SoyJavaFunction> soyJavaFunctionsMap = ImmutableMap.of();
        private ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap = ImmutableMap.of();
        private SoyMsgBundle msgBundle = SoyMsgBundle.EMPTY;
        private boolean debugSoyTemplateInfo = false;
        private boolean hasLogger;

        public Builder withCompiledTemplates(CompiledTemplates templates) {
            this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
            return this;
        }

        public Builder withActiveDelPackageSelector(Predicate<String> activeDelPackageSelector) {
            this.activeDelPackageSelector = (Predicate)Preconditions.checkNotNull(activeDelPackageSelector);
            return this;
        }

        public Builder withCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = (SoyCssRenamingMap)Preconditions.checkNotNull((Object)cssRenamingMap);
            return this;
        }

        public Builder withXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.xidRenamingMap = (SoyIdRenamingMap)Preconditions.checkNotNull((Object)xidRenamingMap);
            return this;
        }

        public Builder withSoyFunctions(ImmutableMap<String, SoyJavaFunction> functions) {
            this.soyJavaFunctionsMap = functions;
            return this;
        }

        public Builder withSoyPrintDirectives(Map<String, ? extends SoyJavaPrintDirective> directives) {
            this.soyJavaDirectivesMap = ImmutableMap.copyOf(directives);
            return this;
        }

        public Builder withMessageBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgBundle);
            return this;
        }

        public Builder withDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        public Builder hasLogger(boolean hasLogger) {
            this.hasLogger = hasLogger;
            return this;
        }

        public RenderContext build() {
            return new RenderContext(this);
        }
    }
}

