/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ArrayLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
abstract class ArrayLiteral
extends CodeChunk.WithValue {
    ArrayLiteral() {
    }

    abstract ImmutableList<? extends CodeChunk.WithValue> elements();

    static ArrayLiteral create(ImmutableList<? extends CodeChunk.WithValue> elements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (CodeChunk.WithValue element : elements) {
            builder.addAll(element.initialStatements());
        }
        return new AutoValue_ArrayLiteral((ImmutableList<CodeChunk>)builder.build(), elements);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue element : this.elements()) {
            element.collectRequires(collector);
        }
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        this.doFormatOutputExpr(ctx);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('[');
        boolean first = true;
        for (CodeChunk.WithValue element : this.elements()) {
            if (first) {
                first = false;
            } else {
                ctx.append(", ");
            }
            element.doFormatOutputExpr(ctx);
        }
        ctx.append(']');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk.WithValue element : this.elements()) {
            ctx.appendInitialStatements(element);
        }
    }
}

