/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import java.util.List;
import java.util.regex.Pattern;

public final class CodeChunkUtils {
    private static final Pattern ID = Pattern.compile("[A-Za-z_$][\\w$]*");

    private CodeChunkUtils() {
    }

    static void checkId(String id) {
        if (!ID.matcher(id).matches()) {
            throw new IllegalArgumentException(String.format("not a valid js identifier: %s", id));
        }
    }

    public static CodeChunk.WithValue concatChunks(List<? extends CodeChunk.WithValue> chunks) {
        return Concatenation.create(chunks);
    }

    public static CodeChunk.WithValue concatChunksForceString(List<? extends CodeChunk.WithValue> chunks) {
        if (!chunks.isEmpty() && chunks.get(0).isRepresentableAsSingleExpression() && JsExprUtils.isStringLiteral(chunks.get(0).assertExprAndCollectRequires(CodeChunk.RequiresCollector.NULL))) {
            return CodeChunkUtils.concatChunks(chunks);
        }
        if (chunks.size() > 1 && chunks.get(1).isRepresentableAsSingleExpression() && JsExprUtils.isStringLiteral(chunks.get(1).assertExprAndCollectRequires(CodeChunk.RequiresCollector.NULL))) {
            return CodeChunkUtils.concatChunks(chunks);
        }
        return CodeChunkUtils.concatChunks((List<? extends CodeChunk.WithValue>)ImmutableList.builder().add((Object)CodeChunk.LITERAL_EMPTY_STRING).addAll(chunks).build());
    }
}

