/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.jssrc.dsl.AutoValue_VariableDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.VariableReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class VariableDeclaration
extends CodeChunk {
    public static Builder builder(String name) {
        return new AutoValue_VariableDeclaration.Builder().setVarName(name).setGoogRequires((ImmutableSet<GoogRequire>)ImmutableSet.of());
    }

    abstract String varName();

    @Nullable
    abstract CodeChunk.WithValue rhs();

    @Nullable
    abstract String jsDoc();

    abstract ImmutableSet<GoogRequire> googRequires();

    public CodeChunk.WithValue ref() {
        return VariableReference.of(this);
    }

    @Override
    String getCode(int startingIndent) {
        FormattingContext ctx = new FormattingContext(startingIndent);
        ctx.appendInitialStatements(this);
        return ctx.toString();
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        if (this.rhs() != null) {
            ctx.appendInitialStatements(this.rhs());
        }
        if (this.jsDoc() != null) {
            ctx.append(this.jsDoc()).endLine();
        }
        ctx.append("var ").append(this.varName());
        if (this.rhs() != null) {
            ctx.append(" = ").appendOutputExpression(this.rhs());
        }
        ctx.append(";").endLine();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (GoogRequire require : this.googRequires()) {
            collector.add(require);
        }
        if (this.rhs() != null) {
            this.rhs().collectRequires(collector);
        }
    }

    public static abstract class Builder {
        abstract Builder setVarName(String var1);

        public abstract Builder setJsDoc(String var1);

        public abstract Builder setRhs(CodeChunk.WithValue var1);

        public Builder setGoogRequires(Iterable<GoogRequire> requires) {
            return this.setGoogRequires((ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires));
        }

        abstract Builder setGoogRequires(ImmutableSet<GoogRequire> var1);

        public abstract VariableDeclaration build();
    }
}

