/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.msgs.internal.IcuSyntaxUtils;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class GenJsCodeVisitorAssistantForMsgs
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private final SoyJsSrcOptions jsSrcOptions;
    protected final GenJsCodeVisitor master;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor genJsExprsVisitor;
    private final TemplateAliases templateAliases;
    protected final TranslationContext translationContext;
    private final ErrorReporter errorReporter;

    protected GenJsCodeVisitorAssistantForMsgs(GenJsCodeVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
        this.master = master;
        this.jsSrcOptions = jsSrcOptions;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.templateAliases = functionAliases;
        this.genJsExprsVisitor = genJsExprsVisitor;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode node) {
        throw new AssertionError();
    }

    public CodeChunk.WithValue generateMsgGroupVariable(MsgFallbackGroupNode node) {
        CodeChunk.WithValue msg;
        String tmpVarName = this.translationContext.nameGenerator().generateName("msg_s");
        if (node.numChildren() == 1) {
            this.translationContext.soyToJsVariableMappings().setIsPrimaryMsgInUse(node, CodeChunk.WithValue.LITERAL_TRUE);
            msg = this.generateSingleMsgVariable((MsgNode)node.getChild(0), tmpVarName);
        } else {
            msg = this.generateMsgGroupVariable(node, tmpVarName);
        }
        for (SoyPrintDirective printDirective : node.getEscapingDirectives()) {
            msg = SoyJsPluginUtils.applyDirective(this.translationContext.codeGenerator(), msg, (SoyJsSrcPrintDirective)printDirective, (List<CodeChunk.WithValue>)ImmutableList.of());
        }
        return msg;
    }

    private CodeChunk.WithValue generateSingleMsgVariable(MsgNode msgNode, String tmpVarName) {
        String googMsgVarName = this.buildGoogMsgVarNameHelper(msgNode);
        GoogMsgCodeGenInfo googMsgCodeGenInfo = this.genGoogGetMsgCallHelper(googMsgVarName, msgNode);
        if (!msgNode.isPlrselMsg()) {
            return googMsgCodeGenInfo.googMsgVar;
        }
        return VariableDeclaration.builder(tmpVarName).setRhs(GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(googMsgCodeGenInfo)).build().ref();
    }

    private CodeChunk.WithValue generateMsgGroupVariable(MsgFallbackGroupNode node, String tmpVarName) {
        CodeChunk condition;
        Preconditions.checkState((node.numChildren() == 2 ? 1 : 0) != 0);
        GoogMsgCodeGenInfo primaryCodeGenInfo = this.genGoogGetMsgCallHelper(this.buildGoogMsgVarNameHelper((MsgNode)node.getChild(0)), (MsgNode)node.getChild(0));
        GoogMsgCodeGenInfo fallbackCodeGenInfo = this.genGoogGetMsgCallHelper(this.buildGoogMsgVarNameHelper((MsgNode)node.getChild(1)), (MsgNode)node.getChild(1));
        CodeChunk.WithValue selectedMsg = VariableDeclaration.builder(tmpVarName).setRhs(CodeChunk.dottedIdNoRequire("goog.getMsgWithFallback").call(primaryCodeGenInfo.googMsgVar, fallbackCodeGenInfo.googMsgVar)).build().ref();
        CodeChunk.WithValue isPrimaryMsgInUse = CodeChunk.id(tmpVarName).doubleEquals(CodeChunk.id(primaryCodeGenInfo.googMsgVarName));
        this.translationContext.soyToJsVariableMappings().setIsPrimaryMsgInUse(node, isPrimaryMsgInUse);
        if (primaryCodeGenInfo.placeholders == null && fallbackCodeGenInfo.placeholders == null) {
            return selectedMsg;
        }
        if (primaryCodeGenInfo.placeholders != null) {
            ConditionalBuilder builder = CodeChunk.ifStatement(selectedMsg.doubleEquals(primaryCodeGenInfo.googMsgVar), selectedMsg.assign(GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(primaryCodeGenInfo)));
            if (fallbackCodeGenInfo.placeholders != null) {
                builder.else_(selectedMsg.assign(GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(fallbackCodeGenInfo)));
            }
            condition = builder.build();
        } else {
            condition = CodeChunk.ifStatement(selectedMsg.doubleEquals(fallbackCodeGenInfo.googMsgVar), selectedMsg.assign(GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(fallbackCodeGenInfo))).build();
        }
        return CodeChunk.id(tmpVarName).withInitialStatement(condition);
    }

    private String buildGoogMsgVarNameHelper(MsgNode msgNode) {
        String desiredName = this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgIdForDualFormat(msgNode) : "MSG_UNNAMED";
        return this.translationContext.nameGenerator().generateName(desiredName);
    }

    private GoogMsgCodeGenInfo genGoogGetMsgCallHelper(String googMsgVarName, MsgNode msgNode) {
        ImmutableList<SoyMsgPart> msgParts = MsgUtils.buildMsgParts(msgNode);
        CodeChunk.WithValue googMsgContent = CodeChunk.stringLiteral(GenJsCodeVisitorAssistantForMsgs.buildGoogMsgContentStr(msgParts, msgNode.isPlrselMsg()));
        GoogMsgPlaceholderCodeGenInfo placeholderInfo = new GoogMsgPlaceholderCodeGenInfo(msgNode.isPlrselMsg());
        this.genGoogMsgCodeForChildren(msgNode, msgNode, placeholderInfo);
        StringBuilder jsDocBuilder = new StringBuilder();
        jsDocBuilder.append("/** ");
        if (msgNode.getMeaning() != null) {
            jsDocBuilder.append("@meaning ").append(msgNode.getMeaning()).append("\n *  ");
        }
        jsDocBuilder.append("@desc ").append(msgNode.getDesc());
        if (msgNode.isHidden()) {
            jsDocBuilder.append("\n *  @hidden");
        }
        jsDocBuilder.append(" */");
        VariableDeclaration.Builder builder = VariableDeclaration.builder(googMsgVarName).setJsDoc(jsDocBuilder.toString());
        if (msgNode.isPlrselMsg() || placeholderInfo.placeholders.isEmpty()) {
            builder.setRhs(JsRuntime.GOOG_GET_MSG.call(googMsgContent));
            return new GoogMsgCodeGenInfo(builder.build().ref(), googMsgVarName, msgNode.isPlrselMsg() ? placeholderInfo.pluralsAndSelects.putAll(placeholderInfo.placeholders).build() : null);
        }
        builder.setRhs(JsRuntime.GOOG_GET_MSG.call(googMsgContent, placeholderInfo.placeholders.build()));
        return new GoogMsgCodeGenInfo(builder.build().ref(), googMsgVarName, null);
    }

    private static String buildGoogMsgContentStr(ImmutableList<SoyMsgPart> msgParts, boolean doUseBracedPhs) {
        msgParts = IcuSyntaxUtils.convertMsgPartsToEmbeddedIcuSyntax(msgParts);
        StringBuilder msgStrSb = new StringBuilder();
        for (SoyMsgPart msgPart : msgParts) {
            if (msgPart instanceof SoyMsgRawTextPart) {
                msgStrSb.append(((SoyMsgRawTextPart)msgPart).getRawText());
                continue;
            }
            if (msgPart instanceof SoyMsgPlaceholderPart) {
                String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                if (doUseBracedPhs) {
                    msgStrSb.append("{").append(placeholderName).append("}");
                    continue;
                }
                String googMsgPlaceholderName = GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
                msgStrSb.append("{$").append(googMsgPlaceholderName).append("}");
                continue;
            }
            throw new AssertionError();
        }
        return msgStrSb.toString();
    }

    private static CodeChunk.WithValue getMessageFormatCall(GoogMsgCodeGenInfo codeGenInfo) {
        return CodeChunk.new_(JsRuntime.GOOG_I18N_MESSAGE_FORMAT).call(codeGenInfo.googMsgVar).dotAccess("formatIgnoringPound").call(codeGenInfo.placeholders);
    }

    private void genGoogMsgCodeForChildren(SoyNode.BlockNode parentNode, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        for (SoyNode.StandaloneNode child : parentNode.getChildren()) {
            if (child instanceof RawTextNode) continue;
            if (child instanceof MsgPlaceholderNode) {
                this.genGoogMsgCodeForPlaceholder((MsgPlaceholderNode)child, msgNode, codeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralNode) {
                this.genGoogMsgCodeForPluralNode((MsgPluralNode)child, msgNode, codeGenInfo);
                continue;
            }
            if (child instanceof MsgSelectNode) {
                this.genGoogMsgCodeForSelectNode((MsgSelectNode)child, msgNode, codeGenInfo);
                continue;
            }
            String nodeStringForErrorMsg = child instanceof SoyNode.CommandNode ? "Tag " + child.toSourceString() : "Node " + child;
            throw new AssertionError((Object)(nodeStringForErrorMsg + " is not allowed to be a direct child of a 'msg' tag. At :" + child.getSourceLocation()));
        }
    }

    private void genGoogMsgCodeForPluralNode(MsgPluralNode pluralNode, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        codeGenInfo.pluralsAndSelects.put(CodeChunk.stringLiteral(msgNode.getPluralVarName(pluralNode)), this.translateExpr(pluralNode.getExpr()));
        for (CaseOrDefaultNode child : pluralNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, msgNode, codeGenInfo);
        }
    }

    private void genGoogMsgCodeForSelectNode(MsgSelectNode selectNode, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        codeGenInfo.pluralsAndSelects.put(CodeChunk.stringLiteral(msgNode.getSelectVarName(selectNode)), this.translateExpr(selectNode.getExpr()));
        for (CaseOrDefaultNode child : selectNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, msgNode, codeGenInfo);
        }
    }

    private CodeChunk.WithValue translateExpr(ExprNode expr) {
        return (CodeChunk.WithValue)new TranslateExprNodeVisitor(this.jsSrcOptions, this.translationContext, this.errorReporter).exec(expr);
    }

    private void genGoogMsgCodeForPlaceholder(MsgPlaceholderNode node, MsgNode msgNode, GoogMsgPlaceholderCodeGenInfo codeGenInfo) {
        String placeholderName = msgNode.getPlaceholder(node).name();
        String googMsgPlaceholderName = codeGenInfo.isPlrselMsg ? placeholderName : GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
        codeGenInfo.placeholders.put(CodeChunk.stringLiteral(googMsgPlaceholderName), this.genGoogMsgPlaceholder(node));
    }

    private static String genGoogMsgPlaceholderName(String placeholderName) {
        Matcher suffixMatcher = UNDERSCORE_NUMBER_SUFFIX.matcher(placeholderName);
        if (suffixMatcher.find()) {
            String base = placeholderName.substring(0, suffixMatcher.start());
            String suffix = suffixMatcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, base) + suffix;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, placeholderName);
    }

    protected CodeChunk.WithValue genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
        ArrayList<CodeChunk.WithValue> contentChunks = new ArrayList<CodeChunk.WithValue>();
        for (SoyNode.StandaloneNode contentNode : msgPhNode.getChildren()) {
            if (contentNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(contentNode)).booleanValue()) {
                this.visit(contentNode);
                contentChunks.add(CodeChunk.id("htmlTag" + contentNode.getId()));
                continue;
            }
            if (contentNode instanceof CallNode) {
                CallNode callNode = (CallNode)contentNode;
                for (CallParamNode grandchild : callNode.getChildren()) {
                    if (!(grandchild instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(grandchild)).booleanValue()) continue;
                    this.visit(grandchild);
                }
                CodeChunk.WithValue call = this.genCallCodeUtils.gen(callNode, this.templateAliases, this.translationContext, this.errorReporter);
                contentChunks.add(call);
                continue;
            }
            List<CodeChunk.WithValue> chunks = this.genJsExprsVisitor.exec(contentNode);
            contentChunks.add(CodeChunkUtils.concatChunks(chunks));
        }
        return CodeChunkUtils.concatChunks(contentChunks);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.master.getJsCodeBuilder().pushOutputVar("htmlTag" + node.getId());
        this.visitChildren(node);
        this.master.getJsCodeBuilder().popOutputVar();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.master.visitForUseByAssistants(node);
    }

    private static final class MapLiteralBuilder {
        final ImmutableList.Builder<CodeChunk.WithValue> keys = ImmutableList.builder();
        final ImmutableList.Builder<CodeChunk.WithValue> values = ImmutableList.builder();
        final Set<CodeChunk.WithValue> knownKeys = new HashSet<CodeChunk.WithValue>();

        private MapLiteralBuilder() {
        }

        MapLiteralBuilder put(CodeChunk.WithValue key, CodeChunk.WithValue value) {
            if (this.knownKeys.add(key)) {
                this.keys.add((Object)key);
                this.values.add((Object)value);
            }
            return this;
        }

        boolean isEmpty() {
            return this.knownKeys.isEmpty();
        }

        MapLiteralBuilder putAll(MapLiteralBuilder other) {
            ImmutableList keys = other.keys.build();
            ImmutableList values = other.values.build();
            Preconditions.checkState((keys.size() == values.size() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)Sets.intersection(this.knownKeys, other.knownKeys).isEmpty());
            for (int i = 0; i < keys.size(); ++i) {
                this.put((CodeChunk.WithValue)keys.get(i), (CodeChunk.WithValue)values.get(i));
            }
            return this;
        }

        CodeChunk.WithValue build() {
            return CodeChunk.mapLiteral((Iterable<? extends CodeChunk.WithValue>)this.keys.build(), (Iterable<? extends CodeChunk.WithValue>)this.values.build());
        }
    }

    private static final class GoogMsgPlaceholderCodeGenInfo {
        final boolean isPlrselMsg;
        final MapLiteralBuilder placeholders = new MapLiteralBuilder();
        final MapLiteralBuilder pluralsAndSelects = new MapLiteralBuilder();

        GoogMsgPlaceholderCodeGenInfo(boolean isPlrselMsg) {
            this.isPlrselMsg = isPlrselMsg;
        }
    }

    private static final class GoogMsgCodeGenInfo {
        final CodeChunk.WithValue googMsgVar;
        @Nullable
        final CodeChunk.WithValue placeholders;
        final String googMsgVarName;

        GoogMsgCodeGenInfo(CodeChunk.WithValue googMsgVar, String varName, CodeChunk.WithValue placeholders) {
            this.googMsgVar = googMsgVar;
            this.googMsgVarName = varName;
            this.placeholders = placeholders;
        }
    }
}

