/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.ConditionalExpressionBuilder;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.List;

public class GenJsExprsVisitor
extends AbstractSoyNodeVisitor<List<CodeChunk.WithValue>> {
    private static final SoyErrorKind UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE = SoyErrorKind.of("Unknown SoyJsSrcPrintDirective ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyJsSrcOptions options;
    private final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private final TranslationContext translationContext;
    private final ErrorReporter errorReporter;
    protected List<CodeChunk.WithValue> chunks;
    private final TemplateAliases templateAliases;

    protected GenJsExprsVisitor(SoyJsSrcOptions options, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitorFactory genJsExprsVisitorFactory, TranslationContext translationContext, ErrorReporter errorReporter, TemplateAliases templateAliases) {
        this.options = options;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
        this.templateAliases = templateAliases;
    }

    @Override
    public List<CodeChunk.WithValue> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(node)));
        this.chunks = new ArrayList<CodeChunk.WithValue>();
        this.visit(node);
        return this.chunks;
    }

    public List<CodeChunk.WithValue> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(node));
        this.chunks = new ArrayList<CodeChunk.WithValue>();
        this.visitChildren(node);
        return this.chunks;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        this.chunks.add(CodeChunk.stringLiteral(node.getRawText()));
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        CodeChunk.WithValue expr = this.translateExpr(node.getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyPrintDirective directive = directiveNode.getPrintDirective();
            if (!(directive instanceof SoyJsSrcPrintDirective)) {
                this.errorReporter.report(node.getSourceLocation(), UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE, directiveNode.getName());
                return;
            }
            List<ExprRootNode> argNodes = directiveNode.getArgs();
            ArrayList<CodeChunk.WithValue> argChunks = new ArrayList<CodeChunk.WithValue>(argNodes.size());
            for (ExprRootNode argNode : argNodes) {
                argChunks.add(this.translateExpr(argNode));
            }
            expr = SoyJsPluginUtils.applyDirective(this.translationContext.codeGenerator(), expr, (SoyJsSrcPrintDirective)directive, argChunks);
        }
        this.chunks.add(expr);
    }

    private CodeChunk.WithValue translateExpr(ExprRootNode argNode) {
        return (CodeChunk.WithValue)new TranslateExprNodeVisitor(this.options, this.translationContext, this.errorReporter).exec(argNode);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenJsExprsVisitor genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.translationContext, this.templateAliases, this.errorReporter);
        CodeChunk.Generator generator = this.translationContext.codeGenerator();
        ArrayList<CodeChunk.WithValue> ifs = new ArrayList<CodeChunk.WithValue>();
        ArrayList<CodeChunk.WithValue> thens = new ArrayList<CodeChunk.WithValue>();
        CodeChunk.WithValue trailingElse = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode ifCond = (IfCondNode)child;
                ifs.add(this.translateExpr(ifCond.getExpr()));
                thens.add(CodeChunkUtils.concatChunks(genJsExprsVisitor.exec(ifCond)));
                continue;
            }
            if (child instanceof IfElseNode) {
                trailingElse = CodeChunkUtils.concatChunks(genJsExprsVisitor.exec(child));
                continue;
            }
            throw new AssertionError();
        }
        Preconditions.checkState((ifs.size() == thens.size() ? 1 : 0) != 0);
        ConditionalExpressionBuilder builder = CodeChunk.ifExpression((CodeChunk.WithValue)ifs.get(0), (CodeChunk.WithValue)thens.get(0));
        for (int i = 1; i < ifs.size(); ++i) {
            builder.elseif_((CodeChunk.WithValue)ifs.get(i), (CodeChunk.WithValue)thens.get(i));
        }
        CodeChunk.WithValue ifChunk = trailingElse != null ? builder.else_(trailingElse).build(generator) : builder.else_(CodeChunk.LITERAL_EMPTY_STRING).build(generator);
        this.chunks.add(ifChunk);
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        CodeChunk.WithValue call = this.genCallCodeUtils.gen(node, this.templateAliases, this.translationContext, this.errorReporter);
        this.chunks.add(call);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static class GenJsExprsVisitorFactory {
        protected final SoyJsSrcOptions options;
        protected final Supplier<GenCallCodeUtils> genCallCodeUtils;
        protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;

        protected GenJsExprsVisitorFactory(SoyJsSrcOptions options, Supplier<GenCallCodeUtils> genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor) {
            this.options = options;
            this.genCallCodeUtils = genCallCodeUtils;
            this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        }

        public GenJsExprsVisitor create(TranslationContext translationContext, TemplateAliases templateAliases, ErrorReporter errorReporter) {
            return new GenJsExprsVisitor(this.options, (GenCallCodeUtils)this.genCallCodeUtils.get(), this.isComputableAsJsExprsVisitor, this, translationContext, errorReporter, templateAliases);
        }
    }
}

