/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jssrc.internal.VeLogFunction;
import com.google.template.soy.jssrc.internal.VeLogJsSrcLoggingFunction;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.VeLogNode;

final class VeLogInstrumentationVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final TemplateRegistry templateRegistry;
    private IdGenerator nodeIdGen;
    private int counter;

    VeLogInstrumentationVisitor(TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.nodeIdGen = node.getNodeIdGenerator();
        this.visitChildren(node);
        new DesugarHtmlNodesPass().run(node, this.templateRegistry);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        super.visitSoyFileNode(node);
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        HtmlOpenTagNode tag = (HtmlOpenTagNode)node.getChild(0);
        SourceLocation insertionLocation = tag.getSourceLocation().getEndPoint().offset(0, tag.isSelfClosing() ? -2 : -1).asLocation(tag.getSourceLocation().getFilePath());
        FunctionNode funcNode = new FunctionNode(VeLogFunction.INSTANCE, insertionLocation);
        funcNode.addChild(new IntegerNode(node.getLoggingId(), insertionLocation));
        funcNode.addChild(node.getConfigExpression() == null ? new NullNode(insertionLocation) : node.getConfigExpression().copy(new CopyState()));
        if (node.getLogonlyExpression() != null) {
            funcNode.addChild(node.getLogonlyExpression().copy(new CopyState()));
        }
        PrintNode attributeNode = new PrintNode(this.nodeIdGen.genId(), insertionLocation, true, funcNode, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
        tag.addChild(attributeNode);
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.counter = 0;
        this.visitChildrenAllowingConcurrentModification(node);
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        int oldCounter = this.counter;
        this.counter = 0;
        this.visitChildrenAllowingConcurrentModification(node);
        this.counter = oldCounter;
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return;
        }
        SourceLocation insertionLocation = node.getSourceLocation();
        for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(node, FunctionNode.class)) {
            if (!(function.getSoyFunction() instanceof LoggingFunction)) continue;
            FunctionNode funcNode = new FunctionNode(VeLogJsSrcLoggingFunction.INSTANCE, insertionLocation);
            funcNode.addChild(new StringNode(function.getFunctionName(), QuoteStyle.SINGLE, insertionLocation));
            funcNode.addChild(new ListLiteralNode(function.getChildren(), insertionLocation));
            SoyNode.StandaloneNode attributeName = (SoyNode.StandaloneNode)node.getChild(0);
            if (attributeName instanceof RawTextNode) {
                funcNode.addChild(new StringNode(((RawTextNode)attributeName).getRawText(), QuoteStyle.SINGLE, insertionLocation));
            } else {
                String varName = "soy_logging_function_attribute_" + this.counter;
                LetContentNode letNode = LetContentNode.forVariable(this.nodeIdGen.genId(), attributeName.getSourceLocation(), varName, null);
                node.replaceChild(attributeName, new PrintNode(this.nodeIdGen.genId(), insertionLocation, true, new VarRefNode(varName, insertionLocation, false, letNode.getVar()), (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding()));
                letNode.addChild(attributeName);
                node.getParent().addChild(node.getParent().getChildIndex(node), letNode);
                funcNode.addChild(new VarRefNode(varName, insertionLocation, false, letNode.getVar()));
            }
            funcNode.addChild(new IntegerNode(this.counter++, insertionLocation));
            PrintNode loggingFunctionAttribute = new PrintNode(this.nodeIdGen.genId(), insertionLocation, true, funcNode, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            int appendIndex = node.getParent().getChildIndex(node) + 1;
            node.getParent().addChild(appendIndex, loggingFunctionAttribute);
            HtmlAttributeValueNode placeHolder = new HtmlAttributeValueNode(this.nodeIdGen.genId(), insertionLocation, HtmlAttributeValueNode.Quotes.DOUBLE);
            placeHolder.addChild(new RawTextNode(this.nodeIdGen.genId(), ((LoggingFunction)function.getSoyFunction()).getPlaceholder(), insertionLocation));
            node.replaceChild(node.getChild(1), placeHolder);
            break;
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

