/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import java.util.LinkedHashSet;
import java.util.Set;

final class TemplateCallGraph {
    private final ListMultimap<TemplateNode, TemplateNode> callers = MultimapBuilder.linkedHashKeys().arrayListValues().build();

    TemplateCallGraph(ImmutableListMultimap<String, TemplateNode> templatesByName) {
        for (TemplateNode tn : templatesByName.values()) {
            for (CallBasicNode call : SoyTreeUtils.getAllNodesOfType(tn, CallBasicNode.class)) {
                ImmutableList callees = templatesByName.get((Object)call.getCalleeName());
                if (callees == null) continue;
                for (TemplateNode callee : callees) {
                    this.callers.put((Object)callee, (Object)tn);
                }
            }
        }
    }

    Set<TemplateNode> callersOf(Iterable<TemplateNode> templates) {
        LinkedHashSet callerSet = Sets.newLinkedHashSet();
        for (TemplateNode templateNode : templates) {
            this.addTransitively(templateNode, callerSet);
        }
        return callerSet;
    }

    private void addTransitively(TemplateNode callee, Set<? super TemplateNode> out) {
        for (TemplateNode caller : this.callers.get((Object)callee)) {
            if (!out.add(caller)) continue;
            this.addTransitively(caller, out);
        }
    }
}

