/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class InsertMsgPlaceholderNodesPass
extends CompilerFilePass {
    private static final SoyErrorKind INVALID_PLACEHOLDER = SoyErrorKind.of("''{0}'' attributes are only valid inside '''{'msg...'' tags.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_COMMAND_IN_MSG = SoyErrorKind.of("Unexpected soy command in '''{'msg ...'}''' block. Only message placeholder commands ('{'print, '{'call and html tags) are allowed to be direct children of messages.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    InsertMsgPlaceholderNodesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new Visitor(nodeIdGen, this.errorReporter).exec(file);
    }

    private static final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        final List<SoyNode> nodesToReplace = new ArrayList<SoyNode>();
        final IdGenerator nodeIdGen;
        final ErrorReporter errorReporter;
        boolean inMsgNode = false;

        Visitor(IdGenerator nodeIdGen, ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitMsgNode(MsgNode msgNode) {
            msgNode.ensureSubstUnitInfoHasNotBeenAccessed();
            this.inMsgNode = true;
            this.visitChildren(msgNode);
            this.inMsgNode = false;
            for (SoyNode node : this.nodesToReplace) {
                ParentNode parent = node.getParent();
                if (!(parent instanceof SoyNode.MsgBlockNode)) {
                    throw new AssertionError((Object)("Expected parent: " + parent + " of " + node + " to be a msgblocknode @ " + parent.getSourceLocation()));
                }
                int index = parent.getChildIndex(node);
                parent.removeChild(index);
                SoyNode.MsgPlaceholderInitialNode newNode = node instanceof HtmlTagNode ? MsgHtmlTagNode.fromNode(this.nodeIdGen.genId(), (HtmlTagNode)node, this.errorReporter) : (SoyNode.MsgPlaceholderInitialNode)node;
                ((SoyNode.MsgBlockNode)parent).addChild(index, new MsgPlaceholderNode(this.nodeIdGen.genId(), newNode));
            }
            this.nodesToReplace.clear();
        }

        @Override
        protected void visitMsgPluralNode(MsgPluralNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgSelectNode(MsgSelectNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.maybeAddAndVisitChildren(node);
            this.checkPlaceholderNode(node);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            this.maybeAddAndVisitChildren(node);
            this.checkPlaceholderNode(node);
        }

        @Override
        protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
            throw new AssertionError((Object)("Unexpected node: " + node.toSourceString()));
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.maybeAddAndVisitChildren(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.maybeAddAndVisitChildren(node);
            if (!this.inMsgNode) {
                for (String name : Arrays.asList("phname", "phex")) {
                    HtmlAttributeNode attr = node.getDirectAttributeNamed(name);
                    if (attr == null) continue;
                    this.errorReporter.report(attr.getSourceLocation(), INVALID_PLACEHOLDER, name);
                }
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode node) {
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
            throw new AssertionError((Object)("Unexpected node: " + node.toSourceString()));
        }

        private void maybeAddAndVisitChildren(SoyNode node) {
            if (this.inMsgNode) {
                this.nodesToReplace.add(node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                boolean oldInMsgNode = this.inMsgNode;
                this.inMsgNode = false;
                this.visitChildren((SoyNode.ParentSoyNode)node);
                this.inMsgNode = oldInMsgNode;
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (this.inMsgNode && !(node instanceof SoyNode.MsgBlockNode)) {
                this.errorReporter.report(node.getSourceLocation(), UNEXPECTED_COMMAND_IN_MSG, new Object[0]);
                return;
            }
            if (node instanceof SoyNode.MsgPlaceholderInitialNode) {
                this.checkPlaceholderNode((SoyNode.MsgPlaceholderInitialNode)node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private void checkPlaceholderNode(SoyNode.MsgPlaceholderInitialNode node) {
            if (this.inMsgNode) {
                return;
            }
            if (node.getUserSuppliedPhName() != null) {
                this.errorReporter.report(node.getSourceLocation(), INVALID_PLACEHOLDER, "phname");
            } else if (node.getUserSuppliedPhExample() != null) {
                this.errorReporter.report(node.getSourceLocation(), INVALID_PLACEHOLDER, "phex");
            }
        }
    }
}

