/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CheckNonEmptyMsgNodesPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.InsertMsgPlaceholderNodesPass;
import com.google.template.soy.passes.RewriteGenderMsgsVisitor;
import com.google.template.soy.passes.RewriteRemaindersPass;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class MsgsPass
extends CompilerFilePass {
    private final ErrorReporter errorReporter;
    private final InsertMsgPlaceholderNodesPass insertMsgPlaceholderNodesPass;
    private final RewriteRemaindersPass rewriteRemainders;
    private final CheckNonEmptyMsgNodesPass checkNonEmptyPass;

    MsgsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.rewriteRemainders = new RewriteRemaindersPass(errorReporter);
        this.insertMsgPlaceholderNodesPass = new InsertMsgPlaceholderNodesPass(errorReporter);
        this.checkNonEmptyPass = new CheckNonEmptyMsgNodesPass(errorReporter);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        ImmutableList<MsgNode> allMsgs = SoyTreeUtils.getAllNodesOfType(file, MsgNode.class);
        for (MsgNode msg : allMsgs) {
            msg.ensureSubstUnitInfoHasNotBeenAccessed();
        }
        this.insertMsgPlaceholderNodesPass.run(file, nodeIdGen);
        new RewriteGenderMsgsVisitor(nodeIdGen, this.errorReporter).exec(file);
        this.rewriteRemainders.run(file, nodeIdGen);
        for (MsgNode msg : allMsgs) {
            msg.calculateSubstitutionInfo(this.errorReporter);
        }
        this.checkNonEmptyPass.run(file, nodeIdGen);
    }
}

