/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class RewriteRemaindersPass
extends CompilerFilePass {
    private static final SoyErrorKind REMAINDER_OUTSIDE_PLURAL = SoyErrorKind.of("Special function ''remainder'' is for use in plural messages only.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REMAINDER_PLURAL_EXPR_MISMATCH = SoyErrorKind.of("Argument to ''remainder'' must be the same as the ''plural'' variable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REMAINDER_UNNECESSARY_AT_OFFSET_0 = SoyErrorKind.of("''remainder'' is unnecessary since offset=0.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REMAINDER_WITH_PHNAME = SoyErrorKind.of("Special function ''remainder'' cannot be used with ''phname''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public RewriteRemaindersPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new Visitor().exec(file);
    }

    private static void removeBadRemainder(FunctionNode functionNode) {
        functionNode.getParent().replaceChild(functionNode, new IntegerNode(0L, functionNode.getSourceLocation()));
    }

    private final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        private MsgPluralNode currPluralNode;
        private PrintNode currPrintNode;

        private Visitor() {
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.currPrintNode = node;
            super.visitPrintNode(node);
            this.currPrintNode = null;
        }

        @Override
        protected void visitMsgPluralNode(MsgPluralNode node) {
            MsgPluralNode prev = this.currPluralNode;
            this.currPluralNode = node;
            this.visitChildren(node);
            this.currPluralNode = prev;
        }

        private void maybeRewriteRemainder(FunctionNode functionNode) {
            if (functionNode.getSoyFunction() != BuiltinFunction.REMAINDER) {
                return;
            }
            if (this.currPluralNode == null) {
                RewriteRemaindersPass.this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_OUTSIDE_PLURAL, new Object[0]);
                RewriteRemaindersPass.removeBadRemainder(functionNode);
                return;
            }
            if (functionNode.numChildren() != 1) {
                RewriteRemaindersPass.removeBadRemainder(functionNode);
                return;
            }
            if (!ExprEquivalence.get().equivalent(functionNode.getChild(0), this.currPluralNode.getExpr().getRoot())) {
                RewriteRemaindersPass.this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_PLURAL_EXPR_MISMATCH, new Object[0]);
                RewriteRemaindersPass.removeBadRemainder(functionNode);
                return;
            }
            if (this.currPluralNode.getOffset() == 0) {
                RewriteRemaindersPass.this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_UNNECESSARY_AT_OFFSET_0, new Object[0]);
                RewriteRemaindersPass.removeBadRemainder(functionNode);
                return;
            }
            if (this.currPrintNode != null && this.currPrintNode.getExpr() == functionNode.getParent() && this.currPrintNode.getUserSuppliedPhName() != null) {
                RewriteRemaindersPass.this.errorReporter.report(functionNode.getSourceLocation(), REMAINDER_WITH_PHNAME, new Object[0]);
                RewriteRemaindersPass.removeBadRemainder(functionNode);
                return;
            }
            ExprNode plural = this.currPluralNode.getExpr().getRoot().copy(new CopyState());
            IntegerNode offset = new IntegerNode(this.currPluralNode.getOffset(), functionNode.getSourceLocation());
            ExprNode.OperatorNode remainder = Operator.MINUS.createNode(plural.getSourceLocation().extend(offset.getSourceLocation()), plural, offset);
            functionNode.getParent().replaceChild(functionNode, remainder);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            if (node instanceof SoyNode.ExprHolderNode) {
                for (ExprNode expr : ((SoyNode.ExprHolderNode)node).getExprList()) {
                    for (FunctionNode functionNode : SoyTreeUtils.getAllNodesOfType(expr, FunctionNode.class)) {
                        this.maybeRewriteRemainder(functionNode);
                    }
                }
            }
        }
    }
}

