/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;

final class ValidateAliasesPass
extends CompilerFilePass {
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL = SoyErrorKind.of("Alias ''{0}'' conflicts with a global of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX = SoyErrorKind.of("Alias ''{0}'' conflicts with namespace for global ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_TYPE_NAME = SoyErrorKind.of("Alias ''{0}'' conflicts with a type of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_TYPE_PREFIX = SoyErrorKind.of("Alias ''{0}'' conflicts with namespace for type ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyTypeRegistry registry;
    private final ErrorReporter errorReporter;
    private final SoyGeneralOptions options;

    ValidateAliasesPass(SoyTypeRegistry registry, ErrorReporter errorReporter, SoyGeneralOptions options) {
        this.registry = registry;
        this.errorReporter = errorReporter;
        this.options = options;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (file.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        for (AliasDeclaration alias : file.getAliasDeclarations()) {
            String conflictingNamespacedType;
            SoyType type;
            if (this.options.getCompileTimeGlobals().containsKey((Object)alias.alias().identifier())) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_GLOBAL, alias.alias());
            }
            if ((type = this.registry.getType(alias.alias().identifier())) != null && type.getKind() != SoyType.Kind.UNKNOWN) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_TYPE_NAME, alias.alias());
            }
            if ((conflictingNamespacedType = this.registry.findTypeWithMatchingNamespace(alias.alias().identifier())) != null) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_TYPE_PREFIX, alias.alias(), conflictingNamespacedType);
            }
            String prefix = alias.alias().identifier() + ".";
            for (String global : this.options.getCompileTimeGlobals().keySet()) {
                if (!global.startsWith(prefix)) continue;
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX, alias.alias(), global);
            }
        }
    }
}

