/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class AbstractStreamingHtmlEscaper
extends LoggingAdvisingAppendable {
    protected final LoggingAdvisingAppendable delegate;
    protected Appendable activeAppendable;

    protected AbstractStreamingHtmlEscaper(LoggingAdvisingAppendable delegate, Appendable escapingAppendable) {
        this.delegate = (LoggingAdvisingAppendable)Preconditions.checkNotNull((Object)delegate);
        this.activeAppendable = (Appendable)Preconditions.checkNotNull((Object)escapingAppendable);
    }

    @Override
    public final LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
        this.activeAppendable.append(csq);
        return this;
    }

    @Override
    public final LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
        this.activeAppendable.append(csq, start, end);
        return this;
    }

    @Override
    public final LoggingAdvisingAppendable append(char c) throws IOException {
        this.activeAppendable.append(c);
        return this;
    }

    @Override
    public final boolean softLimitReached() {
        return this.delegate.softLimitReached();
    }

    @Override
    protected abstract void notifyContentKind(SanitizedContent.ContentKind var1) throws IOException;

    @Override
    protected void notifyContentDirectionality(@Nullable Dir contentDir) throws IOException {
        this.delegate.setSanitizedContentDirectionality(contentDir);
    }

    protected final boolean isInHtml() {
        return this.getSantizedContentKind() == SanitizedContent.ContentKind.HTML;
    }
}

