/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public final class GuiceSimpleScope
implements Scope {
    private static final Object NULL_SENTINEL = new Object();
    private static final Provider<Object> UNSCOPED_PROVIDER = new Provider<Object>(){

        public Object get() {
            throw new IllegalStateException("If you got here then it means that your code asked for scoped object which should have been explicitly seeded in this scope by calling GuiceSimpleScope.seed(), but was not.");
        }
    };
    private final ThreadLocal<ArrayDeque<HashMap<Key<?>, Object>>> scopedValuesTl = new ThreadLocal();

    public static <T> Provider<T> getUnscopedProvider() {
        return UNSCOPED_PROVIDER;
    }

    @CheckReturnValue
    public InScope enter() {
        ArrayDeque<HashMap<Object, Object>> stack = this.scopedValuesTl.get();
        if (stack == null) {
            stack = new ArrayDeque();
            this.scopedValuesTl.set(stack);
        }
        stack.push(new HashMap());
        return new InScope(stack);
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscopedProvider) {
        return new Provider<T>(){

            public T get() {
                ArrayDeque arrayDeque = (ArrayDeque)GuiceSimpleScope.this.scopedValuesTl.get();
                if (arrayDeque == null || arrayDeque.isEmpty()) {
                    throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
                }
                Map scopedValues = (Map)arrayDeque.peek();
                Object value = scopedValues.get(key);
                if (value == null) {
                    value = unscopedProvider.get();
                    scopedValues.put(key, value == null ? NULL_SENTINEL : value);
                }
                Object typedValue = value == NULL_SENTINEL ? null : (Object)value;
                return typedValue;
            }
        };
    }

    public final class InScope
    implements AutoCloseable {
        private boolean isClosed;
        private final Thread openThread = Thread.currentThread();
        private final ArrayDeque<HashMap<Key<?>, Object>> deque;

        InScope(ArrayDeque<HashMap<Key<?>, Object>> deque) {
            this.deque = deque;
        }

        public <T> void seed(Key<T> key, T value) {
            this.checkOpenAndOnCorrectThread();
            HashMap<Key<?>, Object> scopedObjects = this.deque.peek();
            Object prev = scopedObjects.put(key, value == null ? NULL_SENTINEL : value);
            if (prev != null) {
                throw new IllegalStateException(String.format("A value for the key %s was already seeded in this scope. Old value: %s New value: %s", key, prev, value));
            }
        }

        @Override
        public void close() {
            this.checkOpenAndOnCorrectThread();
            this.isClosed = true;
            this.deque.pop();
        }

        private void checkOpenAndOnCorrectThread() {
            if (this.isClosed) {
                throw new IllegalStateException("called close() more than once!");
            }
            if (Thread.currentThread() != this.openThread) {
                throw new IllegalStateException("cannot move the scope to another thread");
            }
        }
    }
}

