/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import com.google.common.primitives.Chars;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.shared.internal.AbstractStreamingHtmlEscaper;
import com.google.template.soy.shared.internal.EscapingConventions;
import com.google.template.soy.shared.internal.StreamingEscaper;
import com.google.template.soy.shared.internal.TagWhitelist;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Sanitizers {
    private static final Logger logger = Logger.getLogger(Sanitizers.class.getName());
    private static final ImmutableSet<String> HTML5_VOID_ELEMENTS = ImmutableSet.of((Object)"area", (Object)"base", (Object)"br", (Object)"col", (Object)"command", (Object)"embed", (Object[])new String[]{"hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"});
    public static final Pattern HTML_ATTRIBUTE_PATTERN;
    private static final String SAFECHARS_URLENCODER = "-_.*";
    private static final Escaper URI_ESCAPER_NO_PLUS;

    private Sanitizers() {
    }

    public static String escapeHtml(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.HTML)) {
            return value.coerceToString();
        }
        return Sanitizers.escapeHtml(value.coerceToString());
    }

    public static String escapeHtml(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static SanitizedContent cleanHtml(SoyValue value) {
        return Sanitizers.cleanHtml(value, (Collection<? extends TagWhitelist.OptionalSafeTag>)ImmutableSet.of());
    }

    public static SanitizedContent cleanHtml(SoyValue value, Collection<? extends TagWhitelist.OptionalSafeTag> optionalSafeTags) {
        value = Sanitizers.normalizeNull(value);
        Dir valueDir = null;
        if (value instanceof SanitizedContent) {
            SanitizedContent sanitizedContent = (SanitizedContent)value;
            if (sanitizedContent.getContentKind() == SanitizedContent.ContentKind.HTML) {
                return (SanitizedContent)value;
            }
            valueDir = sanitizedContent.getContentDirection();
        }
        return Sanitizers.cleanHtml(value.coerceToString(), valueDir, optionalSafeTags);
    }

    public static LoggingAdvisingAppendable cleanHtmlStreaming(LoggingAdvisingAppendable delegate, Collection<? extends TagWhitelist.OptionalSafeTag> optionalSafeTags) {
        return new CleanHtmlAppendable(delegate, optionalSafeTags);
    }

    public static SanitizedContent cleanHtml(String value) {
        return Sanitizers.cleanHtml(value, (Collection<? extends TagWhitelist.OptionalSafeTag>)ImmutableSet.of());
    }

    public static SanitizedContent cleanHtml(String value, Collection<? extends TagWhitelist.OptionalSafeTag> optionalSafeTags) {
        return Sanitizers.cleanHtml(value, null, optionalSafeTags);
    }

    public static SanitizedContent cleanHtml(String value, Dir contentDir, Collection<? extends TagWhitelist.OptionalSafeTag> optionalSafeTags) {
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(Sanitizers.stripHtmlTags(value, TagWhitelist.FORMATTING.withOptionalSafeTags(optionalSafeTags), true), SanitizedContent.ContentKind.HTML, contentDir);
    }

    public static String escapeHtmlRcdata(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.normalizeHtml(value.coerceToString());
        }
        return Sanitizers.escapeHtml(value.coerceToString());
    }

    public static LoggingAdvisingAppendable escapeHtmlRcdataStreaming(LoggingAdvisingAppendable delegate) {
        return new StreamingHtmlRcDataEscaper(delegate);
    }

    public static String normalizeHtml(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.normalizeHtml(value.coerceToString());
    }

    public static LoggingAdvisingAppendable normalizeHtmlStreaming(LoggingAdvisingAppendable appendable) {
        return StreamingEscaper.create(appendable, EscapingConventions.NormalizeHtml.INSTANCE);
    }

    public static String normalizeHtml(String value) {
        return EscapingConventions.NormalizeHtml.INSTANCE.escape(value);
    }

    public static String normalizeHtmlNospace(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.normalizeHtmlNospace(value.coerceToString());
    }

    public static String normalizeHtmlNospace(String value) {
        return EscapingConventions.NormalizeHtmlNospace.INSTANCE.escape(value);
    }

    public static String escapeHtmlAttribute(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(value.coerceToString(), null, true);
        }
        return Sanitizers.escapeHtmlAttribute(value.coerceToString());
    }

    public static String escapeHtmlAttribute(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String escapeHtmlAttributeNospace(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(value.coerceToString(), null, false);
        }
        return Sanitizers.escapeHtmlAttributeNospace(value.coerceToString());
    }

    public static String escapeHtmlAttributeNospace(String value) {
        return EscapingConventions.EscapeHtmlNospace.INSTANCE.escape(value);
    }

    public static String escapeJsString(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.escapeJsString(value.coerceToString());
    }

    public static LoggingAdvisingAppendable escapeJsStringStreaming(LoggingAdvisingAppendable appendable) {
        return StreamingEscaper.create(appendable, EscapingConventions.EscapeJsString.INSTANCE);
    }

    public static String escapeJsString(String value) {
        return EscapingConventions.EscapeJsString.INSTANCE.escape(value);
    }

    public static String escapeJsValue(SoyValue value) {
        if (NullData.INSTANCE == value || value == null) {
            return " null ";
        }
        if (value instanceof NumberData) {
            return " " + value.numberValue() + " ";
        }
        if (value instanceof BooleanData) {
            return " " + value.booleanValue() + " ";
        }
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.JS)) {
            String jsCode = value.coerceToString();
            return jsCode;
        }
        return Sanitizers.escapeJsValue(value.coerceToString());
    }

    public static String escapeJsValue(String value) {
        return value != null ? "'" + Sanitizers.escapeJsString(value) + "'" : " null ";
    }

    public static String escapeJsRegex(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.escapeJsRegex(value.coerceToString());
    }

    public static LoggingAdvisingAppendable escapeJsRegexStreaming(LoggingAdvisingAppendable delegate) {
        return StreamingEscaper.create(delegate, EscapingConventions.EscapeJsRegex.INSTANCE);
    }

    public static String escapeJsRegex(String value) {
        return EscapingConventions.EscapeJsRegex.INSTANCE.escape(value);
    }

    public static String escapeCssString(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.escapeCssString(value.coerceToString());
    }

    public static LoggingAdvisingAppendable escapeCssStringStreaming(LoggingAdvisingAppendable delegate) {
        return StreamingEscaper.create(delegate, EscapingConventions.EscapeCssString.INSTANCE);
    }

    public static String escapeCssString(String value) {
        return EscapingConventions.EscapeCssString.INSTANCE.escape(value);
    }

    public static String filterCssValue(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.CSS)) {
            return Sanitizers.embedCssIntoHtml(value.coerceToString());
        }
        return NullData.INSTANCE == value ? "" : Sanitizers.filterCssValue(value.coerceToString());
    }

    public static String filterCssValue(String value) {
        if (EscapingConventions.FilterCssValue.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        logger.log(Level.WARNING, "|filterCssValue received bad value ''{0}''", value);
        return EscapingConventions.FilterCssValue.INSTANCE.getInnocuousOutput();
    }

    public static String escapeUri(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.escapeUri(value.coerceToString());
    }

    public static String escapeUri(String value) {
        return Sanitizers.uriEscaper().escape(value);
    }

    public static String normalizeUri(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.normalizeUri(value.coerceToString());
    }

    public static LoggingAdvisingAppendable normalizeUriStreaming(LoggingAdvisingAppendable value) {
        return StreamingEscaper.create(value, EscapingConventions.NormalizeUri.INSTANCE);
    }

    public static String normalizeUri(String value) {
        return EscapingConventions.NormalizeUri.INSTANCE.escape(value);
    }

    public static String filterNormalizeUri(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.URI) || Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI)) {
            return Sanitizers.normalizeUri(value);
        }
        return Sanitizers.filterNormalizeUri(value.coerceToString());
    }

    public static String filterNormalizeUri(String value) {
        if (EscapingConventions.FilterNormalizeUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return EscapingConventions.FilterNormalizeUri.INSTANCE.escape(value);
        }
        logger.log(Level.WARNING, "|filterNormalizeUri received bad value ''{0}''", value);
        return EscapingConventions.FilterNormalizeUri.INSTANCE.getInnocuousOutput();
    }

    public static String filterNormalizeMediaUri(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.URI) || Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI)) {
            return Sanitizers.normalizeUri(value);
        }
        return Sanitizers.filterNormalizeMediaUri(value.coerceToString());
    }

    public static String filterNormalizeMediaUri(String value) {
        if (EscapingConventions.FilterNormalizeMediaUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return EscapingConventions.FilterNormalizeMediaUri.INSTANCE.escape(value);
        }
        logger.log(Level.WARNING, "|filterNormalizeMediaUri received bad value ''{0}''", value);
        return EscapingConventions.FilterNormalizeMediaUri.INSTANCE.getInnocuousOutput();
    }

    public static String filterTrustedResourceUri(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI)) {
            return value.coerceToString();
        }
        logger.log(Level.WARNING, "|filterTrustedResourceUri received bad value ''{0}''", value);
        return "about:invalid#zSoyz";
    }

    public static String filterTrustedResourceUri(String value) {
        return value;
    }

    public static SoyValue blessStringAsTrustedResourceUrlForLegacy(SoyValue value) {
        return value;
    }

    public static SoyValue blessStringAsTrustedResourceUrlForLegacy(String value) {
        return StringData.forValue(value);
    }

    public static LoggingAdvisingAppendable blessStringAsTrustedResourceUrlForLegacyStreaming(LoggingAdvisingAppendable appendable) {
        return appendable;
    }

    public static SanitizedContent filterImageDataUri(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.filterImageDataUri(value.coerceToString());
    }

    public static SanitizedContent filterImageDataUri(String value) {
        if (EscapingConventions.FilterImageDataUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(value, SanitizedContent.ContentKind.URI);
        }
        logger.log(Level.WARNING, "|filterImageDataUri received bad value ''{0}''", value);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(EscapingConventions.FilterImageDataUri.INSTANCE.getInnocuousOutput(), SanitizedContent.ContentKind.URI);
    }

    public static SanitizedContent filterSipUri(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.filterSipUri(value.coerceToString());
    }

    public static SanitizedContent filterSipUri(String value) {
        if (EscapingConventions.FilterSipUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(value, SanitizedContent.ContentKind.URI);
        }
        logger.log(Level.WARNING, "|filterSipUri received bad value ''{0}''", value);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(EscapingConventions.FilterSipUri.INSTANCE.getInnocuousOutput(), SanitizedContent.ContentKind.URI);
    }

    public static SanitizedContent filterTelUri(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.filterTelUri(value.coerceToString());
    }

    public static SanitizedContent filterTelUri(String value) {
        if (EscapingConventions.FilterTelUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(value, SanitizedContent.ContentKind.URI);
        }
        logger.log(Level.WARNING, "|filterTelUri received bad value ''{0}''", value);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(EscapingConventions.FilterTelUri.INSTANCE.getInnocuousOutput(), SanitizedContent.ContentKind.URI);
    }

    public static String filterHtmlAttributes(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.ATTRIBUTES)) {
            String content = value.coerceToString();
            if (content.length() > 0 && Sanitizers.shouldAppendSpace(content.charAt(content.length() - 1))) {
                content = content + ' ';
            }
            return content;
        }
        return Sanitizers.filterHtmlAttributes(value.coerceToString());
    }

    private static boolean shouldAppendSpace(char lastChar) {
        return lastChar != '\"' && lastChar != '\'' && !Character.isWhitespace(lastChar);
    }

    public static String filterHtmlAttributes(String value) {
        if (EscapingConventions.FilterHtmlAttributes.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        logger.log(Level.WARNING, "|filterHtmlAttributes received bad value ''{0}''", value);
        return EscapingConventions.FilterHtmlAttributes.INSTANCE.getInnocuousOutput();
    }

    public static LoggingAdvisingAppendable filterHtmlAttributesStreaming(LoggingAdvisingAppendable appendable) {
        return new FilterHtmlAttributesAppendable(appendable);
    }

    public static String filterHtmlElementName(SoyValue value) {
        value = Sanitizers.normalizeNull(value);
        return Sanitizers.filterHtmlElementName(value.coerceToString());
    }

    public static String filterHtmlElementName(String value) {
        if (EscapingConventions.FilterHtmlElementName.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        logger.log(Level.WARNING, "|filterHtmlElementName received bad value ''{0}''", value);
        return EscapingConventions.FilterHtmlElementName.INSTANCE.getInnocuousOutput();
    }

    public static SoyValue filterNoAutoescape(SoyValue value) {
        if (Sanitizers.isSanitizedContentOfKind(value = Sanitizers.normalizeNull(value), SanitizedContent.ContentKind.TEXT)) {
            logger.log(Level.WARNING, "|noAutoescape received value explicitly tagged as ContentKind.TEXT: ''{0}''", value);
            return StringData.forValue("zSoyz");
        }
        return value;
    }

    public static LoggingAdvisingAppendable filterNoAutoescapeStreaming(LoggingAdvisingAppendable appendable) {
        return new ForwardingLoggingAdvisingAppendable(appendable){

            private boolean isInText() {
                return this.getSantizedContentKind() == SanitizedContent.ContentKind.TEXT;
            }

            @Override
            protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
                if (this.isInText()) {
                    logger.log(Level.WARNING, "|noAutoescape received value explicitly tagged as ContentKind.TEXT");
                    this.delegate.append("zSoyz");
                }
            }

            @Override
            public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
                if (this.isInText()) {
                    return this;
                }
                return super.appendLoggingFunctionInvocation(funCall, escapers);
            }

            @Override
            public LoggingAdvisingAppendable append(char c) throws IOException {
                if (this.isInText()) {
                    return this;
                }
                return super.append(c);
            }

            @Override
            public LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
                if (this.isInText()) {
                    return this;
                }
                return super.append(csq);
            }

            @Override
            public LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
                if (this.isInText()) {
                    return this;
                }
                return super.append(csq, start, end);
            }

            @Override
            public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
                if (this.isInText()) {
                    return this;
                }
                return super.enterLoggableElement(statement);
            }

            @Override
            public LoggingAdvisingAppendable exitLoggableElement() {
                if (this.isInText()) {
                    return this;
                }
                return super.exitLoggableElement();
            }
        };
    }

    private static boolean isSanitizedContentOfKind(SoyValue value, SanitizedContent.ContentKind kind) {
        return value instanceof SanitizedContent && kind == ((SanitizedContent)value).getContentKind();
    }

    @VisibleForTesting
    static String stripHtmlTags(String value, TagWhitelist safeTags, boolean rawSpacesAllowed) {
        EscapingConventions.CrossLanguageStringXform normalizer = rawSpacesAllowed ? EscapingConventions.NormalizeHtml.INSTANCE : EscapingConventions.NormalizeHtmlNospace.INSTANCE;
        Matcher matcher = EscapingConventions.HTML_TAG_CONTENT.matcher(value);
        if (!matcher.find()) {
            return normalizer.escape(value);
        }
        StringBuilder out = new StringBuilder(value.length() - matcher.end() + matcher.start());
        Appendable normalizedOut = normalizer.escape(out);
        List openTags = null;
        int openListTagCount = 0;
        try {
            int pos = 0;
            do {
                String tagName;
                int start;
                if (pos < (start = matcher.start())) {
                    normalizedOut.append(value, pos, start);
                    if (value.charAt(start - 1) == '&') {
                        out.append("amp;");
                    }
                }
                if (safeTags != null && (tagName = matcher.group(1)) != null && safeTags.isSafeTag(tagName = Ascii.toLowerCase((String)tagName))) {
                    boolean isClose;
                    boolean bl = isClose = value.charAt(start + 1) == '/';
                    if (isClose) {
                        int lastIdx;
                        if (openTags != null && (lastIdx = openTags.lastIndexOf(tagName)) >= 0) {
                            List<String> tagsToClose = openTags.subList(lastIdx, openTags.size());
                            for (String tagToClose : tagsToClose) {
                                if (!Sanitizers.isListTag(tagToClose)) continue;
                                --openListTagCount;
                            }
                            Sanitizers.closeTags(tagsToClose, out);
                        }
                    } else if (openListTagCount > 0 || !"li".equals(tagName)) {
                        if (Sanitizers.isListTag(tagName)) {
                            ++openListTagCount;
                        }
                        out.append('<').append(tagName);
                        Matcher attributeMatcher = HTML_ATTRIBUTE_PATTERN.matcher(matcher.group());
                        while (attributeMatcher.find()) {
                            String attributeName = attributeMatcher.group(1);
                            if (Strings.isNullOrEmpty((String)attributeName) || !Ascii.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)"dir")) continue;
                            String dir = attributeMatcher.group(2);
                            if (Strings.isNullOrEmpty((String)dir)) break;
                            if (dir.charAt(0) == '\'' || dir.charAt(0) == '\"') {
                                dir = dir.substring(1, dir.length() - 1);
                            }
                            if (!"ltr".equals(dir = Ascii.toLowerCase((String)dir)) && !"rtl".equals(dir) && !"auto".equals(dir)) break;
                            out.append(" dir=\"").append(dir).append("\"");
                            break;
                        }
                        out.append('>');
                        if (!HTML5_VOID_ELEMENTS.contains((Object)tagName)) {
                            if (openTags == null) {
                                openTags = Lists.newArrayList();
                            }
                            openTags.add(tagName);
                        }
                    }
                }
                pos = matcher.end();
            } while (matcher.find());
            normalizedOut.append(value, pos, value.length());
            if (openTags != null) {
                Sanitizers.closeTags(openTags, out);
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return out.toString();
    }

    private static void closeTags(List<String> openTags, StringBuilder out) {
        int i = openTags.size();
        while (--i >= 0) {
            out.append("</").append(openTags.get(i)).append('>');
        }
        openTags.clear();
    }

    private static boolean isListTag(String tagName) {
        return "ol".equals(tagName) || "ul".equals(tagName);
    }

    private static Escaper uriEscaper() {
        return URI_ESCAPER_NO_PLUS;
    }

    @VisibleForTesting
    static String embedCssIntoHtml(String css) {
        int indexOfEndTag = css.indexOf("</");
        int indexOfEndCData = css.indexOf("]]>");
        if (indexOfEndTag != -1) {
            if (indexOfEndCData != -1) {
                return Sanitizers.embedCssIntoHtmlSlow(css, Math.min(indexOfEndTag, indexOfEndCData), true, true);
            }
            return Sanitizers.embedCssIntoHtmlSlow(css, indexOfEndTag, false, true);
        }
        if (indexOfEndCData != -1) {
            return Sanitizers.embedCssIntoHtmlSlow(css, indexOfEndCData, true, false);
        }
        return css;
    }

    private static String embedCssIntoHtmlSlow(String css, int nextReplacement, boolean searchForEndCData, boolean searchForEndTag) {
        int charsToCopy;
        char[] buf = new char[css.length() + 16];
        int endOfPreviousReplacement = 0;
        int bufIndex = 0;
        do {
            charsToCopy = nextReplacement - endOfPreviousReplacement;
            buf = Chars.ensureCapacity((char[])buf, (int)(bufIndex + charsToCopy + 4), (int)16);
            css.getChars(endOfPreviousReplacement, nextReplacement, buf, bufIndex);
            bufIndex += charsToCopy;
            char c = css.charAt(nextReplacement);
            if (c == ']') {
                buf[bufIndex++] = 93;
                buf[bufIndex++] = 93;
                buf[bufIndex++] = 92;
                buf[bufIndex++] = 62;
                endOfPreviousReplacement = nextReplacement + 3;
            } else if (c == '<') {
                buf[bufIndex++] = 60;
                buf[bufIndex++] = 92;
                buf[bufIndex++] = 47;
                endOfPreviousReplacement = nextReplacement + 2;
            } else {
                throw new AssertionError();
            }
            nextReplacement = -1;
            if (searchForEndTag) {
                int indexOfEndTag = css.indexOf("</", endOfPreviousReplacement);
                if (indexOfEndTag == -1) {
                    searchForEndTag = false;
                } else {
                    nextReplacement = indexOfEndTag;
                }
            }
            if (!searchForEndCData) continue;
            int indexOfEndCData = css.indexOf("]]>", endOfPreviousReplacement);
            if (indexOfEndCData == -1) {
                searchForEndCData = false;
                continue;
            }
            int n = nextReplacement = nextReplacement == -1 ? indexOfEndCData : Math.min(nextReplacement, indexOfEndCData);
        } while (nextReplacement != -1);
        charsToCopy = css.length() - endOfPreviousReplacement;
        buf = Chars.ensureCapacity((char[])buf, (int)(bufIndex + charsToCopy), (int)16);
        css.getChars(endOfPreviousReplacement, css.length(), buf, bufIndex);
        return new String(buf, 0, bufIndex += charsToCopy);
    }

    private static SoyValue normalizeNull(@Nullable SoyValue v) {
        return v == null ? NullData.INSTANCE : v;
    }

    static {
        String attributeName = "[a-zA-Z][a-zA-Z0-9:\\-]*";
        String space = "[\t\n\r ]";
        String doubleQuotedValue = "\"[^\"]*\"";
        String singleQuotedValue = "'[^']*'";
        String attributeValue = Joiner.on((char)'|').join((Object)doubleQuotedValue, (Object)singleQuotedValue, new Object[0]);
        HTML_ATTRIBUTE_PATTERN = Pattern.compile(String.format("(%s)%s*=%s*(%s)", attributeName, space, space, attributeValue));
        URI_ESCAPER_NO_PLUS = new PercentEscaper(SAFECHARS_URLENCODER, false);
    }

    private static final class FilterHtmlAttributesAppendable
    extends LoggingAdvisingAppendable
    implements Closeable {
        private final LoggingAdvisingAppendable delegate;
        private Appendable activeAppendable;
        private char lastChar;

        FilterHtmlAttributesAppendable(LoggingAdvisingAppendable delegate) {
            this.delegate = delegate;
            this.activeAppendable = new StringBuilder();
        }

        @Override
        protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
            if (kind == SanitizedContent.ContentKind.ATTRIBUTES) {
                this.activeAppendable = this.delegate;
            }
        }

        @Override
        public LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
            this.activeAppendable.append(csq);
            if (csq.length() > 0) {
                this.lastChar = csq.charAt(csq.length() - 1);
            }
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
            this.activeAppendable.append(csq, start, end);
            if (end - start > 0) {
                this.lastChar = csq.charAt(end - 1);
            }
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(char c) throws IOException {
            this.activeAppendable.append(c);
            this.lastChar = c;
            return this;
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            logger.log(Level.WARNING, "Visual element logging behavior is undefined when used with the |filterHtmlAttributes directive. This logging call has been dropped: {0}", statement);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            return this;
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            if (this.getSantizedContentKind() == SanitizedContent.ContentKind.ATTRIBUTES) {
                this.delegate.appendLoggingFunctionInvocation(funCall, escapers);
                this.lastChar = (char)97;
            } else {
                String placeholder = FilterHtmlAttributesAppendable.escapePlaceholder(funCall.placeholderValue(), escapers);
                this.activeAppendable.append(placeholder);
                if (placeholder.length() > 0) {
                    this.lastChar = placeholder.charAt(placeholder.length() - 1);
                }
            }
            return this;
        }

        @Override
        public boolean softLimitReached() {
            return this.delegate.softLimitReached();
        }

        @Override
        public void close() throws IOException {
            if (this.getSantizedContentKind() == SanitizedContent.ContentKind.ATTRIBUTES) {
                if (this.lastChar != '\u0000' && Sanitizers.shouldAppendSpace(this.lastChar)) {
                    this.delegate.append(' ');
                }
            } else {
                this.delegate.append(Sanitizers.filterHtmlAttributes(this.activeAppendable.toString()));
            }
        }
    }

    private static final class StreamingHtmlRcDataEscaper
    extends AbstractStreamingHtmlEscaper {
        private StreamingHtmlRcDataEscaper(LoggingAdvisingAppendable delegate) {
            super(delegate, EscapingConventions.EscapeHtml.INSTANCE.escape(delegate));
        }

        @Override
        protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
            if (this.isInHtml()) {
                this.activeAppendable = EscapingConventions.NormalizeHtml.INSTANCE.escape(this.delegate);
            }
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            this.activeAppendable.append(StreamingHtmlRcDataEscaper.escapePlaceholder(funCall.placeholderValue(), escapers));
            return this;
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            return this;
        }
    }

    private static final class CleanHtmlAppendable
    extends AbstractStreamingHtmlEscaper
    implements Closeable {
        private final Collection<? extends TagWhitelist.OptionalSafeTag> optionalSafeTags;

        CleanHtmlAppendable(LoggingAdvisingAppendable delegate, Collection<? extends TagWhitelist.OptionalSafeTag> optionalSafeTags) {
            super(delegate, new StringBuilder());
            this.optionalSafeTags = optionalSafeTags;
        }

        @Override
        protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
            if (this.isInHtml()) {
                this.activeAppendable = this.delegate;
                this.delegate.setSanitizedContentKind(kind);
            }
        }

        @Override
        protected void notifyContentDirectionality(@Nullable Dir contentDir) throws IOException {
            if (this.isInHtml()) {
                this.delegate.setSanitizedContentDirectionality(contentDir);
            }
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            if (!this.isInHtml()) {
                throw new AssertionError((Object)"Logging statements should've already been removed as they're only allowed in HTML");
            }
            this.delegate.enterLoggableElement(statement);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            if (this.isInHtml()) {
                this.delegate.exitLoggableElement();
            }
            return this;
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            if (!this.isInHtml()) {
                throw new AssertionError((Object)"Logging statements should've already been removed as they're only allowed in HTML");
            }
            this.delegate.appendLoggingFunctionInvocation(funCall, escapers);
            return this;
        }

        @Override
        public void close() throws IOException {
            StringBuilder buffer;
            if (!this.isInHtml() && (buffer = (StringBuilder)this.activeAppendable).length() > 0) {
                SanitizedContent content = Sanitizers.cleanHtml(buffer.toString(), this.getSanitizedContentDirectionality(), this.optionalSafeTags);
                this.delegate.setSanitizedContentKind(content.getContentKind()).setSanitizedContentDirectionality(content.getContentDirection()).append(content.getContent());
                buffer.setLength(0);
            }
        }
    }
}

