/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import java.util.HashMap;
import java.util.Set;

public abstract class TypedSoyFunction
implements SoyFunction {
    @Override
    public final String getName() {
        String name = this.getSignature().name();
        if (name.isEmpty()) {
            throw new AbstractMethodError(this.getClass() + "should either override getName() or specify a name in the signature.");
        }
        return name;
    }

    @Override
    public final Set<Integer> getValidArgsSizes() {
        HashMap<Integer, Signature> validArgs = new HashMap<Integer, Signature>();
        for (Signature signature : this.getSignature().value()) {
            int argSize = signature.parameterTypes().length;
            if (validArgs.containsKey(argSize)) {
                throw new IllegalArgumentException(String.format("TypedSoyFunction can only have exactly one signature for a given number of parameters. Found more than one signatures that specify %s parameters:\n  %s\n  %s", argSize, validArgs.get(argSize), signature));
            }
            validArgs.put(argSize, signature);
        }
        return ImmutableSortedSet.copyOf(validArgs.keySet());
    }

    private SoyFunctionSignature getSignature() {
        SoyFunctionSignature signature = this.getClass().getAnnotation(SoyFunctionSignature.class);
        if (signature == null) {
            throw new IllegalStateException("TypedSoyFunction must set @SoyFunctionSignature annotation.");
        }
        return signature;
    }
}

