/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.sharedpasses.opti.PreevalVisitorFactory;
import com.google.template.soy.sharedpasses.opti.PrerenderVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyExprVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SimplifyVisitor {
    private final SimplifyExprVisitor simplifyExprVisitor;
    private final PreevalVisitorFactory preevalVisitorFactory;

    public static SimplifyVisitor create() {
        return new SimplifyVisitor(new SimplifyExprVisitor(), new PreevalVisitorFactory());
    }

    private SimplifyVisitor(SimplifyExprVisitor simplifyExprVisitor, PreevalVisitorFactory preevalVisitorFactory) {
        this.simplifyExprVisitor = simplifyExprVisitor;
        this.preevalVisitorFactory = preevalVisitorFactory;
    }

    public void simplify(SoyFileSetNode fileSet, TemplateRegistry registry) {
        new Impl(registry, fileSet.getNodeIdGenerator()).exec(fileSet);
    }

    private static boolean isConstant(@Nullable ExprRootNode exprRoot) {
        return exprRoot != null && SimplifyExprVisitor.isConstant(exprRoot.getRoot());
    }

    private static SoyValue getConstantOrNull(ExprRootNode exprRoot) {
        if (exprRoot == null) {
            return null;
        }
        ExprNode expr = exprRoot.getRoot();
        return SimplifyExprVisitor.getConstantOrNull(expr);
    }

    private static void replaceNodeWithList(SoyNode.StandaloneNode origNode, List<? extends SoyNode.StandaloneNode> replacementNodes) {
        ParentNode parent = origNode.getParent();
        int indexInParent = parent.getChildIndex(origNode);
        parent.removeChild(indexInParent);
        parent.addChildren(indexInParent, replacementNodes);
    }

    private final class Impl
    extends AbstractSoyNodeVisitor<Void> {
        final TemplateRegistry templateRegistry;
        final IdGenerator nodeIdGen;

        Impl(TemplateRegistry templateRegistry, IdGenerator idGenerator) {
            this.templateRegistry = templateRegistry;
            this.nodeIdGen = idGenerator;
        }

        @Override
        public Void exec(SoyNode node) {
            Preconditions.checkArgument((boolean)(node instanceof SoyFileSetNode));
            SoyFileSetNode nodeAsRoot = (SoyFileSetNode)node;
            for (SoyFileNode file : Iterables.filter(nodeAsRoot.getChildren(), SoyFileNode.MATCH_SRC_FILENODE)) {
                SoyTreeUtils.execOnAllV2Exprs(file, SimplifyVisitor.this.simplifyExprVisitor);
                this.visit(file);
            }
            return null;
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            ParentNode parent = node.getParent();
            if (parent instanceof SoyNode.MsgBlockNode) {
                return;
            }
            if (!SimplifyVisitor.isConstant(node.getExpr())) {
                return;
            }
            for (PrintDirectiveNode directive : node.getChildren()) {
                for (ExprRootNode arg : directive.getArgs()) {
                    if (SimplifyVisitor.isConstant(arg)) continue;
                    return;
                }
            }
            StringBuilder prerenderOutputSb = new StringBuilder();
            try {
                PrerenderVisitor prerenderer = new PrerenderVisitor(SimplifyVisitor.this.preevalVisitorFactory, prerenderOutputSb, this.templateRegistry);
                prerenderer.exec(node);
            }
            catch (RenderException pe) {
                return;
            }
            String string = prerenderOutputSb.toString();
            if (string.isEmpty()) {
                parent.removeChild(node);
            } else {
                parent.replaceChild(node, new RawTextNode(this.nodeIdGen.genId(), string, node.getSourceLocation()));
            }
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.visitSoyNode(node);
            for (SoyNode child : Lists.newArrayList(node.getChildren())) {
                IfCondNode condNode;
                ExprRootNode condExpr;
                if (!(child instanceof IfCondNode) || !SimplifyVisitor.isConstant(condExpr = (condNode = (IfCondNode)child).getExpr())) continue;
                if (SimplifyVisitor.getConstantOrNull(condExpr).coerceToBoolean()) {
                    int condIndex = node.getChildIndex(condNode);
                    for (int i = node.numChildren() - 1; i > condIndex; --i) {
                        node.removeChild(i);
                    }
                    IfElseNode newElseNode = new IfElseNode(this.nodeIdGen.genId(), condNode.getSourceLocation());
                    newElseNode.addChildren(condNode.getChildren());
                    node.replaceChild(condIndex, newElseNode);
                    break;
                }
                node.removeChild(condNode);
            }
            if (node.numChildren() == 0) {
                node.getParent().removeChild(node);
            }
            if (node.numChildren() == 1 && node.getChild(0) instanceof IfElseNode) {
                SimplifyVisitor.replaceNodeWithList(node, ((IfElseNode)node.getChild(0)).getChildren());
            }
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitSoyNode(node);
            SoyValue switchExprValue = SimplifyVisitor.getConstantOrNull(node.getExpr());
            if (switchExprValue == null) {
                return;
            }
            for (SoyNode child : Lists.newArrayList((Iterable)node.getChildren())) {
                if (!(child instanceof SwitchCaseNode)) continue;
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                boolean hasMatchingConstant = false;
                boolean hasAllNonmatchingConstants = true;
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    SoyValue caseExprValue = SimplifyVisitor.getConstantOrNull(caseExpr);
                    if (caseExprValue == null) {
                        hasAllNonmatchingConstants = false;
                        continue;
                    }
                    if (!caseExprValue.equals(switchExprValue)) continue;
                    hasMatchingConstant = true;
                    hasAllNonmatchingConstants = false;
                    break;
                }
                if (hasMatchingConstant) {
                    int caseIndex = node.getChildIndex(caseNode);
                    for (int i = node.numChildren() - 1; i > caseIndex; --i) {
                        node.removeChild(i);
                    }
                    SwitchDefaultNode newDefaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), caseNode.getSourceLocation());
                    newDefaultNode.addChildren(caseNode.getChildren());
                    node.replaceChild(caseIndex, newDefaultNode);
                    break;
                }
                if (!hasAllNonmatchingConstants) continue;
                node.removeChild(caseNode);
            }
            if (node.numChildren() == 1 && node.getChild(0) instanceof SwitchDefaultNode) {
                SimplifyVisitor.replaceNodeWithList(node, ((SwitchDefaultNode)node.getChild(0)).getChildren());
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
            }
            if (!(node instanceof SoyNode.BlockNode)) {
                return;
            }
            SoyNode.BlockNode nodeAsBlock = (SoyNode.BlockNode)node;
            boolean hasConsecRawTextNodes = false;
            for (int i = 0; i <= nodeAsBlock.numChildren() - 2; ++i) {
                if (!(nodeAsBlock.getChild(i) instanceof RawTextNode) || !(nodeAsBlock.getChild(i + 1) instanceof RawTextNode)) continue;
                hasConsecRawTextNodes = true;
                break;
            }
            if (!hasConsecRawTextNodes) {
                return;
            }
            ArrayList copyOfOrigChildren = Lists.newArrayList(nodeAsBlock.getChildren());
            nodeAsBlock.clearChildren();
            ArrayList consecutiveRawTextNodes = Lists.newArrayList();
            for (SoyNode.StandaloneNode origChild : copyOfOrigChildren) {
                if (origChild instanceof RawTextNode) {
                    consecutiveRawTextNodes.add((RawTextNode)origChild);
                    continue;
                }
                this.addConsecutiveRawTextNodesAsOneNodeHelper(nodeAsBlock, consecutiveRawTextNodes);
                consecutiveRawTextNodes.clear();
                nodeAsBlock.addChild(origChild);
            }
            this.addConsecutiveRawTextNodesAsOneNodeHelper(nodeAsBlock, consecutiveRawTextNodes);
            consecutiveRawTextNodes.clear();
        }

        private void addConsecutiveRawTextNodesAsOneNodeHelper(SoyNode.BlockNode parent, List<RawTextNode> consecutiveRawTextNodes) {
            if (consecutiveRawTextNodes.isEmpty()) {
                return;
            }
            if (consecutiveRawTextNodes.size() == 1) {
                parent.addChild((Node)consecutiveRawTextNodes.get(0));
            } else {
                StringBuilder rawText = new StringBuilder();
                for (RawTextNode rtn : consecutiveRawTextNodes) {
                    rawText.append(rtn.getRawText());
                }
                parent.addChild(new RawTextNode(this.nodeIdGen.genId(), rawText.toString(), parent.getSourceLocation()));
            }
        }
    }
}

