/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.LegacyObjectMapLiteralNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.PluginResolver;
import com.google.template.soy.soyparse.RawTextBuilder;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.SoyParseUtils;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.ErrorType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final SoyErrorKind INVALID_ALIAS_NAME = SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_CALLEE_NAME = SoyErrorKind.of("Invalid callee name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_DELTEMPLATE_NAME = SoyErrorKind.of("Deltemplate ''{0}'' must have a fully qualified name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PRINT_COMMAND_TEXT = SoyErrorKind.of("Invalid ''print'' command text \"{0}\" (check the directives).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TEMPLATE_NAME = SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot followed by an identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyErrorKind.of("Found multiple ''phname'' attributes in command text \"{0}\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS = SoyErrorKind.of("Plural case ''{0}'' must be a nonnegative integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_MALFORMED = SoyErrorKind.of("Invalid number in ''plural case'' command text.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_OFFSET_OUT_OF_BOUNDS = SoyErrorKind.of("The ''offset'' for plural must be a positive integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PRINT_COMMAND_WITH_EMPTY_TEXT = SoyErrorKind.of("Found ''print'' command with empty command text.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER = SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE = SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CSS_XID_MIGRATION = SoyErrorKind.of("The ''{0}'' command is {1}, please switch to using the {0} function.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_PARAM_NAME = SoyErrorKind.of("Duplicate param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INTEGER_OUT_OF_RANGE = SoyErrorKind.of("Soy integers are constrained to the range of JavaScript integers: https://www.ecma-international.org/ecma-262/5.1/#sec-8.5", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_FUNCTION_NAME = SoyErrorKind.of("Invalid function name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PARAM_NAME = SoyErrorKind.of("Invalid param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VAR_NAME_IJ = SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Disallowed single-identifier key \"{0}\" in map literal (please surround with single quotes for string or parentheses for global).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_PIPE = SoyErrorKind.of("Unexpected ''|''. Print directives should not have whitespace after ''|''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FOREACH_IS_DISABLED = SoyErrorKind.of("foreach loops are no longer supported, please switch to the for loop.", SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind PARSER_ERROR = SoyErrorKind.of("parse error at ''{0}'': expected {1}", SoyErrorKind.StyleAllowance.NO_CAPS, SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private SoyTypeRegistry typeRegistry;
    private IdGenerator nodeIdGen;
    private SoyFileKind soyFileKind;
    private String filePath;
    private ErrorReporter errorReporter;
    private PluginResolver pluginResolver;
    private TemplateNode.SoyFileHeaderInfo headerInfo;
    private ImmutableSet<String> experimentalFeatures;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[101];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static ExprNode parseExprOrDie(String exprText) {
        return SoyFileParser.parseExpression(exprText, PluginResolver.nullResolver(PluginResolver.Mode.REQUIRE_DEFINITIONS, ErrorReporter.exploding()), ErrorReporter.exploding());
    }

    @Nullable
    public static ExprNode parseExpression(String exprText, PluginResolver resolver, ErrorReporter errorReporter) {
        String filePath = "expression parser";
        SoyFileParser parser = new SoyFileParser(exprText, resolver, filePath, errorReporter);
        try {
            return parser.ExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, parser.token_source.curLexState);
            return null;
        }
    }

    @Nullable
    public static SoyType parseType(String typeText, SoyTypeRegistry typeRegistry, String filePath, ErrorReporter errorReporter) {
        SoyFileParser parser = new SoyFileParser(typeText, PluginResolver.nullResolver(PluginResolver.Mode.REQUIRE_DEFINITIONS, errorReporter), filePath, errorReporter);
        try {
            return typeRegistry.getOrCreateType(parser.TypeExpr(), errorReporter);
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, parser.token_source.curLexState);
            return null;
        }
    }

    public SoyFileParser(SoyTypeRegistry typeRegistry, PluginResolver pluginResolver, IdGenerator nodeIdGen, Reader input, SoyFileKind soyFileKind, String filePath, ErrorReporter errorReporter, ImmutableSet<String> experimentalFeatures) {
        this(input);
        this.typeRegistry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)typeRegistry);
        this.pluginResolver = (PluginResolver)Preconditions.checkNotNull((Object)pluginResolver);
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
        this.soyFileKind = (SoyFileKind)((Object)Preconditions.checkNotNull((Object)((Object)soyFileKind)));
        this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.experimentalFeatures = (ImmutableSet)Preconditions.checkNotNull(experimentalFeatures);
    }

    private SoyFileParser(String input, PluginResolver pluginResolver, String filePath, ErrorReporter errorReporter) {
        this(new SoyFileParserTokenManager(new SimpleCharStream(new StringReader(input), 1, 1), 2));
        this.filePath = filePath;
        this.pluginResolver = (PluginResolver)Preconditions.checkNotNull((Object)pluginResolver);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.headerInfo = TemplateNode.SoyFileHeaderInfo.EMPTY;
    }

    @Nullable
    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.typeRegistry);
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e, this.token_source.curLexState);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportTokenMgrError(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        return soyFileNode;
    }

    String getFilePath() {
        return this.filePath;
    }

    private Token reportFileErrorAndSkipTo(ParseException error, int skipTo) {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        do {
            t = this.getNextToken();
        } while (t.kind != skipTo && t.kind != 0);
        return t;
    }

    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int ... kinds) {
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        return this.skipToTemplateToken(kinds);
    }

    private Token skipToTemplateToken(int ... kinds) {
        Token t;
        ImmutableSet skipTo = ImmutableSet.copyOf((Collection)Ints.asList((int[])kinds));
        do {
            t = this.getNextToken();
            if (t.kind != 35 && t.kind != 36) continue;
            throw new AbortParsingError();
        } while (!skipTo.contains((Object)t.kind) && t.kind != 0);
        return t;
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private VarRefNode errorExpr(Token tok1, Token ... rest) {
        return VarRefNode.error(this.createSrcLoc(tok1, rest));
    }

    private VarRefNode errorExpr(SourceLocation location) {
        return VarRefNode.error(location);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        Identifier delpackageName = null;
        Object aliases = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        NamespaceDeclaration namespace = this.Namespace();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            AliasDeclaration alias = this.Alias();
            if (aliases.isEmpty()) {
                aliases = new ArrayList();
            }
            if (alias == null) continue;
            aliases.add(alias);
        }
        this.headerInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageName, namespace, (Collection<AliasDeclaration>)aliases);
        SoyFileNode sfn = new SoyFileNode(this.nodeIdGen.genId(), this.filePath, this.soyFileKind, namespace, this.headerInfo);
        block10: while (true) {
            TemplateNode template;
            if ((template = this.Template(this.headerInfo)) != null) {
                sfn.addChild(template);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 33: 
                case 34: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(0);
        if ("" != null) {
            return sfn;
        }
        throw new Error("Missing return statement in function");
    }

    private final AliasDeclaration Alias() throws ParseException {
        Identifier alias = null;
        Token as = null;
        Token open = this.jj_consume_token(10);
        Identifier namespace = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                as = this.Keyword("as");
                alias = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(87);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
            this.errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
            if ("" != null) {
                return null;
            }
        }
        if (alias == null) {
            alias = namespace.extractPartAfterLastDot();
        }
        if ("" != null) {
            return AliasDeclaration.create(namespace, alias);
        }
        throw new Error("Missing return statement in function");
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        Token open = this.jj_consume_token(11);
        Identifier name = this.DottedIdent();
        List<CommandTagAttribute> attributes = this.Attributes();
        Token close = this.jj_consume_token(87);
        if ("" != null) {
            return new NamespaceDeclaration(name, attributes, this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<CommandTagAttribute> Attributes() throws ParseException {
        Object attributes = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 89: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            CommandTagAttribute attr = this.Attribute();
            if (attributes.isEmpty()) {
                attributes = new ArrayList();
            }
            attributes.add(attr);
        }
        CommandTagAttribute.removeDuplicatesAndReportErrors((Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        if ("" != null) {
            return attributes;
        }
        throw new Error("Missing return statement in function");
    }

    private final CommandTagAttribute Attribute() throws ParseException {
        ImmutableList exprList = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 89: {
                QuoteStyle quoteStyle;
                Token value;
                Token name = this.jj_consume_token(89);
                this.jj_consume_token(91);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        value = this.jj_consume_token(27);
                        quoteStyle = QuoteStyle.DOUBLE;
                        break;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        value = this.jj_consume_token(28);
                        quoteStyle = QuoteStyle.SINGLE;
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if ("" == null) break;
                return new CommandTagAttribute(Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), quoteStyle, value.image, this.createSrcLoc(value, new Token[0]));
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Token qToken;
                String attrName;
                Token attrTag;
                QuoteStyle quoteStyle;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: 
                    case 17: 
                    case 19: 
                    case 21: {
                        quoteStyle = QuoteStyle.DOUBLE;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 15: {
                                attrTag = this.jj_consume_token(15);
                                attrName = "data";
                                break;
                            }
                            case 17: {
                                attrTag = this.jj_consume_token(17);
                                attrName = "variant";
                                break;
                            }
                            case 19: {
                                attrTag = this.jj_consume_token(19);
                                attrName = "genders";
                                break;
                            }
                            case 21: {
                                attrTag = this.jj_consume_token(21);
                                attrName = "logonly";
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        try {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: 
                                case 103: 
                                case 104: 
                                case 124: 
                                case 128: 
                                case 131: 
                                case 135: 
                                case 138: 
                                case 139: 
                                case 140: {
                                    exprList = this.ExprList();
                                    break;
                                }
                                default: {
                                    this.jj_la1[7] = this.jj_gen;
                                }
                            }
                            qToken = this.jj_consume_token(25);
                        }
                        catch (ParseException e) {
                            exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                            qToken = this.reportTemplateBodyErrorAndSkipTo(e, 104);
                        }
                        break;
                    }
                    case 16: 
                    case 18: 
                    case 20: 
                    case 22: {
                        quoteStyle = QuoteStyle.SINGLE;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 16: {
                                attrTag = this.jj_consume_token(16);
                                attrName = "data";
                                break;
                            }
                            case 18: {
                                attrTag = this.jj_consume_token(18);
                                attrName = "variant";
                                break;
                            }
                            case 20: {
                                attrTag = this.jj_consume_token(20);
                                attrName = "genders";
                                break;
                            }
                            case 22: {
                                attrTag = this.jj_consume_token(22);
                                attrName = "logonly";
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        try {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: 
                                case 103: 
                                case 104: 
                                case 124: 
                                case 128: 
                                case 131: 
                                case 135: 
                                case 138: 
                                case 139: 
                                case 140: {
                                    exprList = this.ExprList();
                                    break;
                                }
                                default: {
                                    this.jj_la1[9] = this.jj_gen;
                                }
                            }
                            qToken = this.jj_consume_token(26);
                        }
                        catch (ParseException e) {
                            exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                            qToken = this.reportTemplateBodyErrorAndSkipTo(e, 103);
                        }
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (exprList.isEmpty()) {
                    this.errorReporter.report(this.createSrcLoc(qToken, new Token[0]), PARSER_ERROR, qToken.image, "an expression");
                    exprList = ImmutableList.of((Object)this.errorExpr(qToken, new Token[0]));
                }
                if ("" == null) break;
                return new CommandTagAttribute(Identifier.create(attrName, this.createSrcLoc(attrTag, new Token[0])), quoteStyle, (ImmutableList<ExprNode>)exprList);
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final CommandTagAttribute ExprAttribute() throws ParseException {
        QuoteStyle quoteStyle;
        Token value;
        Token name = this.jj_consume_token(138);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                value = this.jj_consume_token(27);
                quoteStyle = QuoteStyle.DOUBLE;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                value = this.jj_consume_token(28);
                quoteStyle = QuoteStyle.SINGLE;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return new CommandTagAttribute(Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), quoteStyle, value.image, this.createSrcLoc(value, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DelPackage() throws ParseException {
        this.jj_consume_token(12);
        Identifier name = this.DottedIdent();
        this.jj_consume_token(87);
        if ("" != null) {
            return name;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        TemplateNode templateNode = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: {
                Token open = this.jj_consume_token(34);
                TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open, false);
                    this.jj_consume_token(35);
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 35);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            case 33: {
                Token open = this.jj_consume_token(33);
                TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open, true);
                    this.jj_consume_token(36);
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 36);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode TemplateHelper(TemplateNodeBuilder builder, Token open, boolean isDeltemplate) throws ParseException {
        builder.setId(this.nodeIdGen.genId());
        Identifier templateName = this.TemplateName();
        if (!isDeltemplate && templateName.type() != Identifier.Type.DOT_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_TEMPLATE_NAME, templateName.identifier());
        }
        if (isDeltemplate && templateName.type() == Identifier.Type.DOT_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_DELTEMPLATE_NAME, templateName.identifier());
        }
        List<CommandTagAttribute> attributes = this.Attributes();
        builder.setCommandValues(templateName, attributes);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 9) {
            builder.setSoyDoc(soyDoc.image, this.createSrcLoc(soyDoc, new Token[0]));
        }
        Token close = this.jj_consume_token(87);
        builder.setSourceLocation(this.createSrcLoc(open, close));
        RawTextNode initialWhitespace = this.TemplateHeader(builder);
        List<SoyNode.StandaloneNode> templateBodyNodes = this.TemplateBlock();
        TemplateNode templateNode = builder.build();
        if (initialWhitespace != null) {
            templateNode.addChild(initialWhitespace);
        }
        templateNode.addChildren(templateBodyNodes);
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier TemplateName() throws ParseException {
        Identifier ident;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 92: {
                Token dot = this.jj_consume_token(92);
                Token name = this.jj_consume_token(89);
                ident = Identifier.create("." + name.image, this.createSrcLoc(dot, name));
                break;
            }
            case 89: {
                ident = this.DottedIdent();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ident;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DottedIdent() throws ParseException {
        StringBuilder sb = null;
        Token next = null;
        Token name = this.jj_consume_token(89);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            Token dot = this.jj_consume_token(92);
            next = this.jj_consume_token(89);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(name.image);
            }
            sb.append('.').append(next.image);
        }
        if ("" != null) {
            return sb == null ? Identifier.create(name.image, this.createSrcLoc(name, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(name, next));
        }
        throw new Error("Missing return statement in function");
    }

    private final void SkipWhitespace() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(95);
        }
    }

    private final RawTextNode RawText() throws ParseException {
        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 95: 
                case 96: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 96: {
                            token = this.jj_consume_token(96);
                            break;
                        }
                        case 95: {
                            token = this.jj_consume_token(95);
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addBasic(token);
                    break;
                }
                case 49: {
                    this.jj_consume_token(49);
                    Token token = this.jj_consume_token(94);
                    builder.addLiteral(token);
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 42: {
                            token = this.jj_consume_token(42);
                            break;
                        }
                        case 43: {
                            token = this.jj_consume_token(43);
                            break;
                        }
                        case 45: {
                            token = this.jj_consume_token(45);
                            break;
                        }
                        case 44: {
                            token = this.jj_consume_token(44);
                            break;
                        }
                        case 46: {
                            token = this.jj_consume_token(46);
                            break;
                        }
                        case 47: {
                            token = this.jj_consume_token(47);
                            break;
                        }
                        case 48: {
                            token = this.jj_consume_token(48);
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addTextualCommand(token);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 95: 
                case 96: {
                    continue block21;
                }
            }
            break;
        }
        this.jj_la1[20] = this.jj_gen;
        if ("" != null) {
            return builder.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final RawTextNode TemplateHeader(TemplateNodeBuilder templateBuilder) throws ParseException {
        RawTextNode whitespace;
        Object params;
        block15: {
            params = ImmutableList.of();
            whitespace = null;
            String soyDoc = null;
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 95: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 95: {
                        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                        block11: while (true) {
                            Token tok = this.jj_consume_token(95);
                            if (tok.specialToken != null) {
                                soyDoc = tok.specialToken.image;
                            }
                            builder.addBasic(tok);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 95: {
                                    continue block11;
                                }
                            }
                            break;
                        }
                        this.jj_la1[22] = this.jj_gen;
                        whitespace = builder.build();
                        continue block10;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        HeaderParam param = this.ParamDecl(soyDoc);
                        whitespace = null;
                        soyDoc = null;
                        if (params.isEmpty()) {
                            params = new ArrayList();
                        }
                        params.add(param);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[23] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        templateBuilder.addParams((Iterable<? extends TemplateParam>)params);
        if ("" != null) {
            return whitespace;
        }
        throw new Error("Missing return statement in function");
    }

    private final HeaderParam ParamDecl(@Nullable String desc) throws ParseException {
        Token tagBegin;
        TypeNode paramTypeNode = null;
        SoyType paramType = ErrorType.getInstance();
        boolean optional = false;
        boolean inject = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                tagBegin = this.jj_consume_token(37);
                break;
            }
            case 38: {
                tagBegin = this.jj_consume_token(38);
                optional = true;
                break;
            }
            case 39: {
                tagBegin = this.jj_consume_token(39);
                inject = true;
                break;
            }
            case 40: {
                tagBegin = this.jj_consume_token(40);
                inject = true;
                optional = true;
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null) {
            desc = tagBegin.specialToken.image;
        }
        Token name = this.jj_consume_token(89);
        this.jj_consume_token(90);
        try {
            paramTypeNode = this.TypeExpr();
            paramType = this.typeRegistry.getOrCreateType(paramTypeNode, this.errorReporter);
            Token tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException parseException) {
            Token tagEnd = this.reportTemplateBodyErrorAndSkipTo(parseException, 87);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        if ("" != null) {
            return new HeaderParam(name.image, this.createSrcLoc(name, new Token[0]), optional ? this.typeRegistry.getOrCreateUnionType(paramType, NullType.getInstance()) : paramType, paramTypeNode, !optional && !SoyTypes.isNullable(paramType), inject, desc);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        Object templateBlock = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 56: 
                case 59: 
                case 60: 
                case 61: 
                case 65: 
                case 67: 
                case 73: 
                case 77: 
                case 80: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 95: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            SoyNode.StandaloneNode node = this.TemplateBlockItem();
            if (templateBlock.isEmpty()) {
                templateBlock = new ArrayList();
            }
            templateBlock.add(node);
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StandaloneNode TemplateBlockItem() throws ParseException {
        SoyNode.StandaloneNode node;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 95: 
            case 96: {
                node = this.RawText();
                break;
            }
            case 50: 
            case 51: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 67: 
            case 73: 
            case 77: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                node = this.Stmt();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        SoyNode.StatementNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: 
            case 80: 
            case 82: 
            case 85: {
                stmt = this.NonPrintableStmt();
                break;
            }
            case 50: 
            case 51: 
            case 56: 
            case 59: 
            case 60: 
            case 83: 
            case 84: {
                stmt = this.PrintableStmt();
                break;
            }
            case 61: 
            case 67: 
            case 73: 
            case 77: {
                stmt = this.ControlFlowStmt();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode NonPrintableStmt() throws ParseException {
        AbstractCommandNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                stmt = this.LetStmt();
                break;
            }
            case 80: {
                stmt = this.LogStmt();
                break;
            }
            case 82: {
                stmt = this.DebuggerStmt();
                break;
            }
            case 85: {
                stmt = this.VeLogStmt();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode PrintableStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 56: {
                stmt = this.MsgStmt();
                break;
            }
            case 59: {
                stmt = this.XidStmt();
                break;
            }
            case 60: {
                stmt = this.CssStmt();
                break;
            }
            case 50: 
            case 51: {
                stmt = this.CallStmt();
                break;
            }
            case 83: 
            case 84: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode ControlFlowStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: {
                stmt = this.IfStmt();
                break;
            }
            case 73: {
                stmt = this.SwitchStmt();
                break;
            }
            case 67: {
                stmt = this.ForStmt();
                break;
            }
            case 77: {
                stmt = this.ForeachStmt();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        Token tagEnd;
        Object attributes = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(56);
        try {
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        SourceLocation loc = this.createSrcLoc(tagBegin, tagEnd);
        MsgFallbackGroupNode msgGroup = new MsgFallbackGroupNode(this.nodeIdGen.genId(), loc);
        MsgNode msg = new MsgNode(this.nodeIdGen.genId(), loc, "msg", (List<CommandTagAttribute>)attributes, this.errorReporter);
        msgGroup.addChild(msg);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlockForMsg();
        msg.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: {
                tagBegin = this.jj_consume_token(57);
                try {
                    attributes = this.Attributes();
                    tagEnd = this.jj_consume_token(87);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
                }
                loc = this.createSrcLoc(tagBegin, tagEnd);
                MsgNode fallback = new MsgNode(this.nodeIdGen.genId(), loc, "fallbackmsg", (List<CommandTagAttribute>)attributes, this.errorReporter);
                msgGroup.addChild(fallback);
                templateBlock = this.TemplateBlockForMsg();
                fallback.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        this.jj_consume_token(58);
        if ("" != null) {
            return msgGroup;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList<SoyNode.StandaloneNode> templateBlock;
        int pluralOrSelectIndex;
        block25: {
            pluralOrSelectIndex = -1;
            boolean firstNodeIsWhitespace = false;
            templateBlock = new ArrayList<SoyNode.StandaloneNode>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 95: {
                    RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                    block17: while (true) {
                        Token tok = this.jj_consume_token(95);
                        builder.addBasic(tok);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 95: {
                                continue block17;
                            }
                        }
                        break;
                    }
                    this.jj_la1[32] = this.jj_gen;
                    RawTextNode rawText = builder.build();
                    if (rawText == null) break;
                    firstNodeIsWhitespace = true;
                    templateBlock.add(rawText);
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                }
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 56: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 65: 
                    case 67: 
                    case 69: 
                    case 71: 
                    case 73: 
                    case 77: 
                    case 80: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 95: 
                    case 96: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block25;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: 
                    case 71: {
                        AbstractParentCommandNode msgPluralOrSelectNode;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 69: {
                                msgPluralOrSelectNode = this.MsgPlural();
                                break;
                            }
                            case 71: {
                                msgPluralOrSelectNode = this.MsgSelect();
                                break;
                            }
                            default: {
                                this.jj_la1[35] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SkipWhitespace();
                        if (firstNodeIsWhitespace) {
                            templateBlock.remove(0);
                            firstNodeIsWhitespace = false;
                        }
                        if (pluralOrSelectIndex == -1) {
                            pluralOrSelectIndex = templateBlock.size();
                        }
                        templateBlock.add((SoyNode.StandaloneNode)((Object)msgPluralOrSelectNode));
                        continue block18;
                    }
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 56: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 65: 
                    case 67: 
                    case 73: 
                    case 77: 
                    case 80: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 95: 
                    case 96: {
                        SoyNode.StandaloneNode stmt = this.TemplateBlockItem();
                        if (stmt == null) continue block18;
                        templateBlock.add(stmt);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[36] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (pluralOrSelectIndex != -1) {
            SoyNode.StandaloneNode pluralOrSelect = (SoyNode.StandaloneNode)templateBlock.get(pluralOrSelectIndex);
            for (int i = 0; i < templateBlock.size(); ++i) {
                if (i == pluralOrSelectIndex) continue;
                this.errorReporter.report(((SoyNode.StandaloneNode)templateBlock.get(i)).getSourceLocation(), i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER, pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
            }
            if ("" != null) {
                return ImmutableList.of((Object)pluralOrSelect);
            }
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        Token tagEnd;
        ExprNode pluralExpr;
        CommandTagAttribute offsetAttr = null;
        Token tagBegin = this.jj_consume_token(69);
        try {
            pluralExpr = this.Expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 138: {
                    offsetAttr = this.ExprAttribute();
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                }
            }
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            pluralExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        int offset = 0;
        if (offsetAttr != null) {
            if (pluralExpr.getSourceLocation().isJustBefore(offsetAttr.getName().location())) {
                this.errorReporter.report(offsetAttr.getName().location(), PARSER_ERROR, offsetAttr.getName().identifier(), "whitespace");
            }
            if (!offsetAttr.getName().identifier().equals("offset")) {
                this.errorReporter.report(offsetAttr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, offsetAttr.getName().identifier(), "plural", "offset");
                offsetAttr = null;
            }
        }
        if (offsetAttr != null && (offset = offsetAttr.valueAsInteger(this.errorReporter, 0)) <= 0) {
            this.errorReporter.report(offsetAttr.getValueLocation(), PLURAL_OFFSET_OUT_OF_BOUNDS, new Object[0]);
            offset = 0;
        }
        MsgPluralNode pluralNode = new MsgPluralNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), pluralExpr, offset);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                int value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        break block10;
                    }
                }
                tagBegin = this.jj_consume_token(75);
                ExprNode caseExpr = this.Expr();
                tagEnd = this.jj_consume_token(87);
                if (!(caseExpr instanceof IntegerNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED, new Object[0]);
                    value = 0;
                } else {
                    value = (int)((IntegerNode)caseExpr).getValue();
                    if (value < 0) {
                        this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
                        value = 0;
                    }
                }
                MsgPluralCaseNode caseNode = new MsgPluralCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), value);
                pluralNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                    this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
                }
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(76);
            MsgPluralDefaultNode defaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            pluralNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(70);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 70);
        }
        if ("" != null) {
            return pluralNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        Token tagEnd;
        ExprNode selectExpr;
        Token tagBegin = this.jj_consume_token(71);
        try {
            selectExpr = this.Expr();
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            selectExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        MsgSelectNode selectNode = new MsgSelectNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), selectExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        break block7;
                    }
                }
                tagBegin = this.jj_consume_token(75);
                ExprNode caseExpr = this.Expr();
                tagEnd = this.jj_consume_token(87);
                String value = ParseErrors.validateSelectCaseLabel(caseExpr, this.errorReporter);
                MsgSelectCaseNode caseNode = new MsgSelectCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), value);
                selectNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(76);
            MsgSelectDefaultNode defaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            selectNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(72);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 72);
        }
        if ("" != null) {
            return selectNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final PrintNode PrintStmt() throws ParseException {
        Token tagEnd;
        boolean isImplicit;
        Token tagBegin;
        ExprNode expr = null;
        Object directives = ImmutableList.of();
        Object attributes = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 83: {
                tagBegin = this.jj_consume_token(83);
                isImplicit = false;
                break;
            }
            case 84: {
                tagBegin = this.jj_consume_token(84);
                isImplicit = true;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            expr = this.Expr();
            directives = this.PrintDirectives();
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 138: {
                    CommandTagAttribute attr = this.ExprAttribute();
                    attributes = new ArrayList();
                    attributes.add(attr);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 138: {
                            attr = this.ExprAttribute();
                            attributes.add(attr);
                            break block5;
                        }
                    }
                    this.jj_la1[41] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                }
            }
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            if (expr == null) {
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        PrintNode node = new PrintNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), isImplicit, expr, (Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        node.addChildren((List)directives);
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<PrintDirectiveNode> PrintDirectives() throws ParseException {
        Object directives = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block3;
                }
            }
            PrintDirectiveNode node = this.PrintDirective();
            if (directives.isEmpty()) {
                directives = new ArrayList();
            }
            directives.add(node);
        }
        if ("" != null) {
            return directives;
        }
        throw new Error("Missing return statement in function");
    }

    private final PrintDirectiveNode PrintDirective() throws ParseException {
        ImmutableList<ExprNode> args = ImmutableList.of();
        Token vbar = this.jj_consume_token(137);
        Token directive = this.jj_consume_token(138);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 113: {
                this.jj_consume_token(113);
                args = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (!Tokens.areAdjacent(vbar, directive)) {
            this.errorReporter.report(this.createSrcLoc(vbar, new Token[0]), UNEXPECTED_PIPE, new Object[0]);
        }
        SourceLocation loc = this.createSrcLoc(vbar, directive);
        if (!args.isEmpty()) {
            loc.extend(((ExprNode)args.get(args.size() - 1)).getSourceLocation());
        }
        String name = "|" + directive.image;
        if ("" != null) {
            return new PrintDirectiveNode(this.nodeIdGen.genId(), loc, args, this.pluginResolver.lookupPrintDirective(name, args.size(), loc), false);
        }
        throw new Error("Missing return statement in function");
    }

    private final LogNode XidStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(59);
        Token tagEnd = this.skipToTemplateToken(87);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        this.errorReporter.report(location, CSS_XID_MIGRATION, "xid", "no longer supported");
        if ("" != null) {
            return new LogNode(this.nodeIdGen.genId(), location);
        }
        throw new Error("Missing return statement in function");
    }

    private final LogNode CssStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(60);
        Token tagEnd = this.skipToTemplateToken(87);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        this.errorReporter.report(location, CSS_XID_MIGRATION, "css", "no longer supported");
        if ("" != null) {
            return new LogNode(this.nodeIdGen.genId(), location);
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final LetNode LetStmt() throws ParseException {
        Token tagEnd;
        VarRefNode letVar = null;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(65);
        try {
            letVar = this.VarRef();
        }
        catch (ParseException e) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 88, 87);
            return new LetValueNode(-1, this.createSrcLoc(tagBegin, tagEnd), "error", this.errorExpr(tagBegin, new Token[0]));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 113: {
                try {
                    this.jj_consume_token(113);
                    valueExpr = this.Expr();
                    tagEnd = this.jj_consume_token(88);
                    return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), valueExpr);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 88, 87);
                    if (valueExpr != null) return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), valueExpr);
                    valueExpr = this.errorExpr(tagEnd, new Token[0]);
                }
                return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), valueExpr);
            }
            case 87: 
            case 138: {
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 138: {
                            attr = this.ExprAttribute();
                            break;
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                        }
                    }
                    tagEnd = this.jj_consume_token(87);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87, 88);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                this.jj_consume_token(66);
                LetContentNode node = new LetContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[46] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final IfNode IfStmt() throws ParseException {
        Token tagEnd;
        ExprNode ifExpr;
        Token tagBegin = this.jj_consume_token(61);
        try {
            ifExpr = this.Expr();
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            ifExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), location);
        IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "if", ifExpr);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    break block10;
                }
            }
            tagBegin = this.jj_consume_token(62);
            try {
                ifExpr = this.Expr();
                tagEnd = this.jj_consume_token(87);
            }
            catch (ParseException e) {
                ifExpr = this.errorExpr(tagBegin, new Token[0]);
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
            }
            location = this.createSrcLoc(tagBegin, tagEnd);
            ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "elseif", ifExpr);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 63: {
                Token elseTag = this.jj_consume_token(63);
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, new Token[0]));
                ifNode.addChild(ifElseNode);
                templateBlock = this.TemplateBlock();
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        this.jj_consume_token(64);
        if ("" != null) {
            return ifNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final VeLogNode VeLogStmt() throws ParseException {
        Token tagEnd;
        Identifier name = null;
        Object protoExpr = null;
        Object logonlyExpr = null;
        ImmutableList attributes = null;
        Token tagBegin = this.jj_consume_token(85);
        try {
            name = this.DottedIdent();
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            if (name == null) {
                name = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
            }
            if (attributes == null) {
                attributes = ImmutableList.of();
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(86);
        VeLogNode node = new VeLogNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), name, (List<CommandTagAttribute>)attributes, this.errorReporter);
        node.addChildren(templateBlock);
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        Token tagEnd;
        ExprNode switchExpr;
        Token tagBegin = this.jj_consume_token(73);
        try {
            switchExpr = this.Expr();
            tagEnd = this.jj_consume_token(87);
        }
        catch (ParseException e) {
            switchExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
        }
        SwitchNode switchNode = new SwitchNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), switchExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                tagBegin = this.jj_consume_token(75);
                ImmutableList<ExprNode> caseExprs = this.ExprList();
                tagEnd = this.jj_consume_token(87);
                SwitchCaseNode caseNode = new SwitchCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), caseExprs);
                switchNode.addChild(caseNode);
                templateBlock = this.TemplateBlock();
                caseNode.addChildren(templateBlock);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[49] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 76: {
                    Token defaultTag = this.jj_consume_token(76);
                    SwitchDefaultNode defaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
                    switchNode.addChild(defaultNode);
                    templateBlock = this.TemplateBlock();
                    defaultNode.addChildren(templateBlock);
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                }
            }
            this.jj_consume_token(74);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        if ("" != null) {
            return switchNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final ForNode ForStmt() throws ParseException {
        Token tagEnd;
        Token tagBegin;
        ExprNode expr;
        VarRefNode var;
        block7: {
            var = null;
            expr = null;
            tagBegin = this.jj_consume_token(67);
            try {
                var = this.VarRef();
                Token in = this.Keyword("in");
                expr = this.Expr();
                tagEnd = this.jj_consume_token(87);
            }
            catch (ParseException e) {
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87);
                if (var == null) {
                    var = this.errorExpr(tagBegin, new Token[0]);
                }
                if (expr != null) break block7;
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
        }
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), tagBegin.kind == 77 ? "foreach" : "for", expr);
        ForNonemptyNode nonEmpty = new ForNonemptyNode(this.nodeIdGen.genId(), var.getSourceLocation(), var.getName());
        forNode.addChild(nonEmpty);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        nonEmpty.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: {
                Token ifemptyTag = this.jj_consume_token(78);
                templateBlock = this.TemplateBlock();
                ForIfemptyNode ifempty = new ForIfemptyNode(this.nodeIdGen.genId(), this.createSrcLoc(ifemptyTag, new Token[0]));
                ifempty.addChildren(templateBlock);
                forNode.addChild(ifempty);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        this.jj_consume_token(68);
        if ("" != null) {
            return forNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final LogNode ForeachStmt() throws ParseException {
        Token tok = this.jj_consume_token(77);
        SourceLocation location = this.createSrcLoc(tok, new Token[0]);
        this.errorReporter.report(location, FOREACH_IS_DISABLED, new Object[0]);
        this.skipToTemplateToken(79);
        if ("" != null) {
            return new LogNode(this.nodeIdGen.genId(), location);
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final CallNode CallStmt() throws ParseException {
        calleeName = null;
        attributes /* !! */  = ImmutableList.of();
        params /* !! */  = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                tagBegin = this.jj_consume_token(50);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 88: {
                            tagEnd = this.jj_consume_token(88);
                            break;
                        }
                        case 87: {
                            tagEnd = this.jj_consume_token(87);
                            params /* !! */  = this.CallParams();
                            this.jj_consume_token(52);
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{88, 52});
                    if (calleeName != null) ** GOTO lbl30
                    calleeName = Identifier.create(".error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl30:
                // 3 sources

                fullName = SoyParseUtils.calculateFullCalleeName(calleeName, this.headerInfo, this.errorReporter);
                node = new CallBasicNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagEnd}), calleeName.identifier(), fullName, (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                node.addChildren((List)params /* !! */ );
                if ("" == null) break;
                return node;
            }
            case 51: {
                tagBegin = this.jj_consume_token(51);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 88: {
                            tagEnd = this.jj_consume_token(88);
                            break;
                        }
                        case 87: {
                            tagEnd = this.jj_consume_token(87);
                            params /* !! */  = this.CallParams();
                            this.jj_consume_token(53);
                            break;
                        }
                        default: {
                            this.jj_la1[53] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{88, 53});
                    if (calleeName != null) ** GOTO lbl60
                    calleeName = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl60:
                // 3 sources

                if (calleeName.type() == Identifier.Type.DOT_IDENT) {
                    this.errorReporter.report(calleeName.location(), SoyFileParser.INVALID_CALLEE_NAME, new Object[]{calleeName.identifier()});
                }
                node = new CallDelegateNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagEnd}), calleeName.identifier(), (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                node.addChildren((List)params /* !! */ );
                if ("" == null) break;
                return node;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final List<CallParamNode> CallParams() throws ParseException {
        Object params = ImmutableList.of();
        this.SkipWhitespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block3;
                }
            }
            CallParamNode paramNode = this.CallParam();
            if (params.isEmpty()) {
                params = new ArrayList();
            }
            params.add(paramNode);
            this.SkipWhitespace();
        }
        if ("" != null) {
            return params;
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CallParamNode CallParam() throws ParseException {
        Token tagEnd;
        Identifier key;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(54);
        try {
            key = this.Identifier();
        }
        catch (ParseException e) {
            key = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 88, 87);
            return new CallParamValueNode(-1, this.createSrcLoc(tagBegin, tagEnd), key, this.errorExpr(tagBegin, new Token[0]));
        }
        if (key.type() != Identifier.Type.SINGLE_IDENT) {
            this.errorReporter.report(key.location(), INVALID_PARAM_NAME, key.identifier());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 113: {
                try {
                    this.jj_consume_token(113);
                    valueExpr = this.Expr();
                    tagEnd = this.jj_consume_token(88);
                    return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 88, 87);
                    if (valueExpr != null) return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
                    valueExpr = this.errorExpr(tagEnd, new Token[0]);
                }
                return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
            }
            case 87: 
            case 138: {
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 138: {
                            attr = this.ExprAttribute();
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                        }
                    }
                    tagEnd = this.jj_consume_token(87);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 87, 88);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                this.jj_consume_token(55);
                CallParamContentNode node = new CallParamContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[57] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(80);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, new Token[0]));
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        logNode.addChildren(templateBlock);
        this.jj_consume_token(81);
        if ("" != null) {
            return logNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(82);
        if ("" != null) {
            return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode ExprInput() throws ParseException {
        ExprNode expr = this.Expr();
        this.jj_consume_token(0);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ImmutableList<ExprNode> ExprList() throws ParseException {
        ImmutableList.Builder exprList = ImmutableList.builder();
        ExprNode expr = this.Expr();
        exprList.add((Object)expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 134: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(134);
            expr = this.Expr();
            exprList.add((Object)expr);
        }
        if ("" != null) {
            return exprList.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 112: 
            case 114: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 114: {
                        Token op = this.jj_consume_token(114);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(this.createSrcLoc(op, new Token[0]), expr, expr1);
                        break block0;
                    }
                    case 112: {
                        this.jj_consume_token(112);
                        ExprNode expr1 = this.PrecExpr1();
                        this.jj_consume_token(113);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr.getSourceLocation().extend(expr2.getSourceLocation()), expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[59] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 115: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(115);
            ExprNode rightHand = this.PrecExpr3();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 2, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 116: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(116);
            ExprNode rightHand = this.PrecExpr4();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 3, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 117: 
                case 118: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 117: {
                    op = this.jj_consume_token(117);
                    break;
                }
                case 118: {
                    op = this.jj_consume_token(118);
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr5();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 4, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: {
                    op = this.jj_consume_token(119);
                    break;
                }
                case 120: {
                    op = this.jj_consume_token(120);
                    break;
                }
                case 121: {
                    op = this.jj_consume_token(121);
                    break;
                }
                case 122: {
                    op = this.jj_consume_token(122);
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr6();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 5, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr = this.PrecExpr7();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 123: 
                case 124: {
                    break;
                }
                default: {
                    this.jj_la1[67] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 123: {
                    op = this.jj_consume_token(123);
                    break;
                }
                case 124: {
                    op = this.jj_consume_token(124);
                    break;
                }
                default: {
                    this.jj_la1[68] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr7();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 6, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block8: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 125: {
                    op = this.jj_consume_token(125);
                    break;
                }
                case 126: {
                    op = this.jj_consume_token(126);
                    break;
                }
                case 127: {
                    op = this.jj_consume_token(127);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr8();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 7, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 131: 
            case 135: 
            case 138: 
            case 139: 
            case 140: {
                expr = this.PrecExpr9();
                break;
            }
            case 124: 
            case 128: {
                Token op;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 128: {
                        op = this.jj_consume_token(128);
                        break;
                    }
                    case 124: {
                        op = this.jj_consume_token(124);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.PrecExpr8();
                if (op.kind == 124 && expr instanceof IntegerNode) {
                    SourceLocation newLoc = this.createSrcLoc(op, new Token[0]).extend(expr.getSourceLocation());
                    long value = -1L * ((IntegerNode)expr).getValue();
                    expr = new IntegerNode(value, newLoc);
                    break;
                }
                if (op.kind == 124 && expr instanceof FloatNode) {
                    SourceLocation newLoc = this.createSrcLoc(op, new Token[0]).extend(expr.getSourceLocation());
                    double value = -1.0 * ((FloatNode)expr).getValue();
                    expr = new FloatNode(value, newLoc);
                    break;
                }
                expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 8, expr);
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block17: {
            expr = this.Primary();
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 129: 
                    case 130: 
                    case 131: 
                    case 133: {
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 129: 
                    case 130: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 129: {
                                op = this.jj_consume_token(129);
                                break;
                            }
                            case 130: {
                                op = this.jj_consume_token(130);
                                break;
                            }
                            default: {
                                this.jj_la1[74] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token ident = this.jj_consume_token(138);
                        expr = new FieldAccessNode(expr, ident.image, this.createSrcLoc(op, ident), op.kind == 130);
                        continue block15;
                    }
                    case 131: 
                    case 133: {
                        Token open;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 131: {
                                open = this.jj_consume_token(131);
                                break;
                            }
                            case 133: {
                                open = this.jj_consume_token(133);
                                break;
                            }
                            default: {
                                this.jj_la1[75] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        ExprNode keyExpr = this.Expr();
                        Token close = this.jj_consume_token(132);
                        expr = new ItemAccessNode(expr, keyExpr, this.createSrcLoc(open, close), open.kind == 133);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[76] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                primary = this.Expr();
                this.jj_consume_token(136);
                break;
            }
            case 139: {
                primary = this.IjRef();
                break;
            }
            case 140: {
                primary = this.VarRef();
                break;
            }
            case 138: {
                primary = this.GlobalOrFunctionOrMapLiteral();
                break;
            }
            case 131: {
                primary = this.CollectionLiteral();
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                primary = this.Primitive();
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primary;
        }
        throw new Error("Missing return statement in function");
    }

    private final VarRefNode IjRef() throws ParseException {
        block3: {
            Token ij = this.jj_consume_token(139);
            try {
                this.jj_consume_token(129);
                Token ident = this.jj_consume_token(138);
                if ("" != null) {
                    return new VarRefNode(ident.image, this.createSrcLoc(ij, ident), true, null);
                }
            }
            catch (ParseException e) {
                SourceLocation loc = this.createSrcLoc(ij, new Token[0]);
                this.errorReporter.report(loc, INVALID_VAR_NAME_IJ, new Object[0]);
                if ("" == null) break block3;
                return new VarRefNode("ij", loc, false, null);
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final VarRefNode VarRef() throws ParseException {
        Token ident = this.jj_consume_token(140);
        if ("" != null) {
            return new VarRefNode(ident.image.substring(1), this.createSrcLoc(ident, new Token[0]), false, null);
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode GlobalOrFunctionOrMapLiteral() throws ParseException {
        SoyType type;
        Token openParen = null;
        Token closeParen = null;
        ArrayList<ExprNode> params = new ArrayList<ExprNode>();
        ImmutableMap.Builder kvPairs = ImmutableMap.builder();
        Identifier ident = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                openParen = this.jj_consume_token(135);
                if (ident.identifier().equals("map")) {
                    block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 124: 
                        case 128: 
                        case 131: 
                        case 135: 
                        case 138: 
                        case 139: 
                        case 140: {
                            ExprNode key = this.Expr();
                            this.jj_consume_token(113);
                            ExprNode val = this.Expr();
                            kvPairs.put((Object)key, (Object)val);
                            while (this.getToken((int)1).kind == 134 && this.getToken((int)2).kind != 136) {
                                this.jj_consume_token(134);
                                key = this.Expr();
                                this.jj_consume_token(113);
                                val = this.Expr();
                                kvPairs.put((Object)key, (Object)val);
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 134: {
                                    this.jj_consume_token(134);
                                    break block3;
                                }
                            }
                            this.jj_la1[78] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                        }
                    }
                    closeParen = this.jj_consume_token(136);
                    SourceLocation srcLoc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
                    if ("" != null) {
                        return new MapLiteralNode((ImmutableMap<ExprNode, ExprNode>)kvPairs.build(), srcLoc);
                    }
                } else {
                    block9 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 124: 
                        case 128: 
                        case 131: 
                        case 135: 
                        case 138: 
                        case 139: 
                        case 140: {
                            ExprNode key = this.Expr();
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 113: {
                                    this.jj_consume_token(113);
                                    ExprNode val = this.Expr();
                                    if (!(key instanceof GlobalNode) || !BaseUtils.isIdentifier(((GlobalNode)key).getName())) {
                                        this.errorReporter.report(key.getSourceLocation(), INVALID_PARAM_NAME, key.toSourceString());
                                        key = GlobalNode.error(key.getSourceLocation());
                                    }
                                    LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
                                    paramNames.add(((GlobalNode)key).getName());
                                    params.add(val);
                                    block23: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 134: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[80] = this.jj_gen;
                                                break block23;
                                            }
                                        }
                                        this.jj_consume_token(134);
                                        Token paramName = this.jj_consume_token(138);
                                        if (!paramNames.add(paramName.image)) {
                                            this.errorReporter.report(this.createSrcLoc(paramName, new Token[0]), DUPLICATE_PARAM_NAME, paramName.image);
                                        }
                                        this.jj_consume_token(113);
                                        val = this.Expr();
                                        params.add(val);
                                    }
                                    closeParen = this.jj_consume_token(136);
                                    ProtoInitNode pNode = new ProtoInitNode(this.headerInfo.resolveAlias(ident.identifier()), paramNames, ident.location().extend(this.createSrcLoc(closeParen, new Token[0])));
                                    pNode.addChildren((List<? extends ExprNode>)params);
                                    if ("" == null) break block9;
                                    return pNode;
                                }
                                case 134: 
                                case 136: {
                                    params.add(key);
                                    block24: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                            case 134: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[81] = this.jj_gen;
                                                break block24;
                                            }
                                        }
                                        this.jj_consume_token(134);
                                        ExprNode val = this.Expr();
                                        params.add(val);
                                    }
                                    closeParen = this.jj_consume_token(136);
                                    SourceLocation loc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
                                    FunctionNode fnNode = new FunctionNode(this.pluginResolver.lookupSoyFunction(ident.identifier(), params.size(), loc), loc);
                                    fnNode.addChildren((List<? extends ExprNode>)params);
                                    if ("" == null) break block9;
                                    return fnNode;
                                }
                                default: {
                                    this.jj_la1[82] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        default: {
                            this.jj_la1[83] = this.jj_gen;
                        }
                    }
                }
                closeParen = this.jj_consume_token(136);
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
        if (openParen == null && "" != null) {
            return new GlobalNode(this.headerInfo.resolveAlias(ident.identifier()), ident.location());
        }
        String name = ident.identifier();
        String resolvedName = this.headerInfo.resolveAlias(name);
        SourceLocation loc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        SoyType soyType = type = this.typeRegistry == null ? null : this.typeRegistry.getType(resolvedName);
        if (type != null && type.getKind() == SoyType.Kind.PROTO) {
            if ("" != null) {
                return new ProtoInitNode(resolvedName, (Iterable<String>)ImmutableList.of(), loc);
            }
        } else if ("" != null) {
            return new FunctionNode(this.pluginResolver.lookupSoyFunction(name, 0, loc), loc);
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode CollectionLiteral() throws ParseException {
        Object items = ImmutableList.of();
        Token begin = this.jj_consume_token(131);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 113: {
                this.jj_consume_token(113);
                Token end = this.jj_consume_token(132);
                if ("" == null) break;
                return new LegacyObjectMapLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 132: {
                Token end = this.jj_consume_token(132);
                if ("" == null) break;
                return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 138: 
            case 139: 
            case 140: {
                ExprNode itemExpr = this.MapKeyOrExpr();
                items = new ArrayList();
                items.add(itemExpr);
                if (this.jj_2_1(1)) {
                    while (this.getToken((int)1).kind == 134 && this.getToken((int)2).kind != 132) {
                        this.jj_consume_token(134);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 134: {
                            this.jj_consume_token(134);
                            break;
                        }
                        default: {
                            this.jj_la1[85] = this.jj_gen;
                        }
                    }
                    Token end = this.jj_consume_token(132);
                    if ("" == null) break;
                    return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 113: {
                        this.jj_consume_token(113);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                        while (this.getToken((int)1).kind == 134 && this.getToken((int)2).kind != 132) {
                            this.jj_consume_token(134);
                            itemExpr = this.MapKeyOrExpr();
                            items.add(itemExpr);
                            this.jj_consume_token(113);
                            itemExpr = this.Expr();
                            items.add(itemExpr);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 134: {
                                this.jj_consume_token(134);
                                break;
                            }
                            default: {
                                this.jj_la1[86] = this.jj_gen;
                            }
                        }
                        Token end = this.jj_consume_token(132);
                        if ("" == null) break block0;
                        return new LegacyObjectMapLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode MapKeyOrExpr() throws ParseException {
        ExprNode itemExpr;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Token ident = this.jj_consume_token(138);
            itemExpr = new GlobalNode(this.headerInfo.resolveAlias(ident.image), this.createSrcLoc(ident, new Token[0]));
            this.errorReporter.report(this.createSrcLoc(ident, new Token[0]), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 124: 
                case 128: 
                case 131: 
                case 135: 
                case 138: 
                case 139: 
                case 140: {
                    itemExpr = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return itemExpr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 97: {
                Token tok = this.jj_consume_token(97);
                primitive = new NullNode(this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 98: {
                Token tok = this.jj_consume_token(98);
                primitive = new BooleanNode(true, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 99: {
                Token tok = this.jj_consume_token(99);
                primitive = new BooleanNode(false, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 100: {
                Token tok = this.jj_consume_token(100);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image, (int)10);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 101: {
                Token tok = this.jj_consume_token(101);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image.substring(2), (int)16);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 102: {
                Token tok = this.jj_consume_token(102);
                primitive = new FloatNode(Double.parseDouble(tok.image), this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 103: 
            case 104: {
                QuoteStyle quoteStyle;
                Token tok;
                Token quote;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 103: {
                        quote = this.jj_consume_token(103);
                        tok = this.jj_consume_token(105);
                        quoteStyle = QuoteStyle.SINGLE;
                        break;
                    }
                    case 104: {
                        quote = this.jj_consume_token(104);
                        tok = this.jj_consume_token(106);
                        quoteStyle = QuoteStyle.DOUBLE;
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                SourceLocation loc = this.createSrcLoc(quote, tok);
                String rawString = tok.image.substring(0, tok.image.length() - 1);
                String unescaped = SoyParseUtils.unescapeString(rawString, this.errorReporter, loc);
                primitive = new StringNode(unescaped, quoteStyle, loc);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primitive;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier Identifier() throws ParseException {
        Token next = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(138);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 129: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(129);
            next = this.jj_consume_token(138);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append('.').append(next.image);
        }
        if ("" != null) {
            return sb == null ? Identifier.create(first.image, this.createSrcLoc(first, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(first, next));
        }
        throw new Error("Missing return statement in function");
    }

    private final Token Keyword(String keyword) throws ParseException {
        Token ident = this.jj_consume_token(138);
        if (!ident.image.equals(keyword)) {
            throw this.generateParseException();
        }
        if ("" != null) {
            return ident;
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode TypeExpr() throws ParseException {
        TypeNode first = null;
        TypeNode next = null;
        ArrayList<TypeNode> members = null;
        first = this.PrimaryType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(137);
            next = this.PrimaryType();
            if (members == null) {
                members = new ArrayList<TypeNode>();
                members.add(first);
            }
            members.add(next);
        }
        if ("" != null) {
            return members == null ? first : UnionTypeNode.create((Iterable<TypeNode>)members);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode PrimaryType() throws ParseException {
        TypeNode type;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                type = this.NamedType();
                break;
            }
            case 97: {
                type = this.NullType();
                break;
            }
            case 112: {
                type = this.UnknownType();
                break;
            }
            case 131: {
                type = this.RecordType();
                break;
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return type;
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode RecordType() throws ParseException {
        Object properties = ImmutableList.of();
        Token open = this.jj_consume_token(131);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                RecordTypeNode.Property prop = this.RecordField();
                properties = new ArrayList();
                properties.add(prop);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 134: {
                            break;
                        }
                        default: {
                            this.jj_la1[95] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(134);
                    prop = this.RecordField();
                    properties.add(prop);
                }
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(132);
        if ("" != null) {
            return RecordTypeNode.create(this.createSrcLoc(open, close), (Iterable<RecordTypeNode.Property>)properties);
        }
        throw new Error("Missing return statement in function");
    }

    private final RecordTypeNode.Property RecordField() throws ParseException {
        Token fieldName = this.jj_consume_token(138);
        this.jj_consume_token(113);
        TypeNode fieldType = this.TypeExpr();
        if ("" != null) {
            return RecordTypeNode.Property.create(this.createSrcLoc(fieldName, new Token[0]), fieldName.image, fieldType);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode NullType() throws ParseException {
        Token tok = this.jj_consume_token(97);
        if ("" != null) {
            return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), tok.image);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode NamedType() throws ParseException {
        Token next = null;
        Object genericArgs = ImmutableList.of();
        StringBuilder sb = null;
        Token first = this.jj_consume_token(138);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 129: {
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(129);
            next = this.jj_consume_token(138);
            if (sb == null) {
                sb = new StringBuilder(first.image);
            }
            sb.append('.');
            sb.append(next.image);
        }
        String ident = this.headerInfo.resolveAlias(sb == null ? first.image : sb.toString());
        SourceLocation fullLocation = next == null ? this.createSrcLoc(first, new Token[0]) : this.createSrcLoc(first, next);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 119: {
                Token open = this.jj_consume_token(119);
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 97: 
                    case 112: 
                    case 131: 
                    case 138: {
                        TypeNode arg = this.TypeExpr();
                        genericArgs = new ArrayList();
                        genericArgs.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 134: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[98] = this.jj_gen;
                                    break block6;
                                }
                            }
                            this.jj_consume_token(134);
                            arg = this.TypeExpr();
                            genericArgs.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                    }
                }
                Token close = this.jj_consume_token(120);
                if ("" == null) break;
                return GenericTypeNode.create(fullLocation.extend(this.createSrcLoc(close, new Token[0])), ident, (Iterable<? extends TypeNode>)genericArgs);
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
            }
        }
        if ("" != null) {
            return NamedTypeNode.create(fullLocation, ident);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode UnknownType() throws ParseException {
        Token tok = this.jj_consume_token(112);
        if ("" != null) {
            return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), "?");
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_1() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_36());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(134)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(132);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(134);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4096, 1024, 0, 0, 8355840, 24576, 2785280, 0, 0x550000, 0, 8355840, 8355840, 0x1800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 130048, 261120, 261120, 480, 0, 480, 480, 957348864, 957348864, 957087744, 0, 420216832, 0x20000000, 0x2000000, 0, 0, 957348864, 0, 957348864, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 786432, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0x12000000, 0x10000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, -2143477238, -2143477238, 4006410, 0x250002, 0x180000, 8712, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, -2143477078, 160, -2143477078, 0, 2048, 2048, 0x180000, 0, 0, 0, 0, 0, 0x800000, 0, 0, 2048, 4096, 16384, 0x1800000, 0x1800000, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 268435966, 0, 268435966, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 327680, 327680, 524288, 0x100000, 0x600000, 0x600000, 0x7800000, 0x7800000, 0x18000000, 0x18000000, -536870912, -536870912, 0x10000000, 268435966, 0, 0, 0, 0, 510, 0, 268435966, 0, 0, 131072, 268435966, 0, 0, 0, 131072, 268567038, 268435966, 384, 510, 0, 0, 65538, 0, 0, 0, 0, 65538, 0x800000};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 1024, 0, 0, 0, 7305, 0, 7305, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 1024, 1024, 512, 0, 1024, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 7305, 46, 6, 40, 46, 7304, 64, 7305, 64, 64, 320, 7305, 128, 64, 64, 0, 7321, 7305, 0, 0, 2, 512, 1032, 64, 1024, 2, 64, 1032, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[158];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 101; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 158; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
        SoyFileParser.jj_la1_init_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class AbortParsingError
    extends Error {
        AbortParsingError() {
        }
    }
}

