/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.soytree.EscapingMode;
import javax.annotation.Nullable;

public enum HtmlContext {
    HTML_PCDATA(EscapingMode.ESCAPE_HTML),
    HTML_RCDATA(EscapingMode.ESCAPE_HTML_RCDATA),
    HTML_BEFORE_OPEN_TAG_NAME(EscapingMode.FILTER_HTML_ELEMENT_NAME),
    HTML_BEFORE_CLOSE_TAG_NAME(EscapingMode.FILTER_HTML_ELEMENT_NAME),
    HTML_TAG_NAME("Dynamic values are not permitted in the middle of an HTML tag name; try adding a space before."),
    HTML_TAG(EscapingMode.FILTER_HTML_ATTRIBUTES),
    HTML_ATTRIBUTE_NAME(EscapingMode.FILTER_HTML_ATTRIBUTES),
    HTML_COMMENT(EscapingMode.ESCAPE_HTML_RCDATA),
    HTML_NORMAL_ATTR_VALUE(EscapingMode.ESCAPE_HTML_ATTRIBUTE),
    CSS(EscapingMode.FILTER_CSS_VALUE),
    CSS_COMMENT("CSS comments cannot contain dynamic values."),
    CSS_DQ_STRING(EscapingMode.ESCAPE_CSS_STRING),
    CSS_SQ_STRING(EscapingMode.ESCAPE_CSS_STRING),
    CSS_URI(EscapingMode.NORMALIZE_URI),
    CSS_DQ_URI(EscapingMode.NORMALIZE_URI),
    CSS_SQ_URI(EscapingMode.NORMALIZE_URI),
    JS(EscapingMode.ESCAPE_JS_VALUE),
    JS_LINE_COMMENT("JS comments cannot contain dynamic values."),
    JS_BLOCK_COMMENT("JS comments cannot contain dynamic values."),
    JS_DQ_STRING(EscapingMode.ESCAPE_JS_STRING),
    JS_SQ_STRING(EscapingMode.ESCAPE_JS_STRING),
    JS_REGEX(EscapingMode.ESCAPE_JS_REGEX),
    JS_TEMPLATE_LITERAL("Js template literals cannot contain dynamic values"),
    URI(EscapingMode.NORMALIZE_URI),
    TEXT(EscapingMode.TEXT);

    @Nullable
    private final EscapingMode escapingMode;
    @Nullable
    private final String errorMessage;

    public EscapingMode getEscapingMode() {
        return this.escapingMode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private HtmlContext(EscapingMode escapingMode) {
        this.escapingMode = escapingMode;
        this.errorMessage = null;
    }

    private HtmlContext(String errorMessage) {
        this.errorMessage = errorMessage;
        this.escapingMode = null;
    }
}

