/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.AutoValue_MsgHtmlTagNode_SamenessKey;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.MessagePlaceholders;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import javax.annotation.Nullable;

public final class MsgHtmlTagNode
extends AbstractBlockNode
implements SoyNode.MsgPlaceholderInitialNode {
    private static final SoyErrorKind DYNAMIC_TAG_NAME_IN_MSG_BLOCK = SoyErrorKind.of("HTML tags within within ''msg'' blocks must use constant tag names.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_ATTRIBUTE = SoyErrorKind.of("''{0}'' attribute is not a constant.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_ATTRIBUTES = SoyErrorKind.of("Multiple ''{0}'' attributes in HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableMap<String, String> LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP = ImmutableMap.builder().put((Object)"a", (Object)"link").put((Object)"br", (Object)"break").put((Object)"b", (Object)"bold").put((Object)"i", (Object)"italic").put((Object)"li", (Object)"item").put((Object)"ol", (Object)"ordered_list").put((Object)"ul", (Object)"unordered_list").put((Object)"p", (Object)"paragraph").put((Object)"img", (Object)"image").put((Object)"em", (Object)"emphasis").build();
    private final String lcTagName;
    private final boolean isSelfEnding;
    @Nullable
    private final Object samenessKey;
    @Nullable
    private final String userSuppliedPlaceholderName;
    @Nullable
    private final String userSuppliedPlaceholderExample;
    private static final CharMatcher INVALID_PLACEHOLDER_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'_')).negate().precomputed();

    public static MsgHtmlTagNode fromNode(int id, HtmlTagNode tagNode, ErrorReporter errorReporter) {
        RawTextNode userSpecifiedPhExample = MsgHtmlTagNode.getAttributeValue(tagNode, "phex", errorReporter);
        String phExample = null;
        if (userSpecifiedPhExample != null) {
            phExample = MessagePlaceholders.validatePlaceholderExample(userSpecifiedPhExample.getRawText(), userSpecifiedPhExample.getSourceLocation(), errorReporter);
        }
        RawTextNode userSpecifiedPhName = MsgHtmlTagNode.getAttributeValue(tagNode, "phname", errorReporter);
        String phName = null;
        if (userSpecifiedPhName != null) {
            phName = MessagePlaceholders.validatePlaceholderName(userSpecifiedPhName.getRawText(), userSpecifiedPhName.getSourceLocation(), errorReporter);
        }
        String fullTagText = MsgHtmlTagNode.getFullTagText(tagNode);
        String lcTagName = MsgHtmlTagNode.getLcTagName(errorReporter, tagNode.getTagName());
        if (tagNode instanceof HtmlCloseTagNode) {
            lcTagName = "/" + lcTagName;
        }
        return new MsgHtmlTagNode(id, tagNode.getSourceLocation(), phName, phExample, lcTagName, tagNode instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)tagNode).isSelfClosing(), fullTagText != null ? SamenessKey.create(phName, fullTagText) : null, tagNode);
    }

    @Nullable
    private static String getFullTagText(HtmlTagNode openTagNode) {
        class Visitor
        implements NodeVisitor<Node, SoyTreeUtils.VisitDirective> {
            boolean isConstantContent = true;

            Visitor() {
            }

            @Override
            public SoyTreeUtils.VisitDirective exec(Node node) {
                if (node instanceof RawTextNode || node instanceof HtmlAttributeNode || node instanceof HtmlAttributeValueNode || node instanceof HtmlOpenTagNode || node instanceof HtmlCloseTagNode) {
                    return SoyTreeUtils.VisitDirective.CONTINUE;
                }
                this.isConstantContent = false;
                return SoyTreeUtils.VisitDirective.ABORT;
            }
        }
        Visitor visitor = new Visitor();
        SoyTreeUtils.visitAllNodes(openTagNode, visitor);
        if (visitor.isConstantContent) {
            return openTagNode.toSourceString();
        }
        return null;
    }

    @Nullable
    private static RawTextNode getAttributeValue(HtmlTagNode tagNode, String name, ErrorReporter errorReporter) {
        HtmlAttributeNode attribute = tagNode.getDirectAttributeNamed(name);
        if (attribute == null) {
            return null;
        }
        RawTextNode value = MsgHtmlTagNode.getAttributeValue(attribute, name, errorReporter);
        tagNode.removeChild(attribute);
        attribute = tagNode.getDirectAttributeNamed(name);
        if (attribute != null) {
            errorReporter.report(attribute.getSourceLocation(), MULTIPLE_ATTRIBUTES, name);
        }
        return value;
    }

    @Nullable
    private static RawTextNode getAttributeValue(HtmlAttributeNode htmlAttributeNode, String name, ErrorReporter errorReporter) {
        HtmlAttributeValueNode attributeValueNode;
        SoyNode.StandaloneNode valueNode = (SoyNode.StandaloneNode)htmlAttributeNode.getChild(1);
        if (valueNode instanceof HtmlAttributeValueNode && (attributeValueNode = (HtmlAttributeValueNode)valueNode).numChildren() == 1 && attributeValueNode.getChild(0) instanceof RawTextNode) {
            return (RawTextNode)attributeValueNode.getChild(0);
        }
        errorReporter.report(valueNode.getSourceLocation(), INVALID_ATTRIBUTE, name);
        return null;
    }

    private static String getLcTagName(ErrorReporter errorReporter, TagName tagName) {
        String lcTagName;
        if (!tagName.isStatic()) {
            errorReporter.report(tagName.getTagLocation(), DYNAMIC_TAG_NAME_IN_MSG_BLOCK, new Object[0]);
            lcTagName = "error";
        } else {
            lcTagName = tagName.getStaticTagNameAsLowerCase();
        }
        return lcTagName;
    }

    private MsgHtmlTagNode(int id, SourceLocation sourceLocation, @Nullable String userSuppliedPlaceholderName, @Nullable String userSuppliedPlaceholderExample, String lcTagName, boolean isSelfEnding, Object samenessKey, SoyNode.StandaloneNode child) {
        super(id, sourceLocation);
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
        this.userSuppliedPlaceholderExample = userSuppliedPlaceholderExample;
        this.lcTagName = lcTagName;
        this.isSelfEnding = isSelfEnding;
        this.samenessKey = samenessKey;
        this.addChild(child);
    }

    private MsgHtmlTagNode(MsgHtmlTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.lcTagName = orig.lcTagName;
        this.isSelfEnding = orig.isSelfEnding;
        this.samenessKey = orig.samenessKey;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.userSuppliedPlaceholderExample = orig.userSuppliedPlaceholderExample;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_HTML_TAG_NODE;
    }

    public String getLcTagName() {
        return this.lcTagName;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhExample() {
        return this.userSuppliedPlaceholderExample;
    }

    @Override
    public String genBasePhName() {
        String basePlaceholderName;
        String baseLcTagName;
        boolean isEndTag;
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        if (this.lcTagName.startsWith("/")) {
            isEndTag = true;
            baseLcTagName = this.lcTagName.substring(1);
        } else {
            isEndTag = false;
            baseLcTagName = this.lcTagName;
        }
        String string = basePlaceholderName = LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.containsKey((Object)baseLcTagName) ? (String)LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.get((Object)baseLcTagName) : baseLcTagName;
        if (isEndTag) {
            basePlaceholderName = "end_" + basePlaceholderName;
        } else if (!this.isSelfEnding) {
            basePlaceholderName = "start_" + basePlaceholderName;
        }
        basePlaceholderName = INVALID_PLACEHOLDER_CHARS.replaceFrom((CharSequence)basePlaceholderName, '_');
        return Ascii.toUpperCase((String)basePlaceholderName);
    }

    @Override
    public Object genSamenessKey() {
        return this.samenessKey == null ? this : this.samenessKey;
    }

    @Override
    public String toSourceString() {
        int indexBeforeClose;
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        if (this.isSelfEnding ? !sb.substring(indexBeforeClose = sb.length() - 2).equals("/>") : !sb.substring(indexBeforeClose = sb.length() - 1).equals(">")) {
            throw new AssertionError();
        }
        if (this.userSuppliedPlaceholderExample != null) {
            sb.insert(indexBeforeClose, " phex=\"" + this.userSuppliedPlaceholderExample + "\"");
        }
        if (this.userSuppliedPlaceholderName != null) {
            sb.insert(indexBeforeClose, " phname=\"" + this.userSuppliedPlaceholderName + "\"");
        }
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgHtmlTagNode copy(CopyState copyState) {
        return new MsgHtmlTagNode(this, copyState);
    }

    static abstract class SamenessKey {
        SamenessKey() {
        }

        static SamenessKey create(String userSuppliedPlaceholderName, String fullTagText) {
            return new AutoValue_MsgHtmlTagNode_SamenessKey(userSuppliedPlaceholderName, fullTagText);
        }

        @Nullable
        abstract String userSuppliedPlaceholderName();

        @Nullable
        abstract String fullTagText();
    }
}

