/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class PrintDirectiveNode
extends AbstractSoyNode
implements SoyNode.ExprHolderNode {
    private final SoyPrintDirective printDirective;
    private final ImmutableList<ExprRootNode> args;
    private final boolean isSynthetic;

    public PrintDirectiveNode(int id, SourceLocation location, ImmutableList<ExprNode> args, SoyPrintDirective printDirective, boolean isSynthetic) {
        super(id, location);
        this.args = ExprRootNode.wrap(args);
        this.printDirective = (SoyPrintDirective)Preconditions.checkNotNull((Object)printDirective);
        this.isSynthetic = isSynthetic;
    }

    private PrintDirectiveNode(PrintDirectiveNode orig, CopyState copyState) {
        super(orig, copyState);
        ArrayList tempArgs = Lists.newArrayListWithCapacity((int)orig.args.size());
        for (ExprRootNode origArg : orig.args) {
            tempArgs.add(origArg.copy(copyState));
        }
        this.args = ImmutableList.copyOf((Collection)tempArgs);
        this.printDirective = orig.printDirective;
        this.isSynthetic = orig.isSynthetic;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_DIRECTIVE_NODE;
    }

    public String getName() {
        return this.printDirective.getName();
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public List<ExprRootNode> getArgs() {
        return this.args;
    }

    @Override
    public String toSourceString() {
        return this.args.isEmpty() ? this.getName() : this.getName() + ":" + SoyTreeUtils.toSourceString(this.args);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return this.args;
    }

    @Override
    public PrintDirectiveNode copy(CopyState copyState) {
        return new PrintDirectiveNode(this, copyState);
    }

    public SoyPrintDirective getPrintDirective() {
        return this.printDirective;
    }
}

