/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class TagName {
    private static final ImmutableSet<String> VOID_TAG_NAMES = ImmutableSet.of((Object)"area", (Object)"base", (Object)"br", (Object)"col", (Object)"command", (Object)"embed", (Object[])new String[]{"hr", "img", "input", "keygen", "link", "meta", "param", "plaintext", "source", "track", "wbr"});
    private static final ImmutableSetMultimap<String, String> OPTIONAL_TAG_POPPING_RULES = new ImmutableSetMultimap.Builder().putAll((Object)"head", (Object[])new String[]{"body", "html"}).put((Object)"body", (Object)"html").putAll((Object)"li", (Object[])new String[]{"ul", "ol"}).put((Object)"dt", (Object)"dl").put((Object)"dd", (Object)"dl").put((Object)"rb", (Object)"ruby").put((Object)"rt", (Object)"ruby").put((Object)"rtc", (Object)"ruby").put((Object)"rp", (Object)"ruby").put((Object)"optgroup", (Object)"select").putAll((Object)"option", (Object[])new String[]{"select", "datalist", "optgroup"}).put((Object)"colgroup", (Object)"table").put((Object)"thead", (Object)"table").put((Object)"tbody", (Object)"table").put((Object)"tfoot", (Object)"table").putAll((Object)"tr", (Object[])new String[]{"thead", "tbody", "tfoot", "table"}).putAll((Object)"td", (Object[])new String[]{"tr", "thead", "tbody", "tfoot", "table"}).putAll((Object)"th", (Object[])new String[]{"tr", "thead", "tbody", "tfoot", "table"}).build();
    private static final ImmutableSet<String> SPECIAL_OPTIONAL_TAG_NAMES = ImmutableSet.of((Object)"html", (Object)"p");
    private final SoyNode.StandaloneNode node;
    @Nullable
    private final String nameAsLowerCase;
    @Nullable
    private final RcDataTagName rcDataTagName;

    public TagName(RawTextNode node) {
        this.node = (SoyNode.StandaloneNode)Preconditions.checkNotNull((Object)node);
        switch (this.nameAsLowerCase = Ascii.toLowerCase((String)node.getRawText())) {
            case "script": {
                this.rcDataTagName = RcDataTagName.SCRIPT;
                break;
            }
            case "style": {
                this.rcDataTagName = RcDataTagName.STYLE;
                break;
            }
            case "textarea": {
                this.rcDataTagName = RcDataTagName.TEXTAREA;
                break;
            }
            case "title": {
                this.rcDataTagName = RcDataTagName.TITLE;
                break;
            }
            case "xmp": {
                this.rcDataTagName = RcDataTagName.XMP;
                break;
            }
            default: {
                this.rcDataTagName = null;
            }
        }
    }

    public TagName(PrintNode node) {
        this.node = (SoyNode.StandaloneNode)Preconditions.checkNotNull((Object)node);
        this.nameAsLowerCase = null;
        this.rcDataTagName = null;
    }

    public boolean isStatic() {
        return this.node instanceof RawTextNode;
    }

    public boolean isDefinitelyVoid() {
        return VOID_TAG_NAMES.contains((Object)this.nameAsLowerCase);
    }

    public boolean isDefinitelyOptional() {
        return SPECIAL_OPTIONAL_TAG_NAMES.contains((Object)this.nameAsLowerCase) || OPTIONAL_TAG_POPPING_RULES.containsKey((Object)this.nameAsLowerCase);
    }

    public static boolean checkOptionalTagShouldBePopped(TagName openTag, TagName closeTag) {
        String closeTagName;
        if (!openTag.isStatic() || !openTag.isDefinitelyOptional()) {
            return false;
        }
        if (!closeTag.isStatic()) {
            return true;
        }
        String openTagName = openTag.getStaticTagNameAsLowerCase();
        Preconditions.checkArgument((!openTagName.equals(closeTagName = closeTag.getStaticTagNameAsLowerCase()) ? 1 : 0) != 0);
        if (SPECIAL_OPTIONAL_TAG_NAMES.contains((Object)openTagName)) {
            return openTagName.equals("p");
        }
        return OPTIONAL_TAG_POPPING_RULES.containsEntry((Object)openTagName, (Object)closeTagName);
    }

    public boolean isForeignContent() {
        return "svg".equals(this.nameAsLowerCase);
    }

    @Nullable
    public RcDataTagName getRcDataTagName() {
        return this.rcDataTagName;
    }

    public String getStaticTagName() {
        Preconditions.checkState((boolean)this.isStatic());
        return ((RawTextNode)this.node).getRawText();
    }

    public String getStaticTagNameAsLowerCase() {
        Preconditions.checkState((boolean)this.isStatic());
        return this.nameAsLowerCase;
    }

    public SoyNode.StandaloneNode getNode() {
        return this.node;
    }

    public PrintNode getDynamicTagName() {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0);
        return (PrintNode)this.node;
    }

    public SourceLocation getTagLocation() {
        return this.node.getSourceLocation();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof TagName) {
            TagName tag = (TagName)other;
            if (this.isStatic() != tag.isStatic()) {
                return false;
            }
            if (this.isStatic()) {
                return this.nameAsLowerCase.equals(tag.nameAsLowerCase);
            }
            return PrintNode.PrintEquivalence.get().equivalent((PrintNode)this.node, (PrintNode)tag.node);
        }
        return false;
    }

    public int hashCode() {
        return this.isStatic() ? this.nameAsLowerCase.hashCode() : PrintNode.PrintEquivalence.get().hash((PrintNode)this.node);
    }

    public String toString() {
        return this.node.toSourceString();
    }

    public static enum RcDataTagName {
        SCRIPT,
        STYLE,
        TITLE,
        TEXTAREA,
        XMP;


        public String toString() {
            return Ascii.toLowerCase((String)this.name());
        }
    }
}

